/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl;

import java.util.Locale;
import org.apache.http.shade.HttpResponse;
import org.apache.http.shade.HttpResponseFactory;
import org.apache.http.shade.ProtocolVersion;
import org.apache.http.shade.ReasonPhraseCatalog;
import org.apache.http.shade.StatusLine;
import org.apache.http.shade.annotation.Immutable;
import org.apache.http.shade.impl.EnglishReasonPhraseCatalog;
import org.apache.http.shade.message.BasicHttpResponse;
import org.apache.http.shade.message.BasicStatusLine;
import org.apache.http.shade.protocol.HttpContext;
import org.apache.http.shade.util.Args;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

