/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl.client;

import org.apache.http.shade.HeaderElement;
import org.apache.http.shade.HttpResponse;
import org.apache.http.shade.annotation.Immutable;
import org.apache.http.shade.conn.ConnectionKeepAliveStrategy;
import org.apache.http.shade.message.BasicHeaderElementIterator;
import org.apache.http.shade.protocol.HttpContext;
import org.apache.http.shade.util.Args;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

