/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl.conn;

import org.apache.http.shade.HttpResponse;
import org.apache.http.shade.HttpResponseFactory;
import org.apache.http.shade.annotation.Immutable;
import org.apache.http.shade.config.MessageConstraints;
import org.apache.http.shade.impl.DefaultHttpResponseFactory;
import org.apache.http.shade.impl.conn.DefaultHttpResponseParser;
import org.apache.http.shade.io.HttpMessageParser;
import org.apache.http.shade.io.HttpMessageParserFactory;
import org.apache.http.shade.io.SessionInputBuffer;
import org.apache.http.shade.message.BasicLineParser;
import org.apache.http.shade.message.LineParser;

@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

