/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl.cookie;

import org.apache.http.shade.annotation.Immutable;
import org.apache.http.shade.cookie.CommonCookieAttributeHandler;
import org.apache.http.shade.cookie.Cookie;
import org.apache.http.shade.cookie.CookieOrigin;
import org.apache.http.shade.cookie.MalformedCookieException;
import org.apache.http.shade.cookie.SetCookie;
import org.apache.http.shade.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.http.shade.util.Args;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

