/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl.nio.client;

import java.io.Closeable;
import java.net.URI;
import java.util.concurrent.Future;
import org.apache.http.shade.HttpHost;
import org.apache.http.shade.HttpRequest;
import org.apache.http.shade.HttpResponse;
import org.apache.http.shade.annotation.ThreadSafe;
import org.apache.http.shade.client.ClientProtocolException;
import org.apache.http.shade.client.methods.HttpUriRequest;
import org.apache.http.shade.client.protocol.HttpClientContext;
import org.apache.http.shade.client.utils.URIUtils;
import org.apache.http.shade.concurrent.BasicFuture;
import org.apache.http.shade.concurrent.FutureCallback;
import org.apache.http.shade.nio.client.HttpAsyncClient;
import org.apache.http.shade.nio.client.methods.HttpAsyncMethods;
import org.apache.http.shade.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.shade.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.shade.protocol.HttpContext;
import org.apache.http.shade.util.Args;

@ThreadSafe
public abstract class CloseableHttpAsyncClient
implements HttpAsyncClient,
Closeable {
    public abstract boolean isRunning();

    public abstract void start();

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, (HttpContext)HttpClientContext.create(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        return this.execute(HttpAsyncMethods.create(target, request), HttpAsyncMethods.createConsumer(), context, callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, FutureCallback<HttpResponse> callback) {
        return this.execute(target, request, (HttpContext)HttpClientContext.create(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        return this.execute(request, HttpClientContext.create(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        HttpHost target;
        try {
            target = this.determineTarget(request);
        }
        catch (ClientProtocolException ex) {
            BasicFuture<HttpResponse> future = new BasicFuture<HttpResponse>(callback);
            future.failed(ex);
            return future;
        }
        return this.execute(target, request, context, callback);
    }

    private HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        Args.notNull(request, "HTTP request");
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost(requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }
}

