/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.impl.nio.codecs;

import org.apache.http.shade.HttpResponse;
import org.apache.http.shade.HttpResponseFactory;
import org.apache.http.shade.annotation.Immutable;
import org.apache.http.shade.config.MessageConstraints;
import org.apache.http.shade.impl.DefaultHttpResponseFactory;
import org.apache.http.shade.impl.nio.codecs.DefaultHttpResponseParser;
import org.apache.http.shade.message.BasicLineParser;
import org.apache.http.shade.message.LineParser;
import org.apache.http.shade.nio.NHttpMessageParser;
import org.apache.http.shade.nio.NHttpMessageParserFactory;
import org.apache.http.shade.nio.reactor.SessionInputBuffer;

@Immutable
public class DefaultHttpResponseParserFactory
implements NHttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public NHttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

