/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.protocol;

import java.io.IOException;
import org.apache.http.shade.HttpEntity;
import org.apache.http.shade.HttpEntityEnclosingRequest;
import org.apache.http.shade.HttpException;
import org.apache.http.shade.HttpRequest;
import org.apache.http.shade.HttpRequestInterceptor;
import org.apache.http.shade.HttpVersion;
import org.apache.http.shade.ProtocolVersion;
import org.apache.http.shade.annotation.Immutable;
import org.apache.http.shade.protocol.HttpContext;
import org.apache.http.shade.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

