/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.protocol;

import java.io.IOException;
import org.apache.http.shade.HttpException;
import org.apache.http.shade.HttpRequest;
import org.apache.http.shade.HttpRequestInterceptor;
import org.apache.http.shade.annotation.Immutable;
import org.apache.http.shade.params.HttpParams;
import org.apache.http.shade.protocol.HttpContext;
import org.apache.http.shade.util.Args;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

