/*
 * Decompiled with CFR 0.152.
 */
package com.modus.activity.document.shredder.edifact;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.modus.activity.document.shredder.DocumentShredder;
import com.modus.activity.document.shredder.edifact.EdifactMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class EdifactDocumentShredder
implements DocumentShredder<EdifactMessage, Map<String, Serializable>> {
    @Override
    public List<EdifactMessage> shred(Map<String, Serializable> document) {
        DocumentContext documentContext = JsonPath.parse(document, (Configuration)Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS}));
        ArrayList<EdifactMessage> messages = new ArrayList<EdifactMessage>();
        if (this.isReceiveContrl(documentContext)) {
            List functionalAcksReceived = (List)documentContext.read("$.FunctionalAcksReceived", new Predicate[0]);
            for (Map functionalAckReceived : functionalAcksReceived) {
                DocumentContext functionalAckReceivedDocumentContext = JsonPath.parse((Object)functionalAckReceived, (Configuration)Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS}));
                String version = (String)functionalAckReceivedDocumentContext.read("$.MessageHeader.UNH0202", new Predicate[0]);
                String releaseNo = (String)functionalAckReceivedDocumentContext.read("$.MessageHeader.UNH0203", new Predicate[0]);
                String versionReleaseNo = StringUtils.join((Object[])new String[]{version, releaseNo});
                String messageType = (String)functionalAckReceivedDocumentContext.read("$.MessageHeader.UNH0201", new Predicate[0]);
                HashMap<String, Object> fragment = new HashMap<String, Object>();
                for (Map.Entry<String, Serializable> entry : document.entrySet()) {
                    if (entry.getKey().equals("FunctionalAcksReceived")) continue;
                    fragment.put(entry.getKey(), entry.getValue());
                }
                fragment.put("FunctionalAcksReceived", Arrays.asList(functionalAckReceived));
                EdifactMessage edifactMessage = new EdifactMessage();
                edifactMessage.setType((Optional<String>)Optional.fromNullable((Object)messageType));
                edifactMessage.setVersion(versionReleaseNo);
                edifactMessage.setFragment(Optional.fromNullable(fragment));
                this.setIdentifier(edifactMessage, functionalAckReceivedDocumentContext, false);
                messages.add(edifactMessage);
            }
        } else if (this.isFaultyDocument(documentContext)) {
            List functionalAcksGenerated = (List)documentContext.read("$.FunctionalAcksGenerated", new Predicate[0]);
            for (Map functionalAckGenerated : functionalAcksGenerated) {
                DocumentContext functionalAckGeneratedDocumentContext = JsonPath.parse((Object)functionalAckGenerated, (Configuration)Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS}));
                String messageType = (String)functionalAckGeneratedDocumentContext.read("$.Interchange.UNB07", new Predicate[0]);
                HashMap<String, Object> fragment = new HashMap<String, Object>();
                for (Map.Entry<String, Serializable> entry : document.entrySet()) {
                    if (entry.getKey().equals("FunctionalAcksGenerated")) continue;
                    fragment.put(entry.getKey(), entry.getValue());
                }
                fragment.put("FunctionalAcksGenerated", Arrays.asList(functionalAckGenerated));
                EdifactMessage edifactMessage = new EdifactMessage();
                edifactMessage.setType((Optional<String>)Optional.fromNullable((Object)messageType));
                edifactMessage.setFragment(Optional.fromNullable(fragment));
                this.setIdentifier(edifactMessage, functionalAckGeneratedDocumentContext, true);
                messages.add(edifactMessage);
            }
        } else {
            Map messagesByTypeAndVersionReleaseNumbers = (Map)documentContext.read("$.Messages", new Predicate[0]);
            for (Map.Entry messagesByTypeAndVersionReleaseNumber : messagesByTypeAndVersionReleaseNumbers.entrySet()) {
                for (Map.Entry messagesByType : ((Map)messagesByTypeAndVersionReleaseNumber.getValue()).entrySet()) {
                    for (Map message : (List)messagesByType.getValue()) {
                        DocumentContext messageDocumentContext = JsonPath.parse((Object)message, (Configuration)Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS}));
                        String version = (String)messageDocumentContext.read("$.MessageHeader.UNH0202", new Predicate[0]);
                        String releaseNo = (String)messageDocumentContext.read("$.MessageHeader.UNH0203", new Predicate[0]);
                        String versionReleaseNo = StringUtils.join((Object[])new String[]{version, releaseNo});
                        String messageType = (String)messageDocumentContext.read("$.MessageHeader.UNH0201", new Predicate[0]);
                        HashMap<String, Serializable> fragment = new HashMap<String, Serializable>();
                        for (Map.Entry<String, Serializable> entry : document.entrySet()) {
                            if (entry.getKey().equals("Messages")) continue;
                            fragment.put(entry.getKey(), entry.getValue());
                        }
                        fragment.put("Messages", (Serializable)ImmutableMap.of(messagesByTypeAndVersionReleaseNumber.getKey(), (Object)ImmutableMap.of(messagesByType.getKey(), Arrays.asList(message))));
                        EdifactMessage edifactMessage = new EdifactMessage();
                        edifactMessage.setType((Optional<String>)Optional.fromNullable((Object)messageType));
                        edifactMessage.setVersion(versionReleaseNo);
                        edifactMessage.setFragment(Optional.fromNullable(fragment));
                        this.setIdentifier(edifactMessage, messageDocumentContext, false);
                        messages.add(edifactMessage);
                    }
                }
            }
        }
        return messages;
    }

    private boolean isReceiveContrl(DocumentContext documentContext) {
        List functionalAcksReceived = (List)documentContext.read("$.FunctionalAcksReceived", new Predicate[0]);
        return functionalAcksReceived != null && !functionalAcksReceived.isEmpty();
    }

    private boolean isFaultyDocument(DocumentContext documentContext) {
        Map messages = (Map)documentContext.read("$.Messages", new Predicate[0]);
        return messages == null || messages.isEmpty();
    }

    private void setIdentifier(EdifactMessage edifactMessage, DocumentContext documentContext, boolean isFaulty) {
        if (isFaulty) {
            edifactMessage.setInterchangeReceiverId((String)documentContext.read("$.Heading.0020_UCI.UCI0301", new Predicate[0]));
            edifactMessage.setInterchangeReceiverIdQualifier((String)documentContext.read("$.Heading.0020_UCI.UCI0302", new Predicate[0]));
            edifactMessage.setInterchangeSenderId((String)documentContext.read("$.Heading.0020_UCI.UCI0201", new Predicate[0]));
            edifactMessage.setInterchangeSenderIdQualifier((String)documentContext.read("$.Heading.0020_UCI.UCI0202", new Predicate[0]));
            edifactMessage.setInterchangeControlReference((String)documentContext.read("$.Heading.0020_UCI.UCI01", new Predicate[0]));
        } else {
            edifactMessage.setInterchangeReceiverId((String)documentContext.read("$.Interchange.UNB0301", new Predicate[0]));
            edifactMessage.setInterchangeReceiverIdQualifier((String)documentContext.read("$.Interchange.UNB0302", new Predicate[0]));
            edifactMessage.setInterchangeSenderId((String)documentContext.read("$.Interchange.UNB0201", new Predicate[0]));
            edifactMessage.setInterchangeSenderIdQualifier((String)documentContext.read("$.Interchange.UNB0202", new Predicate[0]));
            edifactMessage.setInterchangeControlReference((String)documentContext.read("$.Interchange.UNB05", new Predicate[0]));
        }
    }
}

