/*
 * Decompiled with CFR 0.152.
 */
package com.modus.activity.payload;

import com.modus.activity.payload.ApiKeySecurityContext;
import com.modus.activity.payload.BasicSecurityContext;
import com.modus.activity.payload.ClientIDSecurityContext;
import com.modus.activity.payload.PingFederateSecurityContext;
import com.modus.activity.payload.S3SecurityContext;
import com.modus.activity.payload.SecurityConfigConfigToMap;
import com.modus.activity.payload.SecurityContext;
import com.modus.tpm.api.model.SecurityConfig;
import com.modus.tpm.client.TpmClient;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SecurityContextFactory
implements ApplicationContextAware {
    private static final Map<SecurityConfig.Scheme, Class<? extends SecurityContext>> classes = new HashMap<SecurityConfig.Scheme, Class<? extends SecurityContext>>(){
        {
            this.put(SecurityConfig.Scheme.S_3_BUCKET, S3SecurityContext.class);
            this.put(SecurityConfig.Scheme.API_KEY, ApiKeySecurityContext.class);
            this.put(SecurityConfig.Scheme.BASIC, BasicSecurityContext.class);
            this.put(SecurityConfig.Scheme.CLIENT_ID, ClientIDSecurityContext.class);
            this.put(SecurityConfig.Scheme.PING_FEDERATE_CLIENT_CREDENTIALS, PingFederateSecurityContext.class);
        }
    };
    @Inject
    SecurityConfigConfigToMap securityConfigConfigToMap;
    ApplicationContext applicationContext;

    public SecurityContext createSecurityContext(TpmClient tpmClient) {
        try {
            SecurityConfig securityConfig = tpmClient.getSecurityConfig();
            SecurityContext securityContext = (SecurityContext)this.applicationContext.getBean(classes.get(securityConfig.getScheme()));
            securityContext.setConfigParameters(this.securityConfigConfigToMap.getMap(securityConfig.getConfig()));
            securityContext.initialize(tpmClient);
            return securityContext;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

