/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.modus.activity.document.reader.DefaultDocumentReader;
import com.modus.activity.document.reader.DocumentEnvelope;
import com.modus.activity.document.reader.DocumentReader;
import com.modus.activity.document.reader.csv.CsvDocumentReader;
import com.modus.activity.document.reader.edifact.EdifactDocumentReader;
import com.modus.activity.document.reader.json.JsonDocumentReader;
import com.modus.activity.document.reader.x12.X12DocumentReader;
import com.modus.activity.document.reader.xml.XmlDocumentReader;
import com.modus.activity.payload.Payload;
import com.modus.mule.modules.apm.AsyncTransactionSynchronizer;
import com.modus.mule.modules.apm.ConnectorContext;
import com.modus.mule.modules.apm.DocumentReadersSetup;
import com.modus.mule.modules.apm.PartnerManagerConnectorException;
import com.modus.mule.modules.apm.PropertyReader;
import com.modus.mule.modules.apm.b2b.adapter.AbstractB2BProviderApiAdapter;
import com.modus.mule.modules.apm.b2b.adapter.As2B2BProviderApiAdapter;
import com.modus.mule.modules.apm.b2b.adapter.B2BProviderApiAdapter;
import com.modus.mule.modules.apm.b2b.adapter.EdifactB2BProviderApiAdapter;
import com.modus.mule.modules.apm.b2b.adapter.FtpB2BProviderApiAdapter;
import com.modus.mule.modules.apm.b2b.adapter.FtpsB2BProviderApiAdapter;
import com.modus.mule.modules.apm.b2b.adapter.X12B2BProviderApiAdapter;
import com.modus.mule.modules.apm.b2b.impl.DefaultConfig;
import com.modus.mule.modules.apm.b2b.impl.DefaultFactoryResolver;
import com.modus.mule.modules.apm.b2b.impl.DefaultTransmissionSession;
import com.modus.mule.modules.apm.cache.CacheAwareTpmClient;
import com.modus.mule.modules.apm.config.AmazonS3FileStorageConfig;
import com.modus.mule.modules.apm.config.BasicConfig;
import com.modus.mule.modules.apm.config.CustomFileStorageConfig;
import com.modus.mule.modules.apm.filestorage.AbstractFileStorageProvider;
import com.modus.mule.modules.apm.filestorage.FileStorageProvider;
import com.modus.mule.modules.apm.filestorage.FlowFileStorageProvider;
import com.modus.mule.modules.apm.filestorage.NullFileStorageProvider;
import com.modus.mule.modules.apm.filestorage.s3.S3FileStorageProvider;
import com.modus.tpm.api.model.Entry;
import com.modus.tpm.api.model.Partnership;
import com.modus.tpm.api.model.Route;
import com.modus.tpm.client.RouteResolutionServiceClient;
import com.modus.tpm.client.TpmClient;
import com.modus.tpm.client.TpmClientException;
import com.modus.tpm.client.impl.DefaultTpmClient;
import com.modus.tpm.client.model.DocumentLocator;
import com.modus.tpm.client.model.FilterSpecification;
import com.modus.tpm.client.model.OrganizationPath;
import com.modus.tracker.api.model.BusinessDocument;
import com.modus.tracker.api.model.Error;
import com.modus.tracker.api.model.Metadata;
import com.modus.tracker.api.model.Transmission;
import com.modus.tracker.client.TrackerClient;
import com.modus.tracker.client.TrackerClientException;
import com.modus.tracker.client.impl.DefaultTrackerClient;
import com.modus.tracker.model.TransactionCreate;
import com.mulesoft.api.b2b.B2BProvider;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.ConfigType;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.factory.FactoryResolver;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.api.b2b.transmission.TransmissionContext;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import com.mulesoft.mule.tracking.event.EventNotification;
import com.mulesoft.mule.tracking.event.EventNotificationListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.http.shade.pmc.client.HttpClient;
import org.apache.http.shade.pmc.client.config.RequestConfig;
import org.apache.http.shade.pmc.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.shade.pmc.impl.client.CloseableHttpClient;
import org.apache.http.shade.pmc.impl.client.HttpClientBuilder;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartnerManagerConnector
implements B2BProvider,
EventNotificationListener<EventNotification> {
    private static final Logger logger = LoggerFactory.getLogger(PartnerManagerConnector.class);
    public static final String TRACKER_MIN_API_VERSION = "v3.0";
    public static final String TPM_SERVICE_MIN_API_VERSION = "v6.0";
    private BasicConfig connectorConfig;
    @Inject
    private MuleContext muleContext;
    private ConnectorContext connectorContext;
    private List<B2BProviderApiAdapter> b2BProviderApiAdapters;
    private Cache<String, String> transactionIdMap;
    public static final String MULE_TRANSACTION_ID_SESSION_KEY = "muleTransactionId";
    public static final String TRANSACTION_ID_SESSION_KEY = "transactionId";
    public static final String PROPERTIES_SESSION_KEY = "properties";
    public static final String ORIGINAL_TRANSACTION_ID_SESSION_KEY = "originalTransactionId";
    public static final String PARENT_TRANSACTION_ID_SESSION_KEY = "parentTransactionId";
    public static final String MULE_EVENT_ID_SESSION_KEY = "muleEventId";
    public static final String OBJECT_STORE = "_partnerManagerConnectorObjectStore";
    private AsyncTransactionSynchronizer transactionSynchronizer;
    private PropertyReader propertyReader;
    private Map<Class, DocumentReader> documentReaders;
    private ObjectMapper objectMapper;
    private AsyncTransactionSynchronizer.TaskQueue taskQueue;

    public void onStop() throws PartnerManagerConnectorException {
        try {
            if (this.connectorConfig.getAsynchronousMode().booleanValue()) {
                this.transactionSynchronizer.stopSynchronizing();
            }
            if (this.connectorContext.getTpmClient() instanceof Closeable) {
                ((Closeable)((Object)this.connectorContext.getTpmClient())).close();
            }
            if (this.connectorContext.getTrackerClient() instanceof Closeable) {
                ((Closeable)((Object)this.connectorContext.getTrackerClient())).close();
            }
        }
        catch (IOException e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public void onStart() throws PartnerManagerConnectorException {
        try {
            this.objectMapper = new ObjectMapper();
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectorConfig.getConnectTimeoutMs()).setConnectionRequestTimeout(this.connectorConfig.getConnectionRequestTimeoutMs()).setSocketTimeout(this.connectorConfig.getSocketTimeoutMs()).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLHostnameVerifier(new DefaultHostnameVerifier(null)).setDefaultRequestConfig(requestConfig).build();
            this.connectorContext = new ConnectorContext();
            this.connectorContext.setFileStorageProvider(this.createFileStorageProvider(httpClient));
            this.connectorContext.setMuleContext(this.muleContext);
            this.transactionIdMap = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(5L, TimeUnit.MINUTES).build();
            this.initTracking(this.connectorConfig);
            this.initTpmClient(this.connectorConfig, httpClient);
            this.propertyReader = new PropertyReader(this.connectorContext.getTpmClient());
            this.documentReaders = new DocumentReadersSetup().prepare(this.connectorContext.getTpmClient());
            this.b2BProviderApiAdapters = new ArrayList<AbstractB2BProviderApiAdapter>(Arrays.asList(new As2B2BProviderApiAdapter(this.connectorContext, this.objectMapper), new X12B2BProviderApiAdapter(this.connectorContext, this, this.documentReaders.get(X12DocumentReader.class)), new FtpsB2BProviderApiAdapter(this.connectorContext), new EdifactB2BProviderApiAdapter(this.connectorContext, this, this.documentReaders.get(EdifactDocumentReader.class)), new FtpB2BProviderApiAdapter(this.connectorContext)));
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTpmClient(BasicConfig connectorConfig, HttpClient httpClient) throws Exception {
        if (connectorConfig.getEnableCaching().booleanValue()) {
            ConnectorContext connectorContext = this.connectorContext;
            synchronized (connectorContext) {
                this.connectorContext.setTpmClient(new CacheAwareTpmClient(this.objectMapper, httpClient, connectorConfig));
            }
        } else {
            DefaultTpmClient tpmClient = new DefaultTpmClient(connectorConfig.getTpmServiceAddress(), connectorConfig.getApiKey(), connectorConfig.getEnvironmentId(), connectorConfig.getMaxTotalConnections(), connectorConfig.getConnectTimeoutMs(), connectorConfig.getConnectionRequestTimeoutMs(), connectorConfig.getSocketTimeoutMs(), connectorConfig.getMaxNumberOfRetries());
            this.connectorContext.setTpmClient(tpmClient);
        }
    }

    private void initTracking(BasicConfig connectorConfig) throws Exception {
        int maxNoOfRetries = connectorConfig.getAsynchronousMode() != false ? 0 : connectorConfig.getMaxNumberOfRetries();
        this.connectorContext.setTrackerClient(new DefaultTrackerClient(connectorConfig.getTrackerAddress(), connectorConfig.getApiKey(), connectorConfig.getEnvironmentId(), connectorConfig.getMaxTotalConnections(), connectorConfig.getConnectTimeoutMs(), connectorConfig.getConnectionRequestTimeoutMs(), connectorConfig.getSocketTimeoutMs(), maxNoOfRetries));
        if (connectorConfig.getAsynchronousMode().booleanValue()) {
            this.taskQueue = connectorConfig.getQueueManager() != null ? new AsyncTransactionSynchronizer.TaskQueue(connectorConfig.getQueueManager()) : new AsyncTransactionSynchronizer.TaskQueue(this.muleContext.getQueueManager());
            this.transactionSynchronizer = new AsyncTransactionSynchronizer(this.connectorContext, this.taskQueue);
            this.transactionSynchronizer.startSynchronizing();
        }
    }

    public Config getConfig(ConfigType configType, Direction direction, QueryObject queryObject) throws B2BProviderException {
        try {
            for (B2BProviderApiAdapter b2BProviderApiAdapter : this.b2BProviderApiAdapters) {
                if (!b2BProviderApiAdapter.getName().equals(configType.toString())) continue;
                Config config = b2BProviderApiAdapter.getConfig(direction, queryObject);
                if (logger.isDebugEnabled()) {
                    this.logConfig(direction, config, configType);
                }
                return config;
            }
        }
        catch (Exception e) {
            throw new B2BProviderException((Throwable)e);
        }
        throw new B2BProviderException(MessageFactory.createStaticMessage((String)"Unsupported Config Type"));
    }

    public MuleEvent trackTransmission(String partnerIdentifier, Direction direction, String filename, Map<String, Serializable> metadata, String transport, Object file, Integer priority, Object transmissionSession, MuleEvent muleEvent) throws PartnerManagerConnectorException {
        try {
            TransmissionSession newTransmissionSession = this.getOrCreateTransmissionSession(transmissionSession, muleEvent.getId());
            muleEvent.setFlowVariable("b2bTransmissionSession", (Object)newTransmissionSession);
            TransactionCreate transaction = this.makeTransaction(muleEvent, newTransmissionSession, priority);
            com.modus.tracker.api.model.Transmission transmission = new com.modus.tracker.api.model.Transmission();
            transmission.setPartnershipId(this.resolvePartnershipId(partnerIdentifier, direction, transaction));
            transmission.setTransmissionType(transport);
            transmission.setFilename(filename);
            transmission.setDirection(Transmission.Direction.valueOf((String)direction.toString()));
            if (metadata != null) {
                transmission.withMetadata(new Metadata()).getMetadata().getAdditionalProperties().putAll(metadata);
            }
            transmission.setProcessedAt(transaction.getProcessedAt());
            transaction.setTransmissions(Arrays.asList(transmission));
            if (this.connectorConfig.getAsynchronousMode().booleanValue()) {
                this.taskQueue.put(new AsyncTransactionSynchronizer.CreateTransactionTask().setMuleEvent(muleEvent).setFile((Serializable)file).setTransaction(transaction));
            } else {
                transmission.setFileUrl(this.connectorContext.getFileStorageProvider().store(muleEvent, file));
                this.createTransaction(transaction);
            }
            return muleEvent;
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public MuleEvent propagateEndpointProperties(String endpointName, Object transmissionSession, MuleEvent muleEvent) throws PartnerManagerConnectorException {
        try {
            TransmissionSession newTransmissionSession = this.getOrCreateTransmissionSession(transmissionSession, muleEvent.getId());
            muleEvent.setFlowVariable("b2bTransmissionSession", (Object)newTransmissionSession);
            List<Map<String, Serializable>> endpoints = this.connectorContext.getTpmClient().search(TpmClient.Resource.ENDPOINT, String.format("name == '%s' and endpointType == '%s'", endpointName, "SEND"), null, null, null, null);
            if (endpoints.isEmpty()) {
                throw new PartnerManagerConnectorException(MessageFactory.createStaticMessage((String)("No send endpoint found with name " + endpointName)));
            }
            Map<String, Serializable> endpoint = endpoints.get(0);
            List propertyDefinitions = (List)((Object)endpoint.get("propertyDefinitions"));
            Map properties = (Map)newTransmissionSession.get((Object)PROPERTIES_SESSION_KEY);
            for (Map propertyDefinition : propertyDefinitions) {
                for (Map.Entry property : properties.entrySet()) {
                    if (!propertyDefinition.get("propertyTypeName").equals(property.getKey())) continue;
                    muleEvent.getMessage().setOutboundProperty((String)propertyDefinition.get("expression"), property.getValue());
                }
            }
            return muleEvent;
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public MuleEvent harvestEndpointProperties(String endpointName, Object transmissionSession, MuleEvent muleEvent) throws PartnerManagerConnectorException {
        try {
            TransmissionSession newTransmissionSession = this.getOrCreateTransmissionSession(transmissionSession, muleEvent.getId());
            muleEvent.setFlowVariable("b2bTransmissionSession", (Object)newTransmissionSession);
            this.propertyReader.readAndLoadEndpointProperties(endpointName, newTransmissionSession, muleEvent);
            return muleEvent;
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public MuleEvent harvestDocumentProperties(String partnerIdentifier, Direction direction, TpmClient.Standard standard, String version, String messageType, Object document, Object transmissionSession, MuleEvent muleEvent) throws PartnerManagerConnectorException {
        try {
            TransmissionSession newTransmissionSession = this.getOrCreateTransmissionSession(transmissionSession, muleEvent.getId());
            muleEvent.setFlowVariable("b2bTransmissionSession", (Object)newTransmissionSession);
            DocumentEnvelope<Object> documentEnvelope = new DocumentEnvelope<Object>();
            documentEnvelope.setContent(document);
            documentEnvelope.setCreatedAt(new Date());
            documentEnvelope.setDirection(direction.toString());
            documentEnvelope.setFormat(standard.toString());
            documentEnvelope.setMessageType(messageType);
            documentEnvelope.setVersion(version);
            documentEnvelope.setPartnerIdentifier(partnerIdentifier);
            this.readDocumentAndLoadProperties(muleEvent, standard, documentEnvelope, newTransmissionSession, null);
            return muleEvent;
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public MuleEvent trackDocument(String partnerIdentifier, Direction direction, String filename, Map<String, Object> metadata, TpmClient.Standard standard, String version, String messageType, Object file, Object document, Integer priority, Object transmissionSession, MuleEvent muleEvent) throws PartnerManagerConnectorException {
        try {
            TransmissionSession newTransmissionSession = this.getOrCreateTransmissionSession(transmissionSession, muleEvent.getId());
            muleEvent.setFlowVariable("b2bTransmissionSession", (Object)newTransmissionSession);
            DocumentEnvelope<Object> documentEnvelope = new DocumentEnvelope<Object>();
            documentEnvelope.setMetadata(metadata);
            documentEnvelope.setContent(document);
            documentEnvelope.setCreatedAt(new Date());
            documentEnvelope.setDirection(direction.toString());
            documentEnvelope.setFilename(filename);
            documentEnvelope.setFormat(standard.toString());
            documentEnvelope.setMessageType(messageType);
            documentEnvelope.setVersion(version);
            documentEnvelope.setPartnerIdentifier(partnerIdentifier);
            if (!this.connectorConfig.getAsynchronousMode().booleanValue()) {
                documentEnvelope.setFileUrl(this.connectorContext.getFileStorageProvider().store(muleEvent, file));
            }
            TransactionCreate transaction = this.readDocumentAndLoadProperties(muleEvent, standard, documentEnvelope, newTransmissionSession, priority);
            if (this.connectorConfig.getAsynchronousMode().booleanValue()) {
                this.taskQueue.put(new AsyncTransactionSynchronizer.CreateTransactionTask().setMuleEvent(muleEvent).setFile((Serializable)file).setTransaction(transaction));
            } else {
                this.createTransaction(transaction);
            }
            return muleEvent;
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public MuleEvent trackError(String partnerIdentifier, Direction direction, Error.Source source, String sourceId, Integer code, String message, Boolean notified, Integer priority, Object transmissionSession, MuleEvent muleEvent) throws PartnerManagerConnectorException {
        try {
            TransmissionSession newTransmissionSession = this.getOrCreateTransmissionSession(transmissionSession, muleEvent.getId());
            muleEvent.setFlowVariable("b2bTransmissionSession", (Object)newTransmissionSession);
            TransactionCreate transaction = this.makeTransaction(muleEvent, newTransmissionSession, priority);
            Error error = new Error();
            error.setPartnershipId(this.resolvePartnershipId(partnerIdentifier, direction, transaction));
            error.setDirection(Error.Direction.valueOf((String)direction.toString()));
            error.setMessage(message);
            error.setProcessedAt(transaction.getProcessedAt());
            error.setCode(code);
            error.setSource(source);
            error.setSourceId(sourceId);
            if (notified == null || notified.equals(Boolean.FALSE)) {
                error.setNotificationStatus(Error.NotificationStatus.NONE);
            } else {
                error.setNotificationStatus(Error.NotificationStatus.NOTIFIED);
            }
            transaction.setErrors(Arrays.asList(error));
            if (this.connectorConfig.getAsynchronousMode().booleanValue()) {
                this.taskQueue.put(new AsyncTransactionSynchronizer.CreateTransactionTask().setTransaction(transaction));
            } else {
                this.createTransaction(transaction);
            }
            return muleEvent;
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    private String resolvePartnershipId(String partnerIdentifier, Direction direction, TransactionCreate transaction) throws Exception {
        String partnershipId = null;
        try {
            partnershipId = direction.equals((Object)Direction.INBOUND) ? this.connectorContext.getTpmClient().getPartnershipByIdentifiers(partnerIdentifier, null).getId() : this.connectorContext.getTpmClient().getPartnershipByIdentifiers(null, partnerIdentifier).getId();
        }
        catch (TpmClientException e) {
            this.logOrThrowException(transaction, e);
        }
        return partnershipId;
    }

    public List<Map<String, Serializable>> search(Resource resource, String query, Integer count, Integer offset, String orderBy, Boolean descending) throws PartnerManagerConnectorException {
        try {
            if (Resource.ERROR.equals((Object)resource)) {
                if (query.contains("notified")) {
                    query = query.replaceAll("notified==false", "notificationStatus==" + Error.NotificationStatus.NONE.toString());
                    query = query.replaceAll("notified==true", "notificationStatus==" + Error.NotificationStatus.NOTIFIED.toString());
                }
                return this.connectorContext.getTrackerClient().search(resource.toString(), query, count, offset, orderBy, descending);
            }
            return this.connectorContext.getTpmClient().search(resource.toString(), query, count, offset, orderBy, descending);
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public List<Map<String, Serializable>> lookup(String lookupTable, String key, Map<String, Serializable> fields) throws PartnerManagerConnectorException {
        try {
            List<Entry> lookupEntries = this.connectorContext.getTpmClient().lookup(lookupTable, key, fields);
            return (List)this.objectMapper.convertValue(lookupEntries, (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Map.class));
        }
        catch (TpmClientException e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public List<Map<String, Serializable>> startTransactionsReplay(Integer replayingTimeout) throws PartnerManagerConnectorException {
        try {
            return this.connectorContext.getTrackerClient().startTransactionsReplay(replayingTimeout);
        }
        catch (TrackerClientException e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public void endTransactionsReplay(List<String> transactionIds) throws PartnerManagerConnectorException {
        try {
            this.connectorContext.getTrackerClient().endTransactionsReplay(transactionIds);
        }
        catch (TrackerClientException e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public List<Map<String, Serializable>> resolveRoutesExtended(OrganizationPath.DIRECTION direction, String fromPartyIdentifier, String toPartyIdentifier, String partyIdentifierType, DocumentLocator.Format standard, String version, String messageType, Object transmissionSession, MuleEvent muleEvent) throws PartnerManagerConnectorException {
        try {
            DocumentLocator documentLocator = new DocumentLocator();
            documentLocator.messageType = messageType;
            documentLocator.standard = standard;
            documentLocator.version = version;
            OrganizationPath organizationPath = new OrganizationPath();
            organizationPath.direction = direction;
            organizationPath.fromPartyId = fromPartyIdentifier;
            organizationPath.toPartyId = toPartyIdentifier;
            organizationPath.partyIdentifierType = partyIdentifierType;
            RouteResolutionServiceClient routeResolutionServiceClient = this.connectorContext.getRouteResolutionServiceClient();
            TransmissionSession newTransmissionSession = this.getOrCreateTransmissionSession(transmissionSession, muleEvent.getId());
            muleEvent.setFlowVariable("b2bTransmissionSession", (Object)newTransmissionSession);
            FilterSpecification filterSpecification = new FilterSpecification(){
                {
                    this.filterApproach = FilterSpecification.APPROACH.NONE;
                }
            };
            filterSpecification.filterProperties = (Map)newTransmissionSession.get((Object)PROPERTIES_SESSION_KEY);
            if (filterSpecification.filterProperties != null && filterSpecification.filterProperties.size() > 0) {
                filterSpecification.filterApproach = FilterSpecification.APPROACH.STANDARD;
            }
            return (List)this.objectMapper.convertValue(routeResolutionServiceClient.resolveRoutesExtended(organizationPath, documentLocator, filterSpecification), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Map.class));
        }
        catch (TpmClientException e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public List<Map<String, Serializable>> resolveRoutes(String fromPartyIdentifier, String toPartyIdentifier, TpmClient.PartyIdentifierType partyIdentifierType, TpmClient.Standard standard, String version, String messageType, Object transmissionSession, MuleEvent muleEvent) throws PartnerManagerConnectorException {
        try {
            TransmissionSession newTransmissionSession = this.getOrCreateTransmissionSession(transmissionSession, muleEvent.getId());
            muleEvent.setFlowVariable("b2bTransmissionSession", (Object)newTransmissionSession);
            Map properties = null;
            if (newTransmissionSession.get((Object)PROPERTIES_SESSION_KEY) != null) {
                properties = (Map)newTransmissionSession.get((Object)PROPERTIES_SESSION_KEY);
            }
            List<Route> routes = this.connectorContext.getTpmClient().resolveRoutes(fromPartyIdentifier, toPartyIdentifier, partyIdentifierType, standard, version, messageType, (Map<String, Serializable>)properties);
            return (List)this.objectMapper.convertValue(routes, (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Map.class));
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public void updateTransactionStatus(String transactionId, TrackerClient.Status status, Object transmissionSession) throws PartnerManagerConnectorException {
        try {
            String selectedTransactionId = transactionId != null ? transactionId : (String)this.readTransmissionSession(transmissionSession).get((Object)TRANSACTION_ID_SESSION_KEY);
            this.connectorContext.getTrackerClient().updateTransactionStatus(selectedTransactionId, status);
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public InputStream retrievePayload(String payloadLocation) throws PartnerManagerConnectorException {
        try {
            return Payload.getPayloadInstance(this.getClass().getClassLoader()).retrievePayload(this.connectorContext.getTpmClient(), new URL(payloadLocation));
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public Map<String, Serializable> getPartnershipByIdentifiers(String partnerIdentifier) throws PartnerManagerConnectorException {
        try {
            Partnership partnership = this.connectorContext.getTpmClient().getPartnershipByIdentifiers(partnerIdentifier, null);
            return (Map)this.objectMapper.convertValue((Object)partnership, Map.class);
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public List<Map<String, Serializable>> getEventsByTransactionId(String transactionId) throws PartnerManagerConnectorException {
        try {
            List<Map<String, Serializable>> events = this.connectorContext.getTrackerClient().getEventsByTransactionId(transactionId);
            return events;
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public void notify(String errorId) throws PartnerManagerConnectorException {
        try {
            this.connectorContext.getTrackerClient().notify(errorId);
        }
        catch (TrackerClientException e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public List<Map<String, Serializable>> startErrorsNotification(Integer notifyingTimeout) throws PartnerManagerConnectorException {
        try {
            return this.connectorContext.getTrackerClient().startErrorsNotification(notifyingTimeout);
        }
        catch (TrackerClientException e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public void endErrorsNotification(List<String> errorIds) throws PartnerManagerConnectorException {
        try {
            this.connectorContext.getTrackerClient().endErrorsNotification(errorIds);
        }
        catch (TrackerClientException e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public MuleEvent evaluateTransactionReleaseStatus(String routeId, String transactionId, String target, String routeStatus, Object transmissionSession, MuleEvent muleEvent) throws PartnerManagerConnectorException {
        try {
            TransmissionSession newTransmissionSession = this.getOrCreateTransmissionSession(transmissionSession, muleEvent.getId());
            muleEvent.setFlowVariable("b2bTransmissionSession", (Object)newTransmissionSession);
            if (this.connectorConfig.getAsynchronousMode().booleanValue()) {
                this.taskQueue.put(new AsyncTransactionSynchronizer.EvaluateTransactionReleaseStatusTask().setRouteId(routeId).setRouteStatus(routeStatus).setTransactionId(transactionId));
            } else {
                Map<String, Serializable> releaseStatus = this.connectorContext.getTrackerClient().evaluateTransactionReleaseStatus(transactionId, routeId, routeStatus);
                muleEvent.getMuleContext().getExpressionManager().enrich(target, muleEvent, (Object)releaseStatus.get("releaseStatus"));
            }
            return muleEvent;
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public List<Map<String, Serializable>> startTransactionsRelease(Integer releasingTimeout, Integer maxTransactions) throws PartnerManagerConnectorException {
        try {
            return this.connectorContext.getTrackerClient().startTransactionsRelease(releasingTimeout, maxTransactions);
        }
        catch (TrackerClientException e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public void endTransactionsRelease(List<String> transactionIds) throws PartnerManagerConnectorException {
        try {
            this.connectorContext.getTrackerClient().endTransactionsRelease(transactionIds);
        }
        catch (TrackerClientException e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    public TransmissionSession writeTransmission(Direction direction, Transmission transmission, TransmissionContext transmissionContext, TransmissionType transmissionType) throws B2BProviderException {
        try {
            TransmissionSession newTransmissionSession;
            if (transmissionContext.getMuleEvent() != null) {
                newTransmissionSession = this.getOrCreateTransmissionSession(transmissionContext.getTransmissionSession(), transmissionContext.getMuleEvent().getId());
                transmissionContext.getMuleEvent().setFlowVariable("b2bTransmissionSession", (Object)newTransmissionSession);
            } else {
                newTransmissionSession = this.getOrCreateTransmissionSession(transmissionContext.getTransmissionSession(), transmissionContext.getMuleEventId());
            }
            for (B2BProviderApiAdapter b2BProviderApiAdapter : this.b2BProviderApiAdapters) {
                if (!b2BProviderApiAdapter.getName().equals(transmissionType.toString())) continue;
                b2BProviderApiAdapter.writeTransmission(direction, transmission, transmissionContext, transmissionType, newTransmissionSession, this.connectorConfig.getAsynchronousMode());
            }
            return newTransmissionSession;
        }
        catch (Exception e) {
            throw new B2BProviderException((Throwable)e);
        }
    }

    public Transmission readTransmission(Direction direction, TransmissionType transmissionType, QueryObject queryObject) throws B2BProviderException {
        try {
            for (B2BProviderApiAdapter b2BProviderApiAdapter : this.b2BProviderApiAdapters) {
                if (!b2BProviderApiAdapter.getName().equals(transmissionType.toString())) continue;
                return b2BProviderApiAdapter.readTransmission(direction, queryObject);
            }
        }
        catch (Exception e) {
            throw new B2BProviderException((Throwable)e);
        }
        throw new B2BProviderException(MessageFactory.createStaticMessage((String)"Unsupported transmission type"));
    }

    public FactoryResolver getFactoryResolver() throws B2BProviderException {
        return new DefaultFactoryResolver();
    }

    private FileStorageProvider createFileStorageProvider(HttpClient httpClient) throws PartnerManagerConnectorException {
        AbstractFileStorageProvider fileStorageProvider;
        if (this.connectorConfig instanceof AmazonS3FileStorageConfig) {
            try {
                AmazonS3FileStorageConfig awsS3FileStorageConfig = (AmazonS3FileStorageConfig)this.connectorConfig;
                fileStorageProvider = new S3FileStorageProvider(httpClient, awsS3FileStorageConfig.getAccessKeyId(), awsS3FileStorageConfig.getSecretKey(), awsS3FileStorageConfig.getBucketName(), awsS3FileStorageConfig.getRegion());
            }
            catch (Exception e) {
                throw new PartnerManagerConnectorException(e);
            }
        } else {
            fileStorageProvider = this.connectorConfig instanceof CustomFileStorageConfig ? new FlowFileStorageProvider(((CustomFileStorageConfig)this.connectorConfig).getFlowName(), this.muleContext, ((CustomFileStorageConfig)this.connectorConfig).getFileUrl()) : new NullFileStorageProvider();
        }
        return fileStorageProvider;
    }

    public void onNotification(EventNotification notification) {
        this.transactionIdMap.put((Object)notification.getSource().getId(), (Object)notification.getTransactionId());
    }

    private TransmissionSession getOrCreateTransmissionSession(Object transmissionSession, String muleEventId) throws PartnerManagerConnectorException {
        try {
            DefaultTransmissionSession newTransmissionSession = transmissionSession == null ? new DefaultTransmissionSession() : this.readTransmissionSession(transmissionSession);
            if (newTransmissionSession.get(TRANSACTION_ID_SESSION_KEY) == null) {
                newTransmissionSession.put(TRANSACTION_ID_SESSION_KEY, UUID.getUUID());
            }
            this.validateTransactionUUID(newTransmissionSession);
            if (newTransmissionSession.get(PROPERTIES_SESSION_KEY) == null) {
                newTransmissionSession.put(PROPERTIES_SESSION_KEY, new HashMap());
            }
            if (muleEventId != null && this.transactionIdMap.getIfPresent((Object)muleEventId) != null && newTransmissionSession.get(MULE_TRANSACTION_ID_SESSION_KEY) == null) {
                newTransmissionSession.put(MULE_TRANSACTION_ID_SESSION_KEY, this.transactionIdMap.getIfPresent((Object)muleEventId));
            }
            if (newTransmissionSession.get(MULE_EVENT_ID_SESSION_KEY) == null) {
                if (muleEventId != null) {
                    newTransmissionSession.put(MULE_EVENT_ID_SESSION_KEY, muleEventId);
                } else {
                    throw new PartnerManagerConnectorException(MessageFactory.createStaticMessage((String)"Missing Mule event ID. Cannot create transmission session."));
                }
            }
            return newTransmissionSession;
        }
        catch (Exception e) {
            throw new PartnerManagerConnectorException(e);
        }
    }

    private void validateTransactionUUID(TransmissionSession newTransmissionSession) throws PartnerManagerConnectorException {
        try {
            java.util.UUID.fromString((String)newTransmissionSession.get((Object)TRANSACTION_ID_SESSION_KEY));
        }
        catch (IllegalArgumentException e) {
            throw new PartnerManagerConnectorException(MessageFactory.createStaticMessage((String)("Invalid transaction UUID: " + newTransmissionSession.get((Object)TRANSACTION_ID_SESSION_KEY))), e);
        }
    }

    public BasicConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public void setConnectorConfig(BasicConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    private void logConfig(Direction direction, Config config, ConfigType configType) {
        DefaultConfig maskedConfig = new DefaultConfig();
        for (Map.Entry setting : config.entrySet()) {
            if (((String)setting.getKey()).equalsIgnoreCase("password")) {
                maskedConfig.put(setting.getKey(), "*************");
                continue;
            }
            maskedConfig.put(setting.getKey(), setting.getValue());
        }
        logger.debug("Query resolved to the following " + direction.toString() + " " + configType.toString() + " options: " + maskedConfig);
    }

    private TransmissionSession deserialiseTransmissionSession(String serialisedTransmissionSession) throws IOException {
        Map transmissionSessionMap = (Map)this.objectMapper.readValue(serialisedTransmissionSession, Map.class);
        DefaultTransmissionSession transmissionSession = new DefaultTransmissionSession();
        transmissionSession.putAll(transmissionSessionMap);
        return transmissionSession;
    }

    private TransmissionSession readTransmissionSession(Object transmissionSession) throws PartnerManagerConnectorException, IOException {
        if (transmissionSession != null) {
            if (transmissionSession instanceof TransmissionSession) {
                return (TransmissionSession)transmissionSession;
            }
            if (transmissionSession instanceof Map) {
                return new DefaultTransmissionSession((Map)transmissionSession);
            }
            if (transmissionSession instanceof String) {
                return this.deserialiseTransmissionSession((String)transmissionSession);
            }
            throw new PartnerManagerConnectorException(MessageFactory.createStaticMessage((String)"Transmission session must be of type java.util.Map or serialised"));
        }
        throw new PartnerManagerConnectorException(MessageFactory.createStaticMessage((String)"Transmission session is null"));
    }

    private TransactionCreate readDocumentAndLoadProperties(MuleEvent muleEvent, TpmClient.Standard standard, DocumentEnvelope documentEnvelope, TransmissionSession transmissionSession, Integer priority) throws Exception {
        TransactionCreate transaction = this.makeTransaction(muleEvent, transmissionSession, priority);
        List<BusinessDocument> businessDocuments = Collections.emptyList();
        try {
            businessDocuments = standard.equals((Object)TpmClient.Standard.X12) ? this.documentReaders.get(X12DocumentReader.class).read(documentEnvelope) : (standard.equals((Object)TpmClient.Standard.EDIFACT) ? this.documentReaders.get(EdifactDocumentReader.class).read(documentEnvelope) : (standard.equals((Object)TpmClient.Standard.CSV) ? this.documentReaders.get(CsvDocumentReader.class).read(documentEnvelope) : (standard.equals((Object)TpmClient.Standard.XML) || standard.equals((Object)TpmClient.Standard.ROSETTANET) ? this.documentReaders.get(XmlDocumentReader.class).read(documentEnvelope) : (standard.equals((Object)TpmClient.Standard.JSON) ? this.documentReaders.get(JsonDocumentReader.class).read(documentEnvelope) : this.documentReaders.get(DefaultDocumentReader.class).read(documentEnvelope)))));
        }
        catch (Exception e) {
            this.logOrThrowException(transaction, e);
        }
        for (BusinessDocument businessDocument : businessDocuments) {
            try {
                this.propertyReader.readAndLoadDocumentProperties(businessDocument, transmissionSession, muleEvent);
            }
            catch (Exception e) {
                this.logOrThrowException(transaction, e);
            }
        }
        transaction.setBusinessDocuments(businessDocuments);
        return transaction;
    }

    public void logOrThrowException(TransactionCreate transaction, Exception e) throws Exception {
        if (!this.connectorConfig.getAsynchronousMode().booleanValue()) {
            throw e;
        }
        logger.error(e.getMessage(), (Throwable)e);
        Error error = new Error();
        error.setSource(Error.Source.TRANSACTION);
        error.setSourceId(transaction.getId());
        error.setProcessedAt(transaction.getProcessedAt());
        error.setMessage(e.getMessage().substring(0, Math.min(e.getMessage().length(), 5000)));
        error.setCode(Integer.valueOf(5));
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String stackTrace = stringWriter.toString();
        error.setDetail(stackTrace.substring(0, Math.min(stackTrace.length(), 5000)));
        transaction.setErrors(Arrays.asList(error));
    }

    private TransactionCreate makeTransaction(MuleEvent muleEvent, TransmissionSession transmissionSession, Integer priority) {
        TransactionCreate transaction = new TransactionCreate();
        transaction.setId((String)transmissionSession.get((Object)TRANSACTION_ID_SESSION_KEY));
        transaction.setMuleTransactionId((String)transmissionSession.get((Object)MULE_TRANSACTION_ID_SESSION_KEY));
        transaction.setMuleEventId((String)transmissionSession.get((Object)MULE_EVENT_ID_SESSION_KEY));
        transaction.setOriginalTransactionId((String)transmissionSession.get((Object)ORIGINAL_TRANSACTION_ID_SESSION_KEY));
        transaction.setParentTransactionId((String)transmissionSession.get((Object)PARENT_TRANSACTION_ID_SESSION_KEY));
        transaction.setApplicationName(muleEvent.getMuleContext().getConfiguration().getId());
        transaction.setPriority(priority);
        transaction.setProcessedAt(new Date());
        return transaction;
    }

    private void createTransaction(TransactionCreate transaction) throws TrackerClientException {
        this.connectorContext.getTrackerClient().createTransaction(transaction);
        logger.info(String.format("Created transaction %s", transaction.getId()));
    }

    public AsyncTransactionSynchronizer.TaskQueue getTaskQueue() {
        return this.taskQueue;
    }

    public PropertyReader getPropertyReader() {
        return this.propertyReader;
    }

    public static enum Resource {
        ENDPOINT("endpoints"),
        CHANNEL("channels"),
        DOCUMENT_MAP("documentMaps"),
        DOCUMENT_DEFINITION("documentDefinitions"),
        ROSETTANET_AGREEMENT("rosettanetAgreements"),
        ERROR("errors"),
        ERROR_CODE("errorCodes");

        private final String value;
        private static Map<String, Resource> constants;

        private Resource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        static {
            constants = new HashMap<String, Resource>();
            for (Resource c : Resource.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

