/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.b2b.adapter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.modus.mule.modules.apm.ConnectorContext;
import com.modus.mule.modules.apm.b2b.adapter.AbstractB2BProviderApiAdapter;
import com.modus.mule.modules.apm.b2b.impl.DefaultConfig;
import com.modus.mule.modules.apm.b2b.impl.DefaultQueryObject;
import com.modus.mule.modules.apm.b2b.impl.DefaultTransmission;
import com.modus.mule.modules.apm.exchange.writer.As2ExchangeWriterCallback;
import com.modus.mule.modules.apm.exchange.writer.ExchangeHeader;
import com.modus.tpm.api.model.Endpoint;
import com.modus.tpm.api.model.Partnership;
import com.modus.tpm.api.model.TransportOptions;
import com.modus.tpm.client.TpmClient;
import com.modus.tracker.client.TrackerClient;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.api.b2b.transmission.TransmissionContext;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.mule.util.Base64;
import org.mule.util.ObjectUtils;

public class As2B2BProviderApiAdapter
extends AbstractB2BProviderApiAdapter {
    private final ObjectMapper objectMapper;

    public As2B2BProviderApiAdapter(ConnectorContext connectorContext, ObjectMapper objectMapper) {
        super(connectorContext);
        this.objectMapper = objectMapper;
    }

    @Override
    public Config getConfig(Direction direction, QueryObject queryObject) throws Exception {
        String partnerCertificate;
        QueryObject queryObjectApiVersion2_3 = this.mapToQueryObjectApiVersion23(queryObject);
        Partnership partnership = this.connectorContext.getTpmClient().getPartnershipByIdentifiers((String)queryObjectApiVersion2_3.get((Object)"fromPartyIdentifier"), (String)queryObjectApiVersion2_3.get((Object)"toPartyIdentifier"));
        Endpoint endpoint = this.connectorContext.getTpmClient().resolveEndpoint(partnership.getId(), direction.equals((Object)Direction.INBOUND) ? TpmClient.EndpointType.RECEIVE : TpmClient.EndpointType.SEND, "AS2", (String)queryObjectApiVersion2_3.get((Object)"standard"), (String)queryObjectApiVersion2_3.get((Object)"version"), (String)queryObjectApiVersion2_3.get((Object)"messageType"));
        DefaultConfig as2Config = new DefaultConfig();
        String homeCertificate = partnership.getInternalPartner().getCertificate();
        if (homeCertificate != null) {
            as2Config.put("homeCertificate", Base64.decode((String)homeCertificate));
        }
        if ((partnerCertificate = partnership.getExternalPartner().getCertificate()) != null) {
            as2Config.put("partnerCertificate", Base64.decode((String)partnerCertificate));
        }
        TransportOptions options = endpoint.getTransportOptions();
        as2Config.putAll(options.getAdditionalProperties());
        as2Config.remove("partnershipId");
        return as2Config;
    }

    @Override
    public String getName() {
        return "AS2";
    }

    @Override
    public Transmission readTransmission(Direction direction, QueryObject queryObject) throws B2BProviderException {
        try {
            HashMap<String, String> token = new HashMap<String, String>();
            token.put("originalMessageId", (String)queryObject.get((Object)"as2MessageId"));
            List<Map<String, Serializable>> exchanges = this.connectorContext.getTrackerClient().findExchangesByToken(TrackerClient.ExchangeType.AS2, token);
            if (!exchanges.isEmpty()) {
                DefaultTransmission transmission = new DefaultTransmission();
                Map content = (Map)ObjectUtils.defaultIfNull((Object)exchanges.get(0).get("content"), new HashMap());
                for (Map.Entry field : content.entrySet()) {
                    if (!((String)field.getKey()).equals("mdnContent")) {
                        transmission.put(field.getKey(), field.getValue());
                        continue;
                    }
                    Map mdnContent = (Map)this.objectMapper.readValue(StringEscapeUtils.unescapeJava((String)((String)field.getValue())), Map.class);
                    transmission.put("mdnContent", Base64.decode((String)((String)mdnContent.get("content"))));
                    transmission.put("mdnContentType", mdnContent.get("contentType"));
                }
                return transmission;
            }
            return null;
        }
        catch (Exception e) {
            throw new B2BProviderException((Throwable)e);
        }
    }

    @Override
    public void writeTransmission(Direction direction, Transmission transmission, TransmissionContext transmissionContext, TransmissionType transmissionType, TransmissionSession transmissionSession, Boolean asynchronous) throws Exception {
        ExchangeHeader exchangeHeader = new ExchangeHeader();
        exchangeHeader.setDirection(direction.toString());
        exchangeHeader.setTransactionId((String)transmissionSession.get((Object)"transactionId"));
        exchangeHeader.setFilename((String)transmission.get((Object)"filename"));
        exchangeHeader.setMuleEventId((String)transmissionSession.get((Object)"muleEventId"));
        exchangeHeader.setMuleTransactionId((String)transmissionSession.get((Object)"muleTransactionId"));
        As2ExchangeWriterCallback exchangeWriterCallback = new As2ExchangeWriterCallback(transmission);
        this.exchangeWriter.write(TrackerClient.ExchangeType.AS2, transmissionContext.getMuleEvent(), exchangeWriterCallback, exchangeHeader, transmission.get((Object)"content"));
    }

    private QueryObject mapToQueryObjectApiVersion23(QueryObject queryObject) throws Exception {
        DefaultQueryObject queryObjectApiVersion2_3 = new DefaultQueryObject();
        block10: for (Map.Entry entry : queryObject.entrySet()) {
            switch ((String)entry.getKey()) {
                case "standard": {
                    if (((String)entry.getValue()).equals("EDI_X12")) {
                        queryObjectApiVersion2_3.put(entry.getKey(), "X12");
                        continue block10;
                    }
                    if (((String)entry.getValue()).equals("FLAT_FILE")) {
                        queryObjectApiVersion2_3.put(entry.getKey(), "CSV");
                        continue block10;
                    }
                    queryObjectApiVersion2_3.put(entry.getKey(), entry.getValue());
                    continue block10;
                }
                case "as2From": {
                    queryObjectApiVersion2_3.put("fromPartyIdentifier", entry.getValue());
                    continue block10;
                }
                case "as2To": {
                    queryObjectApiVersion2_3.put("toPartyIdentifier", entry.getValue());
                    continue block10;
                }
            }
            queryObjectApiVersion2_3.put(entry.getKey(), entry.getValue());
        }
        return queryObjectApiVersion2_3;
    }
}

