/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.cache;

import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class Cache {
    private final JdbcTemplate jdbcTemplate;
    private final ReadWriteLock readWriteLock;
    private final String name;

    public Cache(String name) throws ClassNotFoundException {
        this(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache(String name, boolean failIfNotExists) throws ClassNotFoundException {
        Class<Cache> clazz = Cache.class;
        synchronized (Cache.class) {
            this.jdbcTemplate = new JdbcTemplate(this.createDataSource(name, failIfNotExists));
            this.jdbcTemplate.setLazyInit(false);
            this.jdbcTemplate.execute("SELECT *");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.readWriteLock = new ReentrantReadWriteLock(true);
            this.name = name;
            return;
        }
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return this.jdbcTemplate.query(sql, rowMapper, args);
    }

    public void execute(String sql) throws DataAccessException {
        this.jdbcTemplate.execute(sql);
    }

    private DataSource createDataSource(String name, boolean failIfExists) throws ClassNotFoundException {
        JdbcConnectionPool jdbcConnectionPool = JdbcConnectionPool.create((String)String.format("jdbc:h2:nioMemFS:%s;EARLY_FILTER=TRUE;MODE=PostgreSQL;MULTI_THREADED=1;LOG=0;UNDO_LOG=0;DB_CLOSE_DELAY=-1;IFEXISTS=%s", name, String.valueOf(failIfExists)), (String)"sa", (String)"sa");
        jdbcConnectionPool.setMaxConnections(16);
        return jdbcConnectionPool;
    }

    public void acquireReadLock() {
        this.readWriteLock.readLock().lock();
    }

    public void releaseReadLock() {
        this.readWriteLock.readLock().unlock();
    }

    public void acquireWriteLock() {
        this.readWriteLock.writeLock().lock();
    }

    public void releaseWriteLock() {
        this.readWriteLock.writeLock().unlock();
    }

    public String getName() {
        return this.name;
    }
}

