/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.cache;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.modus.commons.persistence.DataMapperFactory;
import com.modus.commons.persistence.RsqlDataMapper;
import com.modus.commons.service.Gateway;
import com.modus.commons.service.exception.NotFoundServiceException;
import com.modus.commons.service.rsql.RsqlService;
import com.modus.mule.modules.apm.cache.Cache;
import com.modus.mule.modules.apm.cache.impl.RemoteDataMapperFactory;
import com.modus.mule.modules.apm.config.BasicConfig;
import com.modus.tpm.api.model.Endpoint;
import com.modus.tpm.api.model.Entry;
import com.modus.tpm.api.model.Route;
import com.modus.tpm.api.model.SecurityConfig;
import com.modus.tpm.client.NotFoundTpmClientException;
import com.modus.tpm.client.TpmClient;
import com.modus.tpm.client.TpmClientException;
import com.modus.tpm.client.model.DocumentLocator;
import com.modus.tpm.client.model.FilterSpecification;
import com.modus.tpm.client.model.OrganizationPath;
import com.modus.tpm.domain.model.DocumentDefinition;
import com.modus.tpm.domain.model.Endpoint;
import com.modus.tpm.domain.model.Partnership;
import com.modus.tpm.domain.service.EndpointResolver;
import com.modus.tpm.domain.service.LookupTableService;
import com.modus.tpm.domain.service.PartnerService;
import com.modus.tpm.domain.service.PartnershipService;
import com.modus.tpm.domain.service.RouteResolver;
import com.modus.tpm.domain.service.SecurityConfigService;
import com.modus.tpm.domain.service.document.definition.DocumentDefinitionResolver;
import com.modus.tpm.domain.service.document.definition.strategy.DefaultResolverStrategy;
import com.modus.tpm.domain.service.document.definition.strategy.ResolverStrategy;
import com.modus.tpm.model.mapper.DocumentDefinitionModelMapper;
import com.modus.tpm.model.mapper.EndpointModelMapper;
import com.modus.tpm.model.mapper.LookedUpEntryModelMapper;
import com.modus.tpm.model.mapper.PartnershipModelMapper;
import com.modus.tpm.model.mapper.RouteModelMapper;
import com.modus.tpm.model.mapper.SecurityConfigModelMapper;
import com.modus.util.remote.HttpUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.http.shade.pmc.Header;
import org.apache.http.shade.pmc.HttpResponse;
import org.apache.http.shade.pmc.NameValuePair;
import org.apache.http.shade.pmc.client.HttpClient;
import org.apache.http.shade.pmc.client.entity.UrlEncodedFormEntity;
import org.apache.http.shade.pmc.client.methods.HttpGet;
import org.apache.http.shade.pmc.client.methods.HttpPost;
import org.apache.http.shade.pmc.client.utils.HttpClientUtils;
import org.apache.http.shade.pmc.message.BasicNameValuePair;
import org.h2.jdbc.JdbcSQLException;
import org.mule.util.ExceptionUtils;
import org.mule.util.IOUtils;
import org.mule.util.MapUtils;
import org.mule.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class CacheAwareTpmClient
implements TpmClient {
    private static final Logger logger = LoggerFactory.getLogger(CacheAwareTpmClient.class);
    private static final int EXPORT_WAIT_INTERVAL = 1000;
    private static final String DATABASE_NOT_FOUND_SQL_CODE = "90013";
    private static ScheduledExecutorService executorService;
    private final ObjectMapper objectMapper;
    private final HttpClient httpClient;
    private final Gateway gateway;
    private final int maxExportTries;
    private DataMapperFactory dataMapperFactory;
    private Date lastExportAt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public CacheAwareTpmClient(final ObjectMapper objectMapper, final HttpClient httpClient, final BasicConfig connectorConfig) throws Exception {
        Cache cache;
        this.maxExportTries = connectorConfig.getCacheMaxExportTries();
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
        if (executorService == null) {
            Class<CacheAwareTpmClient> clazz = CacheAwareTpmClient.class;
            // MONITORENTER : com.modus.mule.modules.apm.cache.CacheAwareTpmClient.class
            if (executorService == null) {
                executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("partner.manager.connector.cache.refresh.scheduler", Thread.currentThread().getContextClassLoader()));
            }
            // MONITOREXIT : clazz
        }
        logger.info("Preparing cache...");
        boolean cacheExists = true;
        String cacheName = "cache-" + connectorConfig.getEnvironmentId();
        try {
            cache = new Cache(cacheName, true);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause == null) throw e;
            if (!(rootCause instanceof JdbcSQLException)) throw e;
            if (!((JdbcSQLException)rootCause).getSQLState().equals(DATABASE_NOT_FOUND_SQL_CODE)) throw e;
            cacheExists = false;
            cache = new Cache(cacheName);
        }
        if (!cacheExists) {
            this.initialiseCache(cache, connectorConfig);
        }
        this.dataMapperFactory = new RemoteDataMapperFactory(cache, httpClient, objectMapper, connectorConfig);
        if (!cacheExists) {
            final Cache finalCache = cache;
            executorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    CacheAwareTpmClient.this.refreshCache(finalCache, connectorConfig);
                }
            }, connectorConfig.getCacheRefreshIntervalMinutes().intValue(), connectorConfig.getCacheRefreshIntervalMinutes().intValue(), TimeUnit.MINUTES);
        } else {
            logger.warn("Not running duplicate refresh thread");
        }
        this.gateway = new Gateway(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <T> T create(String address, Map<String, String> parameters, Class<T> clazz) throws Exception {
                HttpResponse httpResponse;
                block4: {
                    String string;
                    ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                        nameValuePairs.add(new BasicNameValuePair(parameter.getKey(), parameter.getValue()));
                    }
                    HttpPost httpPost = new HttpPost(address);
                    httpPost.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)nameValuePairs));
                    httpResponse = null;
                    try {
                        httpResponse = httpClient.execute(httpPost);
                        if (!clazz.equals(String.class)) break block4;
                        string = IOUtils.toString((InputStream)httpResponse.getEntity().getContent());
                    }
                    catch (Throwable throwable) {
                        HttpClientUtils.closeQuietly(httpResponse);
                        throw throwable;
                    }
                    HttpClientUtils.closeQuietly(httpResponse);
                    return (T)string;
                }
                Object object = objectMapper.readValue(httpResponse.getEntity().getContent(), clazz);
                HttpClientUtils.closeQuietly(httpResponse);
                return (T)object;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCache(Cache cache, BasicConfig connectorConfig) {
        try {
            logger.info(String.format("Refreshing cache %s...", cache.getName()));
            Map<String, List<Map<String, Object>>> export = this.fetchExport(connectorConfig);
            if (export == null) {
                logger.info("No changes in partner configuration so skipping export download. Refreshing queries...");
            }
            RemoteDataMapperFactory newDataMapperFactory = new RemoteDataMapperFactory(cache, this.httpClient, this.objectMapper, connectorConfig);
            try {
                cache.acquireWriteLock();
                if (export != null) {
                    cache.execute("DROP ALL OBJECTS;");
                    this.loadCache(export, cache);
                }
                this.dataMapperFactory = newDataMapperFactory;
            }
            finally {
                cache.releaseWriteLock();
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    private void initialiseCache(Cache cache, BasicConfig connectorConfig) throws Exception {
        Map<String, List<Map<String, Object>>> export = this.fetchExport(connectorConfig);
        this.loadCache(export, cache);
    }

    private void loadCache(Map<String, List<Map<String, Object>>> export, Cache cache) throws Exception {
        logger.info("Loading export into cache...");
        for (Map.Entry<String, List<Map<String, Object>>> table : export.entrySet()) {
            File file = this.writeAsCsv(table);
            cache.execute(String.format("CREATE TABLE IF NOT EXISTS %s AS SELECT * FROM CSVREAD('%s');", table.getKey(), file.getAbsolutePath()));
            Map<String, Object> record = table.getValue().get(0);
            for (Map.Entry<String, Object> column : record.entrySet()) {
                if (column.getKey().equals("environmentid")) continue;
                cache.execute(String.format("CREATE INDEX ON %s (%s);", table.getKey(), column.getKey()));
            }
            file.delete();
        }
        cache.execute("ANALYZE;");
        this.lastExportAt = new Date();
        logger.info("Export loaded into cache");
    }

    private File writeAsCsv(Map.Entry<String, List<Map<String, Object>>> table) throws IOException {
        CsvMapper csvMapper = new CsvMapper();
        CsvSchema.Builder schemaBuilder = CsvSchema.builder();
        for (Map<String, Object> record : table.getValue()) {
            if (!this.isPlaceholder(record)) continue;
            for (String column : record.keySet()) {
                schemaBuilder.addColumn(column);
            }
        }
        CsvSchema schema = schemaBuilder.build().withLineSeparator("\r").withHeader();
        File file = File.createTempFile(table.getKey(), ".csv");
        file.deleteOnExit();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
            csvMapper.writer((FormatSchema)schema).writeValue((Writer)writer, table.getValue());
        }
        return file;
    }

    private boolean isPlaceholder(Map<String, Object> record) {
        return record.get("id").equals("????????-????-????-????-????????????");
    }

    private Map<String, List<Map<String, Object>>> fetchExport(BasicConfig connectorConfig) throws Exception {
        Map<String, List<Map<String, Object>>> export = null;
        String location = this.scheduleExport(connectorConfig);
        if (location != null) {
            export = this.fetchExport(connectorConfig, location);
            if (logger.isTraceEnabled()) {
                logger.trace("Downloaded export => " + MapUtils.toString(export, (boolean)true));
            }
        }
        return export;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<Map<String, Object>>> fetchExport(BasicConfig connectorConfig, String location) throws Exception {
        Map export = null;
        HttpResponse lastExportHttpResponse = null;
        int tries = 0;
        while (tries == 0 || !this.isExportFinished(tries, lastExportHttpResponse)) {
            block6: {
                try {
                    Thread.sleep(1000L);
                    ++tries;
                    HttpGet exportHttpGet = new HttpGet(String.format("%s/%s?apiKey=%s&environmentId=%s", connectorConfig.getTpmServiceAddress(), location, connectorConfig.getApiKey(), connectorConfig.getEnvironmentId()));
                    lastExportHttpResponse = this.httpClient.execute(exportHttpGet);
                    if (HttpUtils.isSuccessful(lastExportHttpResponse) && lastExportHttpResponse.getStatusLine().getStatusCode() != 202) {
                        logger.info("Downloading export...");
                        export = (Map)this.objectMapper.readValue(lastExportHttpResponse.getEntity().getContent(), Map.class);
                        break block6;
                    }
                    if (lastExportHttpResponse.getStatusLine().getStatusCode() == 202) {
                        logger.info("Waiting for export to be ready for download...");
                        break block6;
                    }
                    throw new TpmClientException(HttpUtils.createHttpResponseExceptionMessage("Failed to fetch export", lastExportHttpResponse));
                }
                catch (Throwable throwable) {
                    HttpClientUtils.closeQuietly(lastExportHttpResponse);
                    throw throwable;
                }
            }
            HttpClientUtils.closeQuietly(lastExportHttpResponse);
        }
        if (tries > this.maxExportTries) {
            throw new TpmClientException(String.format("Gave up waiting for export after %s tries", this.maxExportTries));
        }
        return export;
    }

    private boolean isExportFinished(int tries, HttpResponse httpResponse) {
        return tries > this.maxExportTries || httpResponse.getStatusLine().getStatusCode() == 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String scheduleExport(BasicConfig connectorConfig) throws TpmClientException, IOException {
        HttpResponse scheduleExportHttpResponse;
        block5: {
            String string;
            HttpGet scheduleExportHttpGet = new HttpGet(String.format("%s/partnerSettings?addPlaceholders=true&apiKey=%s&environmentId=%s", connectorConfig.getTpmServiceAddress(), connectorConfig.getApiKey(), connectorConfig.getEnvironmentId()));
            if (this.lastExportAt != null) {
                SimpleDateFormat rfc1123DateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                rfc1123DateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                scheduleExportHttpGet.setHeader("If-Modified-Since", rfc1123DateFormat.format(this.lastExportAt));
            }
            scheduleExportHttpResponse = null;
            try {
                scheduleExportHttpResponse = this.httpClient.execute(scheduleExportHttpGet);
                if (scheduleExportHttpResponse.getStatusLine().getStatusCode() != 304) break block5;
                string = null;
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(scheduleExportHttpResponse);
                throw throwable;
            }
            HttpClientUtils.closeQuietly(scheduleExportHttpResponse);
            return string;
        }
        if (!HttpUtils.isSuccessful(scheduleExportHttpResponse)) {
            throw new TpmClientException(HttpUtils.createHttpResponseExceptionMessage("Failed to schedule export", scheduleExportHttpResponse));
        }
        Header locationHeader = scheduleExportHttpResponse.getFirstHeader("Location");
        String string = locationHeader.getValue().startsWith("/") ? locationHeader.getValue().substring(1, locationHeader.getValue().length()) : locationHeader.getValue();
        HttpClientUtils.closeQuietly(scheduleExportHttpResponse);
        return string;
    }

    @Override
    public List<Route> resolveRoutes(String fromPartyIdentifier, String toPartyIdentifier, TpmClient.PartyIdentifierType partyIdentifierType, TpmClient.Standard standard, String version, String messageType, Map<String, Serializable> filterProperties) throws TpmClientException {
        return this.resolveRoutes(fromPartyIdentifier, toPartyIdentifier, partyIdentifierType != null ? partyIdentifierType.toString() : null, standard.toString(), version, messageType, filterProperties);
    }

    @Override
    public List<Route> resolveRoutes(String fromPartyIdentifier, String toPartyIdentifier, String partyIdentifierType, String standard, String version, String messageType, Map<String, Serializable> properties) throws TpmClientException {
        try {
            PartnerService partnerService = new PartnerService(this.dataMapperFactory, null);
            PartnershipService partnershipService = new PartnershipService(this.dataMapperFactory, partnerService);
            DocumentDefinitionResolver documentDefinitionResolver = new DocumentDefinitionResolver(partnershipService);
            RouteResolver routeResolver = new RouteResolver(this.dataMapperFactory, documentDefinitionResolver, partnershipService);
            HashMap<String, String> stringProperties = null;
            if (properties != null) {
                stringProperties = new HashMap<String, String>();
                for (Map.Entry<String, Serializable> entry : properties.entrySet()) {
                    stringProperties.put(entry.getKey(), (String)((Object)entry.getValue()));
                }
            }
            List routes = routeResolver.resolveRoute(fromPartyIdentifier, toPartyIdentifier, partyIdentifierType, standard, version, messageType, stringProperties);
            return RouteModelMapper.INSTANCE.map(routes);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public List<Route> resolveRoutesExtended(OrganizationPath organizationPath, DocumentLocator documentLocator, FilterSpecification filterSpecification) throws TpmClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Map<String, Serializable>> search(TpmClient.Resource resource, String query, Integer count, Integer offset, String orderBy, Boolean desc) throws TpmClientException {
        return this.search(resource.toString(), query, count, offset, orderBy, desc);
    }

    @Override
    public List<Map<String, Serializable>> search(String resource, String query, Integer count, Integer offset, String orderBy, Boolean desc) throws TpmClientException {
        try {
            String modelClassName = WordUtils.capitalize((String)resource).substring(0, resource.length() - 1);
            String modelMapperClassName = "com.modus.tpm.model.mapper." + modelClassName + "ModelMapper";
            String dataMapperClassName = "com.modus.tpm.persistence.mapper." + modelClassName + "DataMapper";
            RsqlService rsqlService = new RsqlService();
            this.getClass();
            RsqlDataMapper rsqlDataMapper = (RsqlDataMapper)this.dataMapperFactory.createDataMapper(Class.forName(dataMapperClassName));
            this.getClass();
            List result = rsqlService.query(query, -1L, -1L, "", false, rsqlDataMapper, Class.forName("com.modus.tpm.api.model." + modelClassName));
            this.getClass();
            Class<?> modelMapperClass = Class.forName(modelMapperClassName);
            Object modelMapper = ReflectionUtils.getField((Field)modelMapperClass.getField("INSTANCE"), modelMapperClass);
            List mappedResult = (List)ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod(modelMapper.getClass(), (String)"map", (Class[])new Class[]{List.class}), (Object)modelMapper, (Object[])new Object[]{result});
            CollectionType collectionType = this.objectMapper.getTypeFactory().constructCollectionType(List.class, Map.class);
            return (List)this.objectMapper.convertValue((Object)mappedResult, (JavaType)collectionType);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public String getSecurityConfigToken() throws TpmClientException {
        try {
            return new SecurityConfigService(this.dataMapperFactory, this.gateway).getToken();
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public List<Entry> lookup(String lookupTable, String key, Map<String, Serializable> fields) throws TpmClientException {
        try {
            LookupTableService lookupTableService = new LookupTableService(this.dataMapperFactory);
            Collection lookupEntries = lookupTableService.lookup(lookupTable, key, fields);
            return LookedUpEntryModelMapper.INSTANCE.mapByName(lookupEntries);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public com.modus.tpm.api.model.Partnership getPartnershipByIdentifiers(String fromPartyIdentifier, String toPartyIdentifier) throws TpmClientException {
        try {
            PartnerService partnerService = new PartnerService(this.dataMapperFactory, null);
            Partnership partnership = new PartnershipService(this.dataMapperFactory, partnerService).getPartnershipByPartyIdentifiers(fromPartyIdentifier, toPartyIdentifier);
            return PartnershipModelMapper.INSTANCE.map(partnership);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public com.modus.tpm.api.model.Partnership getPartnership(String partnershipId) throws TpmClientException {
        try {
            Partnership partnership = new PartnershipService(this.dataMapperFactory, new PartnerService(this.dataMapperFactory, null)).getPartnership(partnershipId);
            return PartnershipModelMapper.INSTANCE.map(partnership);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public List<Entry> lookupByIds(String lookupTableId, String keyId, Map<String, Serializable> fieldIds) throws TpmClientException {
        try {
            LookupTableService lookupTableService = new LookupTableService(this.dataMapperFactory);
            Collection lookupEntries = lookupTableService.lookupByIds(lookupTableId, keyId, fieldIds);
            return LookedUpEntryModelMapper.INSTANCE.mapById(lookupEntries);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public com.modus.tpm.api.model.DocumentDefinition resolveDocumentDefinition(String partnershipId, TpmClient.Standard standard, String version, String messageType) throws TpmClientException {
        return this.resolveDocumentDefinition(partnershipId, standard.toString(), version, messageType);
    }

    @Override
    public com.modus.tpm.api.model.DocumentDefinition resolveDocumentDefinition(String partnershipId, String standard, String version, String messageType) throws TpmClientException {
        try {
            PartnerService partnerService = new PartnerService(this.dataMapperFactory, null);
            DocumentDefinitionResolver documentDefinitionResolver = new DocumentDefinitionResolver(new PartnershipService(this.dataMapperFactory, partnerService));
            DocumentDefinition documentDefinition = documentDefinitionResolver.resolveDocumentDefinition(partnershipId, standard, version, messageType, (ResolverStrategy)new DefaultResolverStrategy(this.dataMapperFactory));
            return DocumentDefinitionModelMapper.INSTANCE.map(documentDefinition);
        }
        catch (NotFoundServiceException e) {
            throw new NotFoundTpmClientException(e);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public Endpoint resolveEndpoint(String partnershipId, TpmClient.EndpointType endpointType, String transportType, String standard, String version, String messageType) throws TpmClientException {
        try {
            EndpointResolver endpointResolver = new EndpointResolver(this.dataMapperFactory);
            com.modus.tpm.domain.model.Endpoint endpoint = endpointResolver.resolveEndpoint(partnershipId, Endpoint.EndpointType.valueOf((String)endpointType.toString()), transportType, standard, version, messageType);
            return EndpointModelMapper.INSTANCE.map(endpoint);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public SecurityConfig getSecurityConfig() throws TpmClientException {
        try {
            return SecurityConfigModelMapper.INSTANCE.map(new SecurityConfigService(this.dataMapperFactory, this.gateway).getSecurityConfig());
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }
}

