/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.modus.mule.modules.apm.cache.BeanStore;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.mule.util.ObjectUtils;
import org.mule.util.StringUtils;

public class ResultSetMapper {
    private static final String ID_COLUMN_NAME = "id";
    private final PropertyPathComparator comparator = new PropertyPathComparator();
    private final ObjectMapper objectMapper;

    public ResultSetMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> List<T> map(List<Map<String, Object>> resultSet, Class<T> clazz) throws IOException, ParseException {
        if (!resultSet.isEmpty() && (clazz.isPrimitive() || clazz.equals(String.class))) {
            return Arrays.asList(resultSet.get(0).values().toArray()[0]);
        }
        List<Map<String, Object>> sortedResultSet = this.sortResultSet(resultSet);
        BeanStore beanStore = new BeanStore(this.objectMapper);
        for (Map<String, Object> result : sortedResultSet) {
            String rootBeanId = (String)ObjectUtils.defaultIfNull((Object)result.get(ID_COLUMN_NAME), (Object)result.get(ID_COLUMN_NAME.toUpperCase()));
            Objects.requireNonNull(rootBeanId);
            if (beanStore.getBean(rootBeanId, "") == null) {
                beanStore.addBean(rootBeanId, clazz);
                this.addResultAsBean(result, beanStore, rootBeanId);
                continue;
            }
            this.addResultAsBean(result, beanStore, rootBeanId);
        }
        return beanStore.getRootBeans();
    }

    private List<Map<String, Object>> sortResultSet(List<Map<String, Object>> resultSet) {
        ArrayList<Map<String, Object>> sortedResultSet = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> result : resultSet) {
            TreeMap<String, Object> sortedResult = new TreeMap<String, Object>(this.comparator);
            sortedResult.putAll(result);
            sortedResultSet.add(sortedResult);
        }
        return sortedResultSet;
    }

    private void addResultAsBean(Map<String, Object> result, BeanStore beanStore, String rootBeanId) throws IOException, ParseException {
        for (Map.Entry<String, Object> column : result.entrySet()) {
            String propertyPath = column.getKey();
            if (this.isNestedProperty(propertyPath)) {
                this.addNestedProperty(column, beanStore, rootBeanId);
                continue;
            }
            beanStore.setProperty(rootBeanId, "", propertyPath, column.getValue());
        }
    }

    private void addNestedProperty(Map.Entry<String, Object> column, BeanStore beanStore, String rootBeanId) throws IOException, ParseException {
        String columnName = column.getKey();
        if (this.isPropertyId(columnName)) {
            if (column.getValue() != null) {
                String lastSeenId = rootBeanId + ":" + column.getValue();
                Object nestedBean = beanStore.getBean(lastSeenId, this.getParentPath(columnName));
                if (nestedBean == null) {
                    nestedBean = beanStore.addNestedBean(rootBeanId, lastSeenId, this.getParentPath(columnName));
                }
                if (nestedBean != null) {
                    beanStore.setProperty(nestedBean, ID_COLUMN_NAME, column.getValue());
                    beanStore.setLastKnownBean(lastSeenId, this.getParentPath(columnName), nestedBean);
                }
            }
        } else {
            beanStore.setProperty(beanStore.getLastKnownBean(), columnName.substring(columnName.lastIndexOf(".") + 1, columnName.length()), column.getValue());
        }
    }

    private boolean isNestedProperty(String propertyPath) {
        return propertyPath.contains(".");
    }

    private boolean isPropertyId(String propertyPath) {
        return propertyPath.toLowerCase().endsWith(".id");
    }

    private String getParentPath(String propertyPath) {
        return propertyPath.substring(0, Math.max(propertyPath.lastIndexOf("."), 0));
    }

    private class PropertyPathComparator
    implements Comparator<String> {
        private PropertyPathComparator() {
        }

        private boolean areRootBeanProperties(String propertyPath1, String propertyPath2) {
            return !ResultSetMapper.this.isNestedProperty(propertyPath1) && !ResultSetMapper.this.isNestedProperty(propertyPath2);
        }

        private int countSeparators(String propertyPath) {
            return StringUtils.countMatches((String)propertyPath, (String)".");
        }

        private boolean haveCommonImmediateParent(String propertyPath1, String propertyPath2) {
            return ResultSetMapper.this.getParentPath(propertyPath1).equals(ResultSetMapper.this.getParentPath(propertyPath2));
        }

        @Override
        public int compare(String propertyPath1, String propertyPath2) {
            int propertyPath2SeparatorCount;
            if (this.areRootBeanProperties(propertyPath1, propertyPath2)) {
                return propertyPath1.compareTo(propertyPath2);
            }
            if (propertyPath1.contains(".") && !propertyPath2.contains(".")) {
                return 1;
            }
            if (!propertyPath1.contains(".") && propertyPath2.contains(".")) {
                return -1;
            }
            int propertyPath1SeparatorCount = this.countSeparators(propertyPath1);
            if (propertyPath1SeparatorCount > (propertyPath2SeparatorCount = this.countSeparators(propertyPath2))) {
                return 1;
            }
            if (propertyPath1SeparatorCount < propertyPath2SeparatorCount) {
                return -1;
            }
            if (this.haveCommonImmediateParent(propertyPath1, propertyPath2)) {
                if (ResultSetMapper.this.isPropertyId(propertyPath1)) {
                    return -1;
                }
                if (ResultSetMapper.this.isPropertyId(propertyPath2)) {
                    return 1;
                }
                return propertyPath1.compareTo(propertyPath2);
            }
            return propertyPath1.compareTo(propertyPath2);
        }
    }
}

