/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.cache.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.modus.commons.persistence.DataMapper;
import com.modus.commons.persistence.DataMapperFactory;
import com.modus.commons.persistence.rsql.AbstractRsqlDataMapper;
import com.modus.commons.persistence.rsql.SqlStatement;
import com.modus.mule.modules.apm.cache.Cache;
import com.modus.mule.modules.apm.cache.ResultSetMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.jdbc.core.ColumnMapRowMapper;

public class DefaultDataMapper
extends AbstractRsqlDataMapper
implements DataMapper {
    private final Cache cache;
    private final ResultSetMapper resultSetMapper;
    private final ColumnMapRowMapper rowMapper;
    private final Class<?> resultType;
    private final String targetTable;
    protected String environmentId;
    protected DataMapperFactory dataMapperFactory;
    protected final Map<String, String> queries;

    public DefaultDataMapper(Cache cache, Map<String, String> queries, ObjectMapper objectMapper, Class<?> resultType, String targetTable) throws Exception {
        this.cache = cache;
        this.resultSetMapper = new ResultSetMapper(objectMapper);
        this.rowMapper = new ColumnMapRowMapper();
        this.queries = queries;
        this.resultType = resultType;
        this.targetTable = targetTable;
    }

    public DefaultDataMapper(Cache cache, Map<String, String> queries, ObjectMapper objectMapper) throws Exception {
        this(cache, queries, objectMapper, null, null);
    }

    protected SqlStatement createSqlStatement(String environmentId) {
        String query = null;
        for (int i = 0; i < 10 && (query = i == 0 ? this.queries.get("get" + this.resultType.getSimpleName() + "s") : this.queries.get("get" + this.resultType.getSimpleName() + "sV" + i)) == null; ++i) {
        }
        return new SqlStatement(this.getTargetTable(), query, this.getEnvironmentId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List doQuery(SqlStatement sqlStatement, int count, int offset, String orderBy, Boolean desc) throws Exception {
        List<Map<String, Object>> resultSet;
        String sql = sqlStatement.getSql().toString();
        for (Map.Entry parameter : sqlStatement.getParameters().entrySet()) {
            sql = sql.replace(String.format("#{%s}", parameter.getKey()), "?");
        }
        sqlStatement.getParameters().remove("environmentId");
        try {
            this.cache.acquireReadLock();
            resultSet = this.cache.query(sql, this.rowMapper, sqlStatement.getParameters().values().toArray());
        }
        finally {
            this.cache.releaseReadLock();
        }
        return this.resultSetMapper.map(resultSet, this.getResultType());
    }

    protected Class getResultType() {
        return this.resultType;
    }

    protected String getTargetTable() {
        if (this.targetTable == null) {
            return super.getTargetTable();
        }
        return this.targetTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<T> queryById(String queryId, Class<T> domainClass, Object ... parameters) throws Exception {
        List<Map<String, Object>> resultSet;
        try {
            this.cache.acquireReadLock();
            String query = this.queries.get(queryId);
            Objects.requireNonNull(query, String.format("Query with ID %s is undefined. Hint: make sure query ID is included in com.modus.mule.modules.apm.cache.impl.RemoteDataMapperFactory.QUERY_IDS", queryId));
            resultSet = this.cache.query(query, this.rowMapper, this.prepareParameters(parameters));
        }
        finally {
            this.cache.releaseReadLock();
        }
        return this.resultSetMapper.map(resultSet, domainClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<T> queryBySql(String sql, Class<T> domainClass, Map<String, Object> parameters) throws Exception {
        List<Map<String, Object>> resultSet;
        String unsafeSql = sql;
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            unsafeSql = unsafeSql.replaceAll(String.format("(?i)#\\{%s}", parameter.getKey()), String.format("'%s'", parameter.getValue()));
        }
        try {
            this.cache.acquireReadLock();
            resultSet = this.cache.query(unsafeSql, this.rowMapper, new Object[0]);
        }
        finally {
            this.cache.releaseReadLock();
        }
        return this.resultSetMapper.map(resultSet, domainClass);
    }

    private Object[] prepareParameters(Object[] parameters) {
        ArrayList<Object> preparedParameters = new ArrayList<Object>();
        if (parameters != null) {
            for (Object parameter : parameters) {
                if (parameter != null && parameter.getClass().isEnum()) {
                    preparedParameters.add(parameter.toString());
                    continue;
                }
                preparedParameters.add(parameter);
            }
        }
        return preparedParameters.toArray();
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setDataMapperFactory(DataMapperFactory dataMapperFactory) {
        this.dataMapperFactory = dataMapperFactory;
    }

    public List<?> query(String query, Map parameters) throws Exception {
        throw new UnsupportedOperationException();
    }

    public List<?> query(String query, Map parameters, boolean useCache) throws Exception {
        throw new UnsupportedOperationException();
    }
}

