/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.filestorage;

import com.modus.mule.modules.apm.PartnerManagerConnectorException;
import com.modus.mule.modules.apm.filestorage.FileStorageProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.mule.api.MuleEvent;
import org.mule.config.i18n.MessageFactory;

public abstract class AbstractFileStorageProvider
implements FileStorageProvider {
    @Override
    public String store(MuleEvent muleEvent, Object file) throws Exception {
        if (file != null) {
            InputStream contentInputStream;
            if (file instanceof byte[]) {
                contentInputStream = new ByteArrayInputStream((byte[])file);
            } else if (file instanceof InputStream) {
                contentInputStream = (InputStream)file;
            } else if (file instanceof Serializable) {
                contentInputStream = new ByteArrayInputStream(file.toString().getBytes("UTF-8"));
            } else {
                throw new PartnerManagerConnectorException(MessageFactory.createStaticMessage((String)("Could not read content. Unsupported Java type: " + file.getClass().getName() + ". Supported types are: java.io.InputStream and java.io.Serializable and byte[]")));
            }
            return this.doStore(muleEvent, contentInputStream);
        }
        return "";
    }

    @Override
    public String store(InputStream file) throws Exception {
        return this.store(null, file);
    }

    protected abstract String doStore(MuleEvent var1, InputStream var2) throws Exception;
}

