/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.filestorage.s3;

import com.modus.mule.modules.apm.PartnerManagerConnectorException;
import com.modus.mule.modules.apm.filestorage.AbstractFileStorageProvider;
import com.modus.util.Aws4SignerBase;
import com.modus.util.Aws4SignerForAuthorizationHeader;
import com.modus.util.remote.HttpUtils;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.http.shade.pmc.HttpResponse;
import org.apache.http.shade.pmc.client.HttpClient;
import org.apache.http.shade.pmc.client.methods.HttpPut;
import org.apache.http.shade.pmc.client.utils.HttpClientUtils;
import org.apache.http.shade.pmc.entity.ByteArrayEntity;
import org.mule.api.MuleEvent;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.IOUtils;
import org.mule.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileStorageProvider
extends AbstractFileStorageProvider {
    private static final Logger logger = LoggerFactory.getLogger(S3FileStorageProvider.class);
    private final String awsAccessKey;
    private final String awsSecretKey;
    private final String region;
    private final String bucketName;
    private final HttpClient httpClient;

    public S3FileStorageProvider(HttpClient httpClient, String awsAccessKey, String awsSecretKey, String bucketName, String region) throws Exception {
        this.awsAccessKey = awsAccessKey;
        this.awsSecretKey = awsSecretKey;
        this.region = region;
        this.httpClient = httpClient;
        this.bucketName = bucketName;
    }

    @Override
    public String doStore(MuleEvent muleEvent, InputStream file) throws Exception {
        HttpResponse httpResponse;
        block3: {
            String string;
            HttpPut httpPut = this.buildPutRequest(this.serializeContent(file));
            httpResponse = null;
            try {
                httpResponse = this.httpClient.execute(httpPut);
                if (!HttpUtils.isSuccessful(httpResponse)) break block3;
                string = httpPut.getURI().toString();
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(httpResponse);
                throw throwable;
            }
            HttpClientUtils.closeQuietly(httpResponse);
            return string;
        }
        throw new PartnerManagerConnectorException(MessageFactory.createStaticMessage((String)HttpUtils.createHttpResponseExceptionMessage("Failed to save file", httpResponse)));
    }

    private HttpPut buildPutRequest(byte[] file) {
        URL endpointUrl;
        String url = this.region.equals("us-east-1") ? "https://s3.amazonaws.com/" + this.bucketName + "/" + UUID.getUUID().replace("-", "") + ".dat" : "https://s3-" + this.region + ".amazonaws.com/" + this.bucketName + "/" + UUID.getUUID().replace("-", "") + ".dat";
        try {
            endpointUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to parse service endpoint: " + e.getMessage());
        }
        byte[] contentHash = Aws4SignerBase.hash(file);
        String contentHashString = Aws4SignerBase.toHex(contentHash);
        HashMap<String, String> headers = new HashMap<String, String>();
        Aws4SignerForAuthorizationHeader signer = new Aws4SignerForAuthorizationHeader(endpointUrl, "PUT", "s3", this.region);
        String authorization = signer.computeSignature(headers, null, contentHashString, this.awsAccessKey, this.awsSecretKey);
        HttpPut httpPut = new HttpPut(url);
        httpPut.setEntity(new ByteArrayEntity(file));
        httpPut.setHeader("Authorization", authorization);
        httpPut.setHeader("x-amz-content-sha256", contentHashString);
        httpPut.setHeader("x-amz-date", (String)headers.get("x-amz-date"));
        return httpPut;
    }

    private byte[] serializeContent(Object content) throws Exception {
        logger.warn("Consuming input stream...");
        return IOUtils.toByteArray((InputStream)((InputStream)content));
    }
}

