/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.apm.generated.config;

import com.modus.mule.modules.apm.generated.processors.ResolveRoutesMessageProcessor;
import org.mule.config.MuleManifest;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ResolveRoutesDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(ResolveRoutesDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)ResolveRoutesMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [resolve-routes] within the connector [partner-manager] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [resolve-routes] within the connector [partner-manager] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue((Object)"resolveRoutes");
        builder.setScope("prototype");
        if (!this.hasAttribute(element, "config-ref")) {
            throw new BeanDefinitionParsingException(new Problem("It seems that the config-ref for @Processor [resolve-routes] within the connector [partner-manager] is null or missing. Please, fill the value with the correct global element.", new Location(parserContext.getReaderContext().getResource()), null));
        }
        this.parseConfigRef(element, builder);
        this.parseProperty(builder, element, "fromPartyIdentifier", "fromPartyIdentifier");
        this.parseProperty(builder, element, "toPartyIdentifier", "toPartyIdentifier");
        this.parseProperty(builder, element, "partyIdentifierType", "partyIdentifierType");
        this.parseProperty(builder, element, "standard", "standard");
        this.parseProperty(builder, element, "version", "version");
        this.parseProperty(builder, element, "messageType", "messageType");
        if (this.hasAttribute(element, "transmissionSession-ref")) {
            if (element.getAttribute("transmissionSession-ref").startsWith("#")) {
                builder.addPropertyValue("transmissionSession", (Object)element.getAttribute("transmissionSession-ref"));
            } else {
                builder.addPropertyValue("transmissionSession", (Object)("#[registry:" + element.getAttribute("transmissionSession-ref") + "]"));
            }
        }
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachProcessorDefinition(parserContext, (BeanDefinition)definition);
        return definition;
    }
}

