/*
 * Decompiled with CFR 0.152.
 */
package com.modus.tpm.client;

import com.modus.tpm.api.model.DocumentDefinition;
import com.modus.tpm.api.model.Endpoint;
import com.modus.tpm.api.model.Entry;
import com.modus.tpm.api.model.Partnership;
import com.modus.tpm.api.model.Route;
import com.modus.tpm.api.model.SecurityConfig;
import com.modus.tpm.client.TpmClientException;
import com.modus.tpm.client.model.DocumentLocator;
import com.modus.tpm.client.model.FilterSpecification;
import com.modus.tpm.client.model.OrganizationPath;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface TpmClient {
    public List<Route> resolveRoutes(String var1, String var2, PartyIdentifierType var3, Standard var4, String var5, String var6, Map<String, Serializable> var7) throws TpmClientException;

    public List<Route> resolveRoutes(String var1, String var2, String var3, String var4, String var5, String var6, Map<String, Serializable> var7) throws TpmClientException;

    public List<Route> resolveRoutesExtended(OrganizationPath var1, DocumentLocator var2, FilterSpecification var3) throws TpmClientException;

    public List<Entry> lookup(String var1, String var2, Map<String, Serializable> var3) throws TpmClientException;

    public Partnership getPartnershipByIdentifiers(String var1, String var2) throws TpmClientException;

    public Partnership getPartnership(String var1) throws TpmClientException;

    public List<Entry> lookupByIds(String var1, String var2, Map<String, Serializable> var3) throws TpmClientException;

    public DocumentDefinition resolveDocumentDefinition(String var1, Standard var2, String var3, String var4) throws TpmClientException;

    public DocumentDefinition resolveDocumentDefinition(String var1, String var2, String var3, String var4) throws TpmClientException;

    public Endpoint resolveEndpoint(String var1, EndpointType var2, String var3, String var4, String var5, String var6) throws TpmClientException;

    public SecurityConfig getSecurityConfig() throws TpmClientException;

    public List<Map<String, Serializable>> search(Resource var1, String var2, Integer var3, Integer var4, String var5, Boolean var6) throws TpmClientException;

    public List<Map<String, Serializable>> search(String var1, String var2, Integer var3, Integer var4, String var5, Boolean var6) throws TpmClientException;

    public String getSecurityConfigToken() throws TpmClientException;

    public static enum Resource {
        ENDPOINT("endpoints"),
        CHANNEL("channels"),
        DOCUMENT_MAP("documentMaps"),
        DOCUMENT_DEFINITION("documentDefinitions"),
        ROSETTANET_AGREEMENT("rosettanetAgreements"),
        ERROR_CODE("errorCodes");

        private final String value;
        private static Map<String, Resource> constants;

        private Resource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        static {
            constants = new HashMap<String, Resource>();
            for (Resource c : Resource.values()) {
                constants.put(c.value, c);
            }
        }
    }

    public static enum EndpointType {
        SEND,
        RECEIVE;

    }

    public static enum PartyIdentifierType {
        AS2,
        ISA,
        GS,
        UNB,
        UNG,
        PARTNER;

    }

    public static enum Standard {
        X12,
        EDIFACT,
        CSV,
        XML,
        OTHER,
        JSON,
        ROSETTANET;

    }
}

