/*
 * Decompiled with CFR 0.152.
 */
package com.modus.tpm.client.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.modus.tpm.api.model.DocumentDefinition;
import com.modus.tpm.api.model.Endpoint;
import com.modus.tpm.api.model.Entry;
import com.modus.tpm.api.model.Partnership;
import com.modus.tpm.api.model.Route;
import com.modus.tpm.api.model.SecurityConfig;
import com.modus.tpm.client.NotFoundTpmClientException;
import com.modus.tpm.client.RouteResolutionServiceClient;
import com.modus.tpm.client.TpmClient;
import com.modus.tpm.client.TpmClientException;
import com.modus.tpm.client.model.DocumentLocator;
import com.modus.tpm.client.model.FilterSpecification;
import com.modus.tpm.client.model.OrganizationPath;
import com.modus.util.remote.HttpClient;
import com.modus.util.remote.RemoteException;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultTpmClient
implements TpmClient,
RouteResolutionServiceClient,
Closeable {
    ObjectMapper objectMapper;
    HttpClient httpClient;

    protected DefaultTpmClient() {
    }

    public DefaultTpmClient(String tpmServiceAddress, String apiKey, String environmentId) throws TpmClientException {
        this(tpmServiceAddress, apiKey, environmentId, 20, 5000, 5000, 5000, 3);
    }

    public DefaultTpmClient(String tpmServiceAddress, String apiKey, String environmentId, int maxTotalConnections, int connectTimeout, int connectionRequestTimeout, int socketTimeout, int maxNoOfRetries) throws TpmClientException {
        try {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.httpClient = new HttpClient(tpmServiceAddress, apiKey, environmentId, maxTotalConnections, socketTimeout, connectTimeout, connectionRequestTimeout, maxNoOfRetries);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public List<Route> resolveRoutes(String fromPartyIdentifier, String toPartyIdentifier, TpmClient.PartyIdentifierType partyIdentifierType, TpmClient.Standard standard, String version, String messageType, Map<String, Serializable> properties) throws TpmClientException {
        return this.resolveRoutes(fromPartyIdentifier, toPartyIdentifier, partyIdentifierType != null ? partyIdentifierType.toString() : null, standard.toString(), version, messageType, properties);
    }

    @Override
    public List<Route> resolveRoutes(String fromPartyIdentifier, String toPartyIdentifier, String partyIdentifierType, String standard, String version, String messageType, Map<String, Serializable> properties) throws TpmClientException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        try {
            queryParams.put("fromPartyIdentifier", fromPartyIdentifier);
            if (toPartyIdentifier != null && !toPartyIdentifier.isEmpty()) {
                queryParams.put("toPartyIdentifier", toPartyIdentifier);
            }
            if (partyIdentifierType != null && !partyIdentifierType.isEmpty()) {
                queryParams.put("partyIdentifierType", partyIdentifierType);
            }
            if (standard != null && !standard.isEmpty()) {
                queryParams.put("standard", standard);
            }
            if (version != null && !version.isEmpty()) {
                queryParams.put("version", version);
            }
            if (messageType != null && !messageType.isEmpty()) {
                queryParams.put("messageType", messageType);
            }
            String routes = properties != null ? this.httpClient.post("routes/resolve", queryParams, this.objectMapper.writeValueAsString(properties)) : this.httpClient.get("routes/resolve");
            JsonNode rootNode = this.objectMapper.readTree(routes);
            return (List)this.objectMapper.readValue(rootNode.get("routes").toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Route.class));
        }
        catch (RemoteException e) {
            if (e.getHttpStatusCode() != 404) {
                throw new TpmClientException(e);
            }
            throw new NotFoundTpmClientException(e);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public List<Route> resolveRoutesExtended(final OrganizationPath organizationPath, final DocumentLocator documentLocator, final FilterSpecification filterSpecification) throws TpmClientException {
        try {
            HashMap<String, Object> routeFinder = new HashMap<String, Object>(){
                {
                    this.put("organizationPath", organizationPath);
                    this.put("documentLocator", documentLocator);
                    this.put("filterSpecification", filterSpecification);
                }
            };
            String serviceResult = this.httpClient.post("routes/resolveExtended", new HashMap<String, String>(), this.objectMapper.writeValueAsString((Object)routeFinder));
            JsonNode rootNode = this.objectMapper.readTree(serviceResult);
            return (List)this.objectMapper.readValue(rootNode.get("routes").toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Route.class));
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public List<Entry> lookup(String lookupTable, String key, Map<String, Serializable> fields) throws TpmClientException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("lookupTable", lookupTable);
            if (key != null) {
                queryParams.put("key", String.valueOf(key));
            }
            String delimitedFields = "";
            for (Map.Entry<String, Serializable> field : fields.entrySet()) {
                delimitedFields = delimitedFields + field.getKey() + ":" + field.getValue() + "&";
            }
            delimitedFields = delimitedFields.substring(0, delimitedFields.length() - 1);
            queryParams.put("fields", delimitedFields);
            String lookupEntries = this.httpClient.get("lookupTables/lookup", queryParams);
            JsonNode rootNode = this.objectMapper.readTree(lookupEntries);
            return (List)this.objectMapper.readValue(rootNode.get("entries").toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Entry.class));
        }
        catch (RemoteException e) {
            if (e.getHttpStatusCode() != 404) {
                throw new TpmClientException(e);
            }
            throw new NotFoundTpmClientException(e);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public List<Entry> lookupByIds(String lookupTableId, String keyId, Map<String, Serializable> fieldIds) throws TpmClientException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("lookupTableId", lookupTableId);
            if (keyId != null) {
                queryParams.put("keyId", String.valueOf(keyId));
            }
            String delimitedFields = "";
            for (Map.Entry<String, Serializable> field : fieldIds.entrySet()) {
                delimitedFields = delimitedFields + field.getKey() + ":" + field.getValue() + "&";
            }
            delimitedFields = delimitedFields.substring(0, delimitedFields.length() - 1);
            queryParams.put("fieldIds", delimitedFields);
            String lookupEntries = this.httpClient.get("lookupTables/lookupByIds", queryParams);
            JsonNode rootNode = this.objectMapper.readTree(lookupEntries);
            return (List)this.objectMapper.readValue(rootNode.get("entries").toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Entry.class));
        }
        catch (RemoteException e) {
            if (e.getHttpStatusCode() != 404) {
                throw new TpmClientException(e);
            }
            throw new NotFoundTpmClientException(e);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public Partnership getPartnershipByIdentifiers(String fromPartyIdentifier, String toPartyIdentifier) throws TpmClientException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            if (fromPartyIdentifier != null) {
                queryParams.put("fromPartyIdentifier", fromPartyIdentifier);
            }
            if (toPartyIdentifier != null) {
                queryParams.put("toPartyIdentifier", toPartyIdentifier);
            }
            String partnership = this.httpClient.get("partnerships/identity", queryParams);
            return (Partnership)this.objectMapper.readValue(partnership, Partnership.class);
        }
        catch (RemoteException e) {
            if (e.getHttpStatusCode() != 404) {
                throw new TpmClientException(e);
            }
            throw new NotFoundTpmClientException(e);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public Partnership getPartnership(String partnershipId) throws TpmClientException {
        try {
            String partnership = this.httpClient.get(String.format("partnerships/%s", partnershipId));
            return (Partnership)this.objectMapper.readValue(partnership, Partnership.class);
        }
        catch (RemoteException e) {
            if (e.getHttpStatusCode() != 404) {
                throw new TpmClientException(e);
            }
            throw new NotFoundTpmClientException(e);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public DocumentDefinition resolveDocumentDefinition(String partnershipId, TpmClient.Standard standard, String version, String messageType) throws TpmClientException {
        return this.resolveDocumentDefinition(partnershipId, standard.toString(), version, messageType);
    }

    @Override
    public DocumentDefinition resolveDocumentDefinition(String partnershipId, String standard, String version, String messageType) throws TpmClientException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("standard", standard);
            if (version != null && !version.isEmpty()) {
                queryParams.put("version", version);
            }
            if (messageType != null && !messageType.isEmpty()) {
                queryParams.put("messageType", messageType);
            }
            String documentDefinition = this.httpClient.get(String.format("partnerships/%s/resolve/documentDefinition", partnershipId), queryParams);
            return (DocumentDefinition)this.objectMapper.readValue(documentDefinition, DocumentDefinition.class);
        }
        catch (RemoteException e) {
            if (e.getHttpStatusCode() != 404) {
                throw new TpmClientException(e);
            }
            throw new NotFoundTpmClientException(e);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public SecurityConfig getSecurityConfig() throws TpmClientException {
        try {
            String securityConfig = this.httpClient.get("securityConfig");
            return (SecurityConfig)this.objectMapper.readValue(securityConfig, SecurityConfig.class);
        }
        catch (RemoteException e) {
            if (e.getHttpStatusCode() != 404) {
                throw new TpmClientException(e);
            }
            throw new NotFoundTpmClientException(e);
        }
        catch (Throwable t) {
            throw new TpmClientException(t);
        }
    }

    @Override
    public String getSecurityConfigToken() throws TpmClientException {
        try {
            String securityConfig = this.httpClient.get("securityConfig/token");
            return ((Map)this.objectMapper.readValue(securityConfig, Map.class)).get("access_token").toString();
        }
        catch (RemoteException e) {
            if (e.getHttpStatusCode() != 404) {
                throw new TpmClientException(e);
            }
            throw new NotFoundTpmClientException(e);
        }
        catch (Throwable t) {
            throw new TpmClientException(t);
        }
    }

    @Override
    public Endpoint resolveEndpoint(String partnershipId, TpmClient.EndpointType endpointType, String transportType, String standard, String version, String messageType) throws TpmClientException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("endpointType", endpointType.toString());
            queryParams.put("transportType", transportType);
            if (standard != null && !standard.isEmpty()) {
                queryParams.put("standard", standard.toUpperCase());
            }
            if (version != null && !version.isEmpty()) {
                queryParams.put("version", version);
            }
            if (messageType != null && !messageType.isEmpty()) {
                queryParams.put("messageType", messageType);
            }
            String endpoint = this.httpClient.get(String.format("partnerships/%s/resolve/endpoints", partnershipId), queryParams);
            return (Endpoint)this.objectMapper.readValue(endpoint, Endpoint.class);
        }
        catch (RemoteException e) {
            if (e.getHttpStatusCode() != 404) {
                throw new TpmClientException(e);
            }
            throw new NotFoundTpmClientException(e);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public List<Map<String, Serializable>> search(TpmClient.Resource resource, String query, Integer count, Integer offset, String orderBy, Boolean desc) throws TpmClientException {
        return this.search(resource.toString(), query, count, offset, orderBy, desc);
    }

    @Override
    public List<Map<String, Serializable>> search(String resource, String query, Integer count, Integer offset, String orderBy, Boolean desc) throws TpmClientException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("q", query);
            if (count != null) {
                queryParams.put("count", String.valueOf(count));
            }
            if (offset != null) {
                queryParams.put("offset", String.valueOf(offset));
            }
            if (orderBy != null) {
                queryParams.put("orderBy", orderBy);
            }
            if (desc != null) {
                queryParams.put("desc", String.valueOf(desc));
            }
            String result = this.httpClient.get(resource, queryParams);
            ObjectReader objectReader = this.objectMapper.reader(List.class).withRootName(resource).with(DeserializationFeature.UNWRAP_ROOT_VALUE);
            return (List)objectReader.readValue(result);
        }
        catch (RemoteException e) {
            if (e.getHttpStatusCode() != 404) {
                throw new TpmClientException(e);
            }
            throw new NotFoundTpmClientException(e);
        }
        catch (Exception e) {
            throw new TpmClientException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }
}

