/*
 * Decompiled with CFR 0.152.
 */
package com.modus.tracker.client;

import com.modus.tracker.client.TrackerClientException;
import com.modus.tracker.model.TransactionCreate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface TrackerClient {
    public List<Map<String, Serializable>> startTransactionsReplay(Integer var1) throws TrackerClientException;

    public void endTransactionsReplay(List<String> var1) throws TrackerClientException;

    public List<Map<String, Serializable>> findExchangesByToken(ExchangeType var1, Map<String, String> var2) throws TrackerClientException;

    public Map<String, Serializable> publishExchange(ExchangeType var1, Map<String, Serializable> var2) throws TrackerClientException;

    public void createTransaction(TransactionCreate var1) throws TrackerClientException;

    public void updateTransactionStatus(String var1, Status var2) throws TrackerClientException;

    public List<Map<String, Serializable>> getEventsByTransactionId(String var1) throws TrackerClientException;

    public Map<String, Serializable> evaluateTransactionReleaseStatus(String var1, String var2) throws TrackerClientException;

    public Map<String, Serializable> evaluateTransactionReleaseStatus(String var1, String var2, String var3) throws TrackerClientException;

    public List<Map<String, Serializable>> startTransactionsRelease(Integer var1, Integer var2) throws TrackerClientException;

    public void endTransactionsRelease(List<String> var1) throws TrackerClientException;

    public void notify(String var1) throws TrackerClientException;

    public List<Map<String, Serializable>> startErrorsNotification(Integer var1) throws TrackerClientException;

    public void endErrorsNotification(List<String> var1) throws TrackerClientException;

    public List<Map<String, Serializable>> search(Resource var1, String var2, Integer var3, Integer var4, String var5, Boolean var6) throws TrackerClientException;

    public List<Map<String, Serializable>> search(String var1, String var2, Integer var3, Integer var4, String var5, Boolean var6) throws TrackerClientException;

    public static enum Resource {
        ERROR("errors"),
        BUSINESS_DOCUMENT("businessDocuments");

        private final String value;
        private static Map<String, Resource> constants;

        private Resource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        static {
            constants = new HashMap<String, Resource>();
            for (Resource c : Resource.values()) {
                constants.put(c.value, c);
            }
        }
    }

    public static enum ExchangeType {
        AS2,
        FTPS;

    }

    public static enum Status {
        ACTIVE,
        COMPLETE;

    }
}

