/*
 * Decompiled with CFR 0.152.
 */
package com.modus.tracker.client.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.common.collect.ImmutableMap;
import com.modus.tracker.client.TrackerClient;
import com.modus.tracker.client.TrackerClientContext;
import com.modus.tracker.client.TrackerClientException;
import com.modus.tracker.client.UnRetryableException;
import com.modus.tracker.model.TransactionCreate;
import com.modus.util.remote.HttpClient;
import com.modus.util.remote.RemoteException;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.shade.pmc.client.methods.CloseableHttpResponse;
import org.apache.http.shade.pmc.client.utils.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTrackerClient
implements TrackerClient,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTrackerClient.class);
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;

    public DefaultTrackerClient(String trackerAddress, String apiKey, String environmentId) throws TrackerClientException {
        this(trackerAddress, apiKey, environmentId, 20, 5000, 5000, 5000, 3);
    }

    public DefaultTrackerClient(String trackerAddress, String apiKey, String environmentId, int maxTotalConnections, int connectTimeout, int connectionRequestTimeout, int socketTimeout, int maxNoOfRetries) throws TrackerClientException {
        try {
            this.objectMapper = TrackerClientContext.getInstance().getObjectMapper();
            this.httpClient = new HttpClient(trackerAddress, apiKey, environmentId, maxTotalConnections, socketTimeout, connectTimeout, connectionRequestTimeout, maxNoOfRetries);
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public void endTransactionsReplay(List<String> transactionIds) throws TrackerClientException {
        try {
            Objects.requireNonNull(transactionIds, "Transaction ID list is undefined");
            if (transactionIds.isEmpty()) {
                throw new TrackerClientException("Transaction ID list is empty");
            }
            for (String transactionId : transactionIds) {
                Objects.requireNonNull(transactionId, "Undefined transaction ID");
            }
            HashMap<String, List<String>> transactionsIdsMap = new HashMap<String, List<String>>();
            transactionsIdsMap.put("transactionIds", transactionIds);
            this.httpClient.patch("transactions/replayed", this.objectMapper.writeValueAsString(transactionsIdsMap));
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public List<Map<String, Serializable>> findExchangesByToken(TrackerClient.ExchangeType exchangeType, Map<String, String> token) throws TrackerClientException {
        try {
            String content = this.httpClient.get(String.format("exchanges/%s", exchangeType.toString().toLowerCase()), token);
            return (List)((Map)this.objectMapper.readValue(content, Map.class)).get("exchanges");
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public Map<String, Serializable> publishExchange(TrackerClient.ExchangeType exchangeType, Map<String, Serializable> exchange) throws TrackerClientException {
        try {
            String serializedExchange = TrackerClientContext.getInstance().getObjectMapper().writeValueAsString(exchange);
            String content = this.httpClient.post(String.format("exchanges/%s", exchangeType.toString().toLowerCase()), null, serializedExchange);
            return (Map)this.objectMapper.readValue(content, Map.class);
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public List<Map<String, Serializable>> startTransactionsReplay(Integer replayingTimeout) throws TrackerClientException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            if (replayingTimeout != null) {
                queryParams.put("replayingTimeout", String.valueOf(replayingTimeout));
            }
            String content = this.httpClient.post("transactions/replay", queryParams);
            JsonNode rootNode = this.objectMapper.readTree(content);
            return (List)this.objectMapper.readValue(rootNode.get("transactions").toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Map.class));
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public void createTransaction(TransactionCreate transactionCreate) throws TrackerClientException {
        try {
            String transaction = this.objectMapper.writer((FilterProvider)new SimpleFilterProvider().addFilter("documentPropertyTypeNameFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"documentPropertyTypeName"}))).writeValueAsString((Object)transactionCreate);
            this.httpClient.post("transactions", null, transaction);
        }
        catch (RemoteException e) {
            if (e.getHttpStatusCode() >= 400 && e.getHttpStatusCode() < 500) {
                throw new UnRetryableException(e);
            }
            throw new TrackerClientException(e);
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public void updateTransactionStatus(String transactionId, TrackerClient.Status status) throws TrackerClientException {
        try {
            String transaction = TrackerClientContext.getInstance().getObjectMapper().writeValueAsString((Object)ImmutableMap.of((Object)"status", (Object)status.toString()));
            this.httpClient.put(String.format("transactions/%s", transactionId), transaction);
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public List<Map<String, Serializable>> getEventsByTransactionId(String transactionId) throws TrackerClientException {
        try {
            String content = this.httpClient.get(String.format("transactions/%s/events", transactionId));
            return (List)this.objectMapper.readValue(content, List.class);
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public Map<String, Serializable> evaluateTransactionReleaseStatus(String transactionId, String routeId) throws TrackerClientException {
        return this.evaluateTransactionReleaseStatus(transactionId, routeId, null);
    }

    @Override
    public Map<String, Serializable> evaluateTransactionReleaseStatus(String transactionId, String routeId, String routeStatus) throws TrackerClientException {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("routeId", routeId);
        if (routeStatus != null) {
            body.put("routeStatus", routeStatus);
        }
        try {
            String content = this.httpClient.patch(String.format("transactions/%s/releaseStatus", transactionId), this.objectMapper.writeValueAsString(body));
            return (Map)this.objectMapper.readValue(content, Map.class);
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public List<Map<String, Serializable>> startTransactionsRelease(Integer releasingTimeout, Integer maxTransactions) throws TrackerClientException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            if (releasingTimeout != null) {
                queryParams.put("releasingTimeout", String.valueOf(releasingTimeout));
            }
            if (maxTransactions != null) {
                queryParams.put("maxTransactions", String.valueOf(maxTransactions));
            }
            String content = this.httpClient.post("transactions/release", queryParams);
            JsonNode rootNode = this.objectMapper.readTree(content);
            return (List)this.objectMapper.readValue(rootNode.get("transactions").toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Map.class));
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public void endTransactionsRelease(List<String> transactionIds) throws TrackerClientException {
        try {
            HashMap<String, List<String>> transactionsIdsMap = new HashMap<String, List<String>>();
            transactionsIdsMap.put("transactionIds", transactionIds);
            this.httpClient.patch("transactions/released", this.objectMapper.writeValueAsString(transactionsIdsMap));
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public void notify(String errorId) throws TrackerClientException {
        try {
            this.httpClient.patch(String.format("errors/%s/notify", errorId));
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public List<Map<String, Serializable>> startErrorsNotification(Integer notifyingTimeout) throws TrackerClientException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            if (notifyingTimeout != null) {
                queryParams.put("notifyingTimeout", String.valueOf(notifyingTimeout));
            }
            String content = this.httpClient.post("errors/notify", queryParams);
            JsonNode rootNode = this.objectMapper.readTree(content);
            return (List)this.objectMapper.readValue(rootNode.get("errors").toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Map.class));
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public void endErrorsNotification(List<String> errorIds) throws TrackerClientException {
        CloseableHttpResponse httpResponse = null;
        try {
            HashMap<String, List<String>> errorIdsMap = new HashMap<String, List<String>>();
            errorIdsMap.put("errorIds", errorIds);
            this.httpClient.patch("errors/notified", this.objectMapper.writeValueAsString(errorIdsMap));
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
        finally {
            HttpClientUtils.closeQuietly(httpResponse);
        }
    }

    @Override
    public List<Map<String, Serializable>> search(TrackerClient.Resource resource, String query, Integer count, Integer offset, String orderBy, Boolean desc) throws TrackerClientException {
        return this.search(resource.toString(), query, count, offset, orderBy, desc);
    }

    @Override
    public List<Map<String, Serializable>> search(String resource, String query, Integer count, Integer offset, String orderBy, Boolean desc) throws TrackerClientException {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("q", query);
            if (count != null) {
                queryParams.put("count", String.valueOf(count));
            }
            if (offset != null) {
                queryParams.put("offset", String.valueOf(offset));
            }
            if (orderBy != null) {
                queryParams.put("orderBy", orderBy);
            }
            if (desc != null) {
                queryParams.put("desc", String.valueOf(desc));
            }
            ObjectReader objectReader = this.objectMapper.reader(List.class).withRootName(resource).with(DeserializationFeature.UNWRAP_ROOT_VALUE);
            return (List)objectReader.readValue(this.httpClient.get(resource, queryParams));
        }
        catch (Exception e) {
            throw new TrackerClientException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }
}

