/*
 * Decompiled with CFR 0.152.
 */
package com.modus.util.remote;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.shade.pmc.HttpEntity;
import org.apache.http.shade.pmc.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    public static String createHttpResponseExceptionMessage(String message, HttpResponse httpResponse) {
        String exceptionMessage;
        try {
            HttpEntity entity = httpResponse.getEntity();
            String content = null;
            if (entity != null) {
                content = IOUtils.toString((InputStream)entity.getContent());
            }
            exceptionMessage = content == null || content.isEmpty() ? message + ". HTTP status code => " + httpResponse.getStatusLine().getStatusCode() + " (" + httpResponse.getStatusLine().getReasonPhrase() + ")." : message + ". HTTP status code => " + httpResponse.getStatusLine().getStatusCode() + " (" + httpResponse.getStatusLine().getReasonPhrase() + "). Reply content => " + content;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            exceptionMessage = message + ". HTTP status code => " + httpResponse.getStatusLine().getStatusCode() + " (" + httpResponse.getStatusLine().getReasonPhrase() + "). Could not log reply content";
        }
        return exceptionMessage;
    }

    public static boolean isSuccessful(HttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode() >= 200 && httpResponse.getStatusLine().getStatusCode() < 300;
    }
}

