/*
 * Decompiled with CFR 0.152.
 */
package com.modus.util.remote;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.shade.pmc.HttpEntity;
import org.apache.http.shade.pmc.HttpEntityEnclosingRequest;
import org.apache.http.shade.pmc.HttpException;
import org.apache.http.shade.pmc.HttpRequest;
import org.apache.http.shade.pmc.HttpRequestInterceptor;
import org.apache.http.shade.pmc.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogHttpRequestInterceptor
implements HttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LogHttpRequestInterceptor.class);
    private final String apiKey;

    public LogHttpRequestInterceptor(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        InputStream inputStream;
        HttpEntity entity;
        String content = null;
        context.setAttribute("http.retries", context.getAttribute("http.retries") != null ? (Integer)context.getAttribute("http.retries") + 1 : 0);
        request.setHeader("X-API-Key", this.apiKey);
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null && (inputStream = ((HttpEntityEnclosingRequest)request).getEntity().getContent()) != null) {
            content = IOUtils.toString((InputStream)inputStream);
        }
        if (content != null) {
            logger.debug(String.format("\n%s\n%s\n", request.getRequestLine().toString(), content));
        } else {
            logger.debug(String.format("\n%s\n", request.getRequestLine().toString()));
        }
    }
}

