/*
 * Decompiled with CFR 0.152.
 */
package com.modus.util.remote;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.shade.pmc.NameValuePair;
import org.apache.http.shade.pmc.client.utils.URIBuilder;
import org.apache.http.shade.pmc.message.BasicNameValuePair;

class UriBuilderFactory {
    private final String host;
    private final String environmentId;

    public UriBuilderFactory(String host, String environmentId) throws URISyntaxException {
        this.host = host;
        this.environmentId = environmentId;
    }

    public URIBuilder create(String path) throws URISyntaxException {
        return this.create(path, null);
    }

    public URIBuilder create(String path, Map<String, String> queryParams) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(this.host + path);
        if (queryParams != null) {
            ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
            for (Map.Entry<String, String> queryParam : queryParams.entrySet()) {
                nameValuePairs.add(new BasicNameValuePair(queryParam.getKey(), queryParam.getValue()));
            }
            uriBuilder.addParameters(nameValuePairs);
        }
        return uriBuilder.addParameter("environmentId", this.environmentId);
    }
}

