/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.client.protocol;

import java.io.IOException;
import org.apache.http.shade.pmc.HttpEntity;
import org.apache.http.shade.pmc.HttpEntityEnclosingRequest;
import org.apache.http.shade.pmc.HttpException;
import org.apache.http.shade.pmc.HttpRequest;
import org.apache.http.shade.pmc.HttpRequestInterceptor;
import org.apache.http.shade.pmc.HttpVersion;
import org.apache.http.shade.pmc.ProtocolVersion;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.client.config.RequestConfig;
import org.apache.http.shade.pmc.client.protocol.HttpClientContext;
import org.apache.http.shade.pmc.protocol.HttpContext;
import org.apache.http.shade.pmc.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

