/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.impl.client;

import org.apache.http.shade.pmc.HttpResponse;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.client.ServiceUnavailableRetryStrategy;
import org.apache.http.shade.pmc.protocol.HttpContext;
import org.apache.http.shade.pmc.util.Args;

@Immutable
public class DefaultServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final int maxRetries;
    private final long retryInterval;

    public DefaultServiceUnavailableRetryStrategy(int maxRetries, int retryInterval) {
        Args.positive(maxRetries, "Max retries");
        Args.positive(retryInterval, "Retry interval");
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
    }

    public DefaultServiceUnavailableRetryStrategy() {
        this(1, 1000);
    }

    @Override
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        return executionCount <= this.maxRetries && response.getStatusLine().getStatusCode() == 503;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }
}

