/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.impl.client;

import java.security.Principal;
import javax.net.ssl.SSLSession;
import org.apache.http.shade.pmc.HttpConnection;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.auth.AuthScheme;
import org.apache.http.shade.pmc.auth.AuthState;
import org.apache.http.shade.pmc.auth.Credentials;
import org.apache.http.shade.pmc.client.UserTokenHandler;
import org.apache.http.shade.pmc.client.protocol.HttpClientContext;
import org.apache.http.shade.pmc.conn.ManagedHttpClientConnection;
import org.apache.http.shade.pmc.protocol.HttpContext;

@Immutable
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public static final DefaultUserTokenHandler INSTANCE = new DefaultUserTokenHandler();

    @Override
    public Object getUserToken(HttpContext context) {
        SSLSession sslsession;
        HttpConnection conn;
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Principal userPrincipal = null;
        AuthState targetAuthState = clientContext.getTargetAuthState();
        if (targetAuthState != null && (userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(targetAuthState)) == null) {
            AuthState proxyAuthState = clientContext.getProxyAuthState();
            userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(proxyAuthState);
        }
        if (userPrincipal == null && (conn = clientContext.getConnection()).isOpen() && conn instanceof ManagedHttpClientConnection && (sslsession = ((ManagedHttpClientConnection)conn).getSSLSession()) != null) {
            userPrincipal = sslsession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials creds;
        AuthScheme scheme = authState.getAuthScheme();
        if (scheme != null && scheme.isComplete() && scheme.isConnectionBased() && (creds = authState.getCredentials()) != null) {
            return creds.getUserPrincipal();
        }
        return null;
    }
}

