/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.impl.cookie;

import java.util.Date;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.client.utils.DateUtils;
import org.apache.http.shade.pmc.cookie.CommonCookieAttributeHandler;
import org.apache.http.shade.pmc.cookie.MalformedCookieException;
import org.apache.http.shade.pmc.cookie.SetCookie;
import org.apache.http.shade.pmc.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.http.shade.pmc.util.Args;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

