/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.impl.entity;

import org.apache.http.shade.pmc.Header;
import org.apache.http.shade.pmc.HttpException;
import org.apache.http.shade.pmc.HttpMessage;
import org.apache.http.shade.pmc.HttpVersion;
import org.apache.http.shade.pmc.ProtocolException;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.entity.ContentLengthStrategy;
import org.apache.http.shade.pmc.util.Args;

@Immutable
public class StrictContentLengthStrategy
implements ContentLengthStrategy {
    public static final StrictContentLengthStrategy INSTANCE = new StrictContentLengthStrategy();
    private final int implicitLen;

    public StrictContentLengthStrategy(int implicitLen) {
        this.implicitLen = implicitLen;
    }

    public StrictContentLengthStrategy() {
        this(-1);
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        Args.notNull(message, "HTTP message");
        Header transferEncodingHeader = message.getFirstHeader("Transfer-Encoding");
        if (transferEncodingHeader != null) {
            String s = transferEncodingHeader.getValue();
            if ("chunked".equalsIgnoreCase(s)) {
                if (message.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + message.getProtocolVersion());
                }
                return -2L;
            }
            if ("identity".equalsIgnoreCase(s)) {
                return -1L;
            }
            throw new ProtocolException("Unsupported transfer encoding: " + s);
        }
        Header contentLengthHeader = message.getFirstHeader("Content-Length");
        if (contentLengthHeader != null) {
            String s = contentLengthHeader.getValue();
            try {
                long len = Long.parseLong(s);
                if (len < 0L) {
                    throw new ProtocolException("Negative content length: " + s);
                }
                return len;
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("Invalid content length: " + s);
            }
        }
        return this.implicitLen;
    }
}

