/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.impl.io;

import org.apache.http.shade.pmc.HttpResponse;
import org.apache.http.shade.pmc.HttpResponseFactory;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.config.MessageConstraints;
import org.apache.http.shade.pmc.impl.DefaultHttpResponseFactory;
import org.apache.http.shade.pmc.impl.io.DefaultHttpResponseParser;
import org.apache.http.shade.pmc.io.HttpMessageParser;
import org.apache.http.shade.pmc.io.HttpMessageParserFactory;
import org.apache.http.shade.pmc.io.SessionInputBuffer;
import org.apache.http.shade.pmc.message.BasicLineParser;
import org.apache.http.shade.pmc.message.LineParser;

@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

