/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.impl.nio.pool;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.http.shade.pmc.HttpHost;
import org.apache.http.shade.pmc.HttpRequest;
import org.apache.http.shade.pmc.HttpResponse;
import org.apache.http.shade.pmc.HttpResponseFactory;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.config.ConnectionConfig;
import org.apache.http.shade.pmc.impl.DefaultHttpResponseFactory;
import org.apache.http.shade.pmc.impl.nio.DefaultNHttpClientConnectionFactory;
import org.apache.http.shade.pmc.impl.nio.SSLNHttpClientConnectionFactory;
import org.apache.http.shade.pmc.nio.NHttpClientConnection;
import org.apache.http.shade.pmc.nio.NHttpConnectionFactory;
import org.apache.http.shade.pmc.nio.NHttpMessageParserFactory;
import org.apache.http.shade.pmc.nio.NHttpMessageWriterFactory;
import org.apache.http.shade.pmc.nio.pool.NIOConnFactory;
import org.apache.http.shade.pmc.nio.reactor.IOSession;
import org.apache.http.shade.pmc.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.shade.pmc.nio.util.ByteBufferAllocator;
import org.apache.http.shade.pmc.nio.util.HeapByteBufferAllocator;
import org.apache.http.shade.pmc.params.HttpParams;
import org.apache.http.shade.pmc.util.Args;

@Immutable
public class BasicNIOConnFactory
implements NIOConnFactory<HttpHost, NHttpClientConnection> {
    private final NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory;
    private final NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory;

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory, NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory) {
        Args.notNull(plainFactory, "Plain HTTP client connection factory");
        this.plainFactory = plainFactory;
        this.sslFactory = sslFactory;
    }

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory) {
        this(plainFactory, null);
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        this(new DefaultNHttpClientConnectionFactory(responseFactory, allocator, params), new SSLNHttpClientConnectionFactory(sslcontext, sslHandler, responseFactory, allocator, params));
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslcontext, sslHandler, DefaultHttpResponseFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    @Deprecated
    public BasicNIOConnFactory(HttpParams params) {
        this(null, null, params);
    }

    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ByteBufferAllocator allocator, ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(responseParserFactory, requestWriterFactory, allocator, config), new SSLNHttpClientConnectionFactory(sslcontext, sslHandler, responseParserFactory, requestWriterFactory, allocator, config));
    }

    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, ConnectionConfig config) {
        this(sslcontext, sslHandler, null, null, null, config);
    }

    public BasicNIOConnFactory(ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(config), null);
    }

    @Override
    public NHttpClientConnection create(HttpHost route, IOSession session) throws IOException {
        NHttpClientConnection conn;
        if (route.getSchemeName().equalsIgnoreCase("https")) {
            if (this.sslFactory == null) {
                throw new IOException("SSL not supported");
            }
            conn = this.sslFactory.createConnection(session);
        } else {
            conn = this.plainFactory.createConnection(session);
        }
        session.setAttribute("http.connection", conn);
        return conn;
    }
}

