/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.impl.pool;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.shade.pmc.HttpClientConnection;
import org.apache.http.shade.pmc.HttpHost;
import org.apache.http.shade.pmc.annotation.ThreadSafe;
import org.apache.http.shade.pmc.config.ConnectionConfig;
import org.apache.http.shade.pmc.config.SocketConfig;
import org.apache.http.shade.pmc.impl.pool.BasicConnFactory;
import org.apache.http.shade.pmc.impl.pool.BasicPoolEntry;
import org.apache.http.shade.pmc.params.HttpParams;
import org.apache.http.shade.pmc.pool.AbstractConnPool;
import org.apache.http.shade.pmc.pool.ConnFactory;

@ThreadSafe
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

