/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.nio.protocol;

import java.io.IOException;
import org.apache.http.shade.pmc.HttpException;
import org.apache.http.shade.pmc.HttpRequest;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.shade.pmc.nio.protocol.HttpAsyncExchange;
import org.apache.http.shade.pmc.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.shade.pmc.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.shade.pmc.protocol.HttpContext;
import org.apache.http.shade.pmc.protocol.HttpRequestHandler;
import org.apache.http.shade.pmc.util.Args;

@Immutable
public class BasicAsyncRequestHandler
implements HttpAsyncRequestHandler<HttpRequest> {
    private final HttpRequestHandler handler;

    public BasicAsyncRequestHandler(HttpRequestHandler handler) {
        Args.notNull(handler, "Request handler");
        this.handler = handler;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(HttpRequest request, HttpAsyncExchange httpexchange, HttpContext context) throws HttpException, IOException {
        this.handler.handle(request, httpexchange.getResponse(), context);
        httpexchange.submitResponse();
    }
}

