/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.pmc.protocol;

import java.io.IOException;
import org.apache.http.shade.pmc.HttpException;
import org.apache.http.shade.pmc.HttpResponse;
import org.apache.http.shade.pmc.HttpResponseInterceptor;
import org.apache.http.shade.pmc.annotation.Immutable;
import org.apache.http.shade.pmc.protocol.HttpContext;
import org.apache.http.shade.pmc.util.Args;

@Immutable
public class ResponseServer
implements HttpResponseInterceptor {
    private final String originServer;

    public ResponseServer(String originServer) {
        this.originServer = originServer;
    }

    public ResponseServer() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Server") && this.originServer != null) {
            response.addHeader("Server", this.originServer);
        }
    }
}

