# Template Retail Partners System API

+ [License Agreement](#licenseagreement)
+ [Use Case](#usecase)
+ [Considerations](#considerations)
	* [APIs security considerations](#apissecurityconsiderations)
+ [Run it!](#runit)
	* [Running on premise](#runonopremise)
	* [Running on Studio](#runonstudio)
	* [Running on Mule ESB stand alone](#runonmuleesbstandalone)
	* [Running on CloudHub](#runoncloudhub)
	* [Deploying your Anypoint Template on CloudHub](#deployingyouranypointtemplateoncloudhub)
	* [Applying policies on CloudHub](#applyingpolicies)
	* [Properties to be configured (With examples)](#propertiestobeconfigured)

# License Agreement <a name="licenseagreement"/>
Note that using this template is subject to the conditions of this [License Agreement](AnypointTemplateLicense.pdf).
Please review the terms of the license before downloading and using this template. In short, you are allowed to use the template for free with Mule ESB Enterprise Edition, CloudHub, or as a trial in Anypoint Studio.

# Use Case <a name="usecase"/>

This API is part of Retail Catalyst and serves to get information about Partners and their products. It allows to check the available items and also makes reservations through Partners configured using Anypoint Partners Manager.

More information about Anypoint Partners Manager is available [here](https://docs.mulesoft.com/anypoint-b2b/anypoint-partner-manager).

Please, have a look at the provided RAML file (in folder src/main/api) to see what operations are available.

# Considerations <a name="considerations"/>

To make this Anypoint Template run, there are certain preconditions that must be considered. **Failling to do so could lead to unexpected behavior of the template.**

## APIs security considerations <a name="apissecurityconsiderations"/>
This API is meant to be deployed to CloudHub and managed using the API Platform Manager.

# Run it! <a name="runit"/>
Simple steps to get Retail Partners System API running.
See below.

## Running on premise <a name="runonopremise"/>
In this section we detail the way you should run your Anypoint Template on your computer.


### Where to Download Anypoint Studio and Mule ESB
First thing to know if you are a newcomer to Mule is where to get the tools.

+ You can download Anypoint Studio from this [Location](https://www.mulesoft.com/platform/studio)
+ You can download Mule ESB from this [Location](https://www.mulesoft.com/platform/soa/mule-esb-open-source-esb)

### Importing an Anypoint Template into Studio
Anypoint Studio offers several ways to import a project into the workspace, for instance: 

+ Anypoint Studio generated Deployable Archive (.zip)
+ Anypoint Studio Project from External Location
+ Maven-based Mule Project from pom.xml
+ Mule ESB Configuration XML from External Location

You can find a detailed description on how to do so in this [Documentation Page](https://docs.mulesoft.com/anypoint-studio/v/6/importing-and-exporting-in-studio).

### Running on Studio <a name="runonstudio"/>
Once you have imported you Anypoint Template into Anypoint Studio you need to follow these steps to run it:

+ Locate the properties file `mule-<env>.properties`, in src/main/app/resources
+ Complete all the properties required as per the examples in the section [Properties to be configured](#propertiestobeconfigured)
+ Once that is done, right click on you Anypoint Template project folder 
+ Hover you mouse over `"Run as"`
+ Click on  `"Mule Application"`

### Running on Mule ESB stand alone <a name="runonmuleesbstandalone"/>
Complete all properties in one of the property files, for example in [mule.prod.properties](../master/src/main/resources/mule.prod.properties) and run your app with the corresponding environment variable to use it. To follow the example, this will be `mule.env=prod`. 

## Running on CloudHub <a name="runoncloudhub"/>
While [creating your application on CloudHub](https://docs.mulesoft.com/runtime-manager/hello-world-on-cloudhub) (Or you can do it later as a next step), you need to go to `"Manage Application"` > `"Properties"` to set all environment variables detailed in **Properties to be configured**.
Follow other steps defined [here](#runonpremise) and once your app is all set and started, there is no need to do anything else.

### Deploying your Anypoint Template on CloudHub <a name="deployingyouranypointtemplateoncloudhub"/>
Anypoint Studio provides you with really easy way to deploy your Template directly to CloudHub, for the specific steps to do so please check this [link](https://docs.mulesoft.com/mule-user-guide/v/3.8/deploying#DeployingMuleApplications-DeploytoCloudHub)

### Applying policies on CloudHub <a name="applyingpolicies"/>
When a Mule application is deployed using the Mule 3.8.4+ Runtime, the API Manager allows you to dynamically apply different policies that can be used for securing the application, among many other things. More information can be found in [API Manager policies documentation](https://docs.mulesoft.com/api-manager/using-policies)

## Properties to be configured (With examples) <a name="propertiestobeconfigured"/>
In order to use this Mule Anypoint Template you need to configure properties (Credentials, configurations, etc.) either in properties file or in CloudHub as Environment Variables. 

Detailed list with examples:
### Application properties
+ http.port `8081`

+ db.host `example.com`
+ db.port `3306`
+ db.user `username`
+ db.password `password`
+ db.database `dbname`

### B2B Partner Manager properties

+ partner.a.id `e3159004-08f3-49cc-bf5e-4399ece93ef1`

+ pmc.environmentId `31194b75-c1de-4349-ad00-52466f86f0ad`
+ pmc.apiKey `2e78dd042a694e159344b3b5c2932ca5`
+ pmc.trackerAddress `https://anypoint.mulesoft.com/b2b/tracker/api`
+ pmc.tpmServiceAddress `https://anypoint.mulesoft.com/b2b/tpm/api`
+ pmc.host `anypoint.mulesoft.com`

+ as2.customer.id `AnypointStore`

+ as2.customer.receive.http.host `localhost`
+ as2.customer.receive.http.port `8084`

+ as2.customer.send.http.host `localhost`
+ as2.customer.send.http.port `8085`

+ as2.mock-supplier.id `BestAmazing`

+ as2.mock-supplier.receive.http.host `localhost`
+ as2.mock-supplier.receive.http.port `8085`

+ as2.mock-supplier.send.http.host `localhost`
+ as2.mock-supplier.send.http.port `8084`

+ x12.customer.interchange.id `ZZ`
+ x12.customer.id `AnypointStore`

+ x12.mock-supplier.interchange.id `ZZ`
+ x12.mock-supplier.id `BestAmazing`

S3 Bucket properties for storing B2B messages

+ s3.accessKeyId `2e78dd04b3b5c2932ca5`
+ s3.secretKey `2e78dd042a694e159344b3b5c2932ca5`
+ s3.bucketName `messages-bucket`
+ s3.region `us-west-1`
