/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.1.2.3.lib.lexical;

import com.mulesoft.flatfile.1.2.3.lib.lexical.DelimiterWriter;
import com.mulesoft.flatfile.1.2.3.lib.lexical.WriteException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;

public class HL7Writer
extends DelimiterWriter {
    public HL7Writer(OutputStream os, Charset encoding, String delims, int subst) {
        super(os, encoding, delims.charAt(0), delims.charAt(1), delims.charAt(4), delims.charAt(2), '\r', null, delims.charAt(3), subst, '.', null);
    }

    @Override
    String convertEscape(char chr) throws WriteException {
        StringBuilder builder = new StringBuilder();
        char rls = (char)this.releaseIndicator;
        builder.append(rls);
        if (chr == this.releaseIndicator) {
            builder.append('E');
        } else if (chr == this.dataSeparator) {
            builder.append('F');
        } else if (chr == this.repetitionSeparator) {
            builder.append('R');
        } else if (chr == this.componentSeparator) {
            builder.append('S');
        } else if (chr == this.subCompSeparator) {
            builder.append('T');
        } else {
            throw new WriteException("unsupported character in data " + chr);
        }
        builder.append(rls);
        return builder.toString();
    }

    @Override
    public void init(Map<String, Object> props) throws IOException {
        this.writer.write("MSH");
        this.writeDataSeparator();
        this.writer.write((String)props.get("MSH-02"));
    }

    @Override
    public void term(Map<String, Object> props) throws IOException {
    }

    public void writeSeqId(int value) throws IOException {
        if (value < 0) {
            throw new WriteException("value cannot be negative");
        }
        String text = Integer.toString(value);
        if (text.length() > 4) {
            throw new WriteException("value too long");
        }
        this.writeToken(text);
    }
}

