/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.1.2.3.lib.lexical;

import com.mulesoft.flatfile.1.2.3.lib.lexical.EdiConstants;
import com.mulesoft.flatfile.1.2.3.lib.lexical.ErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.log4j.Logger;

public abstract class LexerBase
implements ErrorHandler {
    protected final Logger logger = Logger.getLogger(this.getClass());
    final InputStream stream;
    final int altDecimalMark;
    Reader reader;
    ErrorHandler errorHandler;
    int substitutionChar;
    int groupCount;
    int segmentNumber;
    int elementNumber;
    EdiConstants.ItemType currentType;
    StringBuilder tokenBuilder;

    public LexerBase(InputStream is, int altmark) {
        this.stream = is;
        this.altDecimalMark = altmark;
        this.tokenBuilder = new StringBuilder();
    }

    public int getAltDecimalMark() {
        return this.altDecimalMark;
    }

    public void setHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public abstract void discardTo(EdiConstants.ItemType var1) throws IOException;

    public void discardSegment() throws IOException {
        this.discardTo(EdiConstants.ItemType.SEGMENT);
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable throwable) {}
        } else {
            try {
                this.stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void readArray(byte[] byts, int from) throws IOException {
        int count;
        for (int offset = from; byts.length > offset; offset += count) {
            count = this.stream.read(byts, offset, byts.length - offset);
            if (count > 0) continue;
            throw new IOException("Required data missing from message");
        }
    }

    byte[] readBytes(int num) throws IOException {
        byte[] byts = new byte[num];
        this.readArray(byts, 0);
        return byts;
    }

    public int getSubstitutionChar() {
        return this.substitutionChar;
    }

    public void countGroup() {
        ++this.groupCount;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public int getElementNumber() {
        return this.elementNumber;
    }

    public EdiConstants.ItemType currentType() {
        return this.currentType;
    }

    public String token() {
        return this.tokenBuilder.toString();
    }

    public StringBuilder tokenBuilder() {
        return this.tokenBuilder;
    }
}

