/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.x12;

import >org.mule.modules.edi.base.1.2.2.lib.BaseEdiModule;
import com.mulesoft.api.b2b.B2BProvider;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.ConfigType;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.factory.Factory;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import com.mulesoft.flatfile.1.2.3.lib.lexical.X12Constants;
import com.mulesoft.flatfile.1.2.3.lib.schema.EdiSchema;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12Acknowledgment;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12HandlerInterchangeError;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12ParserConfig;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12SchemaDefs;
import com.mulesoft.flatfile.1.2.3.lib.schema.YamlReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Map;
import org.mule.modules.edi.x12.DirectEnvelopeHandler;
import org.mule.modules.edi.x12.X12EdiModule;

class B2BProviderEnvelopeHandler
extends DirectEnvelopeHandler {
    private B2BProvider b2bProvider;
    private Factory<QueryObject> queryObjectFactory;
    private String interchangeControlVersionNo;
    private String groupIdSelf;
    private String interchangeIdSelf;
    private String interchangeIdQualifierSelf;
    private String groupIdPartner;
    private String interchangeIdPartner;
    private String interchangeIdQualifierPartner;
    private Config interchangeEnvelopeB2BProviderConfig;

    public B2BProviderEnvelopeHandler(B2BProvider b2bProvider, X12EdiModule x12EdiModule) throws Exception {
        super(x12EdiModule);
        this.b2bProvider = b2bProvider;
        this.queryObjectFactory = this.b2bProvider.getFactoryResolver().getFactory(QueryObject.class);
    }

    @Override
    public Object handleIsa(Map<String, Object> map) {
        this.groupIdSelf = this.x12EdiModule.getGroupIdSelf();
        this.interchangeIdSelf = this.x12EdiModule.getInterchangeIdSelf() != null ? this.x12EdiModule.getInterchangeIdSelf() : B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interReceiverInfoKey(), map);
        this.interchangeIdQualifierSelf = this.x12EdiModule.getInterchangeIdQualifierSelf() != null ? this.x12EdiModule.getInterchangeIdQualifierSelf() : B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interReceiverQualKey(), map);
        this.groupIdPartner = this.x12EdiModule.getGroupIdPartner();
        this.interchangeIdPartner = this.x12EdiModule.getInterchangeIdPartner() != null ? this.x12EdiModule.getInterchangeIdPartner() : B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interSenderInfoKey(), map);
        this.interchangeIdQualifierPartner = this.x12EdiModule.getInterchangeIdQualifierPartner() != null ? this.x12EdiModule.getInterchangeIdQualifierPartner() : B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interSenderQualKey(), map);
        X12HandlerInterchangeError error = this.checkIds(this.interchangeIdQualifierPartner, this.interchangeIdPartner, this.interchangeIdQualifierSelf, this.interchangeIdSelf, map);
        if (error != null) {
            return error;
        }
        QueryObject configQueryObject = (QueryObject)this.queryObjectFactory.create();
        configQueryObject.put((Object)"toPartyIdentifier", (Object)this.interchangeIdSelf);
        configQueryObject.put((Object)"fromPartyIdentifier", (Object)this.interchangeIdPartner);
        this.interchangeControlVersionNo = B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interControlVersionKey(), map);
        configQueryObject.put((Object)"version", (Object)this.interchangeControlVersionNo);
        try {
            this.interchangeEnvelopeB2BProviderConfig = this.b2bProvider.getConfig(ConfigType.X12, Direction.INBOUND, configQueryObject);
        }
        catch (B2BProviderException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.interchangeEnvelopeB2BProviderConfig != null) {
            if (Boolean.valueOf(((Serializable)this.interchangeEnvelopeB2BProviderConfig.get((Object)"requireUniqueInterchangeNumbers")).toString()).booleanValue()) {
                int controlNum = B2BProviderEnvelopeHandler.requiredInt(X12SchemaDefs.interControlNumberHeaderKey(), map);
                QueryObject transmissionQueryObject = (QueryObject)this.queryObjectFactory.create();
                transmissionQueryObject.put((Object)"gs02", (Object)this.groupIdPartner);
                transmissionQueryObject.put((Object)"isa06", (Object)this.interchangeIdPartner);
                transmissionQueryObject.put((Object)"isa05", (Object)this.interchangeIdQualifierPartner);
                transmissionQueryObject.put((Object)"gs03", (Object)this.groupIdSelf);
                transmissionQueryObject.put((Object)"isa08", (Object)this.interchangeIdSelf);
                transmissionQueryObject.put((Object)"isa07", (Object)this.interchangeIdQualifierSelf);
                transmissionQueryObject.put((Object)"isa13", (Object)String.valueOf(controlNum));
                try {
                    if (this.b2bProvider.readTransmission(Direction.INBOUND, TransmissionType.X12, transmissionQueryObject) != null) {
                        return new X12HandlerInterchangeError(X12Acknowledgment.InterchangeDuplicateNumber(), "Duplicate interchange control number " + controlNum);
                    }
                }
                catch (B2BProviderException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.requireUniqueTransactionNumbers = Boolean.valueOf(((Serializable)this.interchangeEnvelopeB2BProviderConfig.get((Object)"requireUniqueTransactionNumbers")).toString());
            if (!Boolean.valueOf(((Serializable)this.interchangeEnvelopeB2BProviderConfig.get((Object)"requireUniqueGroupNumbers")).toString()).booleanValue()) {
                this.groupCache = new HashSet();
            }
            return this.createX12ParserConfig(this.interchangeEnvelopeB2BProviderConfig);
        }
        throw new RuntimeException("Queried registered B2B Provider for X12 read config but none was found. Check your configuration. Lookup key used was: " + configQueryObject.toString());
    }

    @Override
    public Object handleGs(Map<String, Object> map) {
        this.requireUniqueTransactionNumbers = Boolean.valueOf(((Serializable)this.interchangeEnvelopeB2BProviderConfig.get((Object)"requireUniqueTransactionNumbers")).toString());
        Object x12Ack = this.doHandleGs(Boolean.valueOf(((Serializable)this.interchangeEnvelopeB2BProviderConfig.get((Object)"requireUniqueGroupNumbers")).toString()), map);
        if (x12Ack != null) {
            return x12Ack;
        }
        return this.createX12ParserConfig(this.interchangeEnvelopeB2BProviderConfig);
    }

    @Override
    protected EdiSchema.Structure getStructureSchema(String versionCode, String setId) {
        Config transactionSetB2BProviderConfig;
        QueryObject configQueryObject = (QueryObject)this.queryObjectFactory.create();
        configQueryObject.put((Object)"toPartyIdentifier", (Object)this.interchangeIdSelf);
        configQueryObject.put((Object)"fromPartyIdentifier", (Object)this.interchangeIdPartner);
        configQueryObject.put((Object)"version", (Object)this.interchangeControlVersionNo);
        configQueryObject.put((Object)"messageType", (Object)setId);
        try {
            transactionSetB2BProviderConfig = this.b2bProvider.getConfig(ConfigType.X12, Direction.INBOUND, configQueryObject);
        }
        catch (B2BProviderException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (transactionSetB2BProviderConfig.get((Object)"schema") != null) {
            YamlReader yamlrdr = new YamlReader();
            EdiSchema schema = yamlrdr.loadYaml(new StringReader(((Serializable)transactionSetB2BProviderConfig.get((Object)"schema")).toString()), BaseEdiModule.CURRENT_DIR_LIST);
            return (EdiSchema.Structure)schema.structures().apply((Object)setId);
        }
        return super.getStructureSchema(versionCode, setId);
    }

    private X12ParserConfig createX12ParserConfig(Config b2bProviderConfig) {
        return new X12ParserConfig(Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"valueLengthErrorFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"invalidCharacterInValueFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"wrongValuesRepeatsFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"unknownsSegmentFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"segmentOutOfOrderFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"unusedSegmentPresentFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"wrongSegmentsRepeatsFail")).toString()), this.x12EdiModule.getReportSegmentErrors(), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"generate999Acks")).toString()), -1, Enum.valueOf(X12Constants.CharacterRestriction.class, ((Serializable)b2bProviderConfig.get((Object)"stringCharacterSet")).toString()));
    }
}

