/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.x12;

import >org.mule.modules.edi.base.1.2.2.lib.BaseEnvelopeHandler;
import com.mulesoft.flatfile.1.2.3.lib.schema.EdiSchema;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12Acknowledgment;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12EnvelopeHandler;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12HandlerGroupError;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12HandlerInterchangeError;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12HandlerTransactionError;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12ParserConfig;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12SchemaDefs;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.modules.edi.x12.X12EdiModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirectEnvelopeHandler
extends BaseEnvelopeHandler
implements X12EnvelopeHandler {
    protected static final Logger logger = LoggerFactory.getLogger(DirectEnvelopeHandler.class);
    protected X12EdiModule x12EdiModule;
    protected Set<String> groupCache;
    protected Set<String> setCache;
    protected String contextToken;
    protected String senderCode;
    protected String receiverCode;
    protected String versionCode;
    protected String functionalCode;
    protected boolean requireUniqueTransactionNumbers;

    public DirectEnvelopeHandler(X12EdiModule x12EdiModule) throws Exception {
        this.x12EdiModule = x12EdiModule;
        this.requireUniqueTransactionNumbers = x12EdiModule.isRequireUniqueTransactionNumbers();
    }

    protected X12HandlerInterchangeError checkIds(String sendQual, String sendId, String rcvrQual, String rcvrId, Map<String, Object> map) {
        if (!DirectEnvelopeHandler.verifySetting(sendQual, X12SchemaDefs.interSenderQualKey(), map)) {
            return new X12HandlerInterchangeError(X12Acknowledgment.InterchangeSenderIdQual(), "Interchange sender qualifier does not match configuration");
        }
        if (!DirectEnvelopeHandler.verifySetting(sendId, X12SchemaDefs.interSenderInfoKey(), map)) {
            return new X12HandlerInterchangeError(X12Acknowledgment.InterchangeSenderId(), "Interchange sender id does not match configuration");
        }
        if (!DirectEnvelopeHandler.verifySetting(rcvrQual, X12SchemaDefs.interReceiverQualKey(), map)) {
            return new X12HandlerInterchangeError(X12Acknowledgment.InterchangeReceiverIdQual(), "Interchange receiver qualifier does not match configuration");
        }
        if (!DirectEnvelopeHandler.verifySetting(rcvrId, X12SchemaDefs.interReceiverInfoKey(), map)) {
            return new X12HandlerInterchangeError(X12Acknowledgment.InterchangeReceiverId(), "Interchange receiver id does not match configuration");
        }
        return null;
    }

    @Override
    public Object handleIsa(Map<String, Object> map) {
        this.contextToken = DirectEnvelopeHandler.requiredString(X12SchemaDefs.interSenderQualKey(), map) + DirectEnvelopeHandler.requiredString(X12SchemaDefs.interSenderInfoKey(), map) + DirectEnvelopeHandler.requiredString(X12SchemaDefs.interReceiverQualKey(), map) + DirectEnvelopeHandler.requiredString(X12SchemaDefs.interReceiverInfoKey(), map);
        X12HandlerInterchangeError error = this.checkIds(this.x12EdiModule.getInterchangeIdQualifierPartner(), this.x12EdiModule.getInterchangeIdPartner(), this.x12EdiModule.getInterchangeIdQualifierSelf(), this.x12EdiModule.getInterchangeIdSelf(), map);
        if (error != null) {
            return error;
        }
        int controlNum = DirectEnvelopeHandler.requiredInt(X12SchemaDefs.interControlNumberHeaderKey(), map);
        if (this.x12EdiModule.isRequireUniqueInterchangeNumbers() && !this.x12EdiModule.cacheIdentifier(this.contextToken + controlNum)) {
            return new X12HandlerInterchangeError(X12Acknowledgment.InterchangeDuplicateNumber(), "Duplicate interchange control number " + controlNum);
        }
        if (!this.x12EdiModule.isRequireUniqueGroupNumbers()) {
            this.groupCache = new HashSet<String>();
        }
        return new X12ParserConfig(this.x12EdiModule.getValueLengthErrorFail(), this.x12EdiModule.getInvalidCharacterInValueFail(), this.x12EdiModule.getWrongValuesRepeatsFail(), this.x12EdiModule.getUnknownsSegmentFail(), this.x12EdiModule.getSegmentOutOfOrderFail(), this.x12EdiModule.getUnusedSegmentPresentFail(), this.x12EdiModule.getWrongSegmentsRepeatsFail(), this.x12EdiModule.getReportSegmentErrors(), this.x12EdiModule.isGenerate999Acks(), -1, this.x12EdiModule.getStringCharacterSet().characterRestriction);
    }

    @Override
    public Object handleGs(Map<String, Object> map) {
        return this.doHandleGs(this.x12EdiModule.isRequireUniqueGroupNumbers(), map);
    }

    protected Object doHandleGs(boolean requireUniqueGroupNumbers, Map<String, Object> map) {
        if (!DirectEnvelopeHandler.verifySetting(this.x12EdiModule.getGroupIdPartner(), X12SchemaDefs.groupApplicationSenderKey(), map) || !DirectEnvelopeHandler.verifySetting(this.x12EdiModule.getGroupIdSelf(), X12SchemaDefs.groupApplicationReceiverKey(), map)) {
            return new X12HandlerGroupError(X12Acknowledgment.NotSupportedGroup(), "Group application sender/receiver information does not match configuration");
        }
        int controlNum = DirectEnvelopeHandler.requiredInt(X12SchemaDefs.groupControlNumberHeaderKey(), map);
        this.senderCode = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupApplicationSenderKey(), map);
        this.receiverCode = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupApplicationReceiverKey(), map);
        String ident = this.contextToken + this.senderCode + this.receiverCode + ":" + controlNum;
        if (requireUniqueGroupNumbers ? !this.x12EdiModule.cacheIdentifier(ident) : !this.groupCache.add(ident)) {
            return new X12HandlerGroupError(X12Acknowledgment.GroupControlNumberError(), "Duplicate group control number " + controlNum);
        }
        String agency = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupResponsibleAgencyKey(), map);
        if (!"X".equals(agency)) {
            return new X12HandlerGroupError(X12Acknowledgment.NotSupportedGroupVersion(), "Group responsible agency code must be 'X' (found " + agency + ")");
        }
        String code = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupVersionReleaseIndustryKey(), map);
        if (code.length() < 6) {
            return new X12HandlerGroupError(X12Acknowledgment.NotSupportedGroupVersion(), "Group version / release / industry identifier code less than 6 characters: '" + code + "'");
        }
        this.versionCode = code.substring(0, 6);
        this.functionalCode = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupFunctionalIdentifierKey(), map);
        if (!this.requireUniqueTransactionNumbers) {
            this.setCache = new HashSet<String>();
        }
        return null;
    }

    protected EdiSchema.Structure getStructureSchema(String versionCode, String setId) {
        return this.x12EdiModule.getStructureSchema(versionCode, setId);
    }

    @Override
    public Object handleSt(Map<String, Object> map) {
        EdiSchema.Structure structure;
        String controlNum = DirectEnvelopeHandler.requiredString(X12SchemaDefs.setControlNumberHeaderKey(), map);
        String ident = this.contextToken + this.senderCode + this.receiverCode + "$" + controlNum;
        if (this.requireUniqueTransactionNumbers ? !this.x12EdiModule.cacheIdentifier(ident) : !this.setCache.add(ident)) {
            return new X12HandlerTransactionError(X12Acknowledgment.BadTransactionSetControl(), "Duplicate group control number " + controlNum);
        }
        String setId = DirectEnvelopeHandler.requiredString(X12SchemaDefs.setIdentifierCodeKey(), map);
        try {
            structure = this.getStructureSchema(this.versionCode, setId);
        }
        catch (Exception e) {
            return new X12HandlerTransactionError(X12Acknowledgment.NotSupportedTransaction(), "Transaction not defined in schema");
        }
        if (!this.functionalCode.equals(structure.group().get())) {
            return new X12HandlerTransactionError(X12Acknowledgment.SetNotInGroup(), "Functional code " + this.functionalCode + " doesn't match schema");
        }
        return structure;
    }
}

