/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.x12;

import >org.mule.modules.edi.base.1.2.2.lib.BaseEdiModule;
import >org.mule.modules.edi.base.1.2.2.lib.TapOutputStream;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.ConfigType;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import com.mulesoft.flatfile.1.2.3.lib.lexical.X12Constants;
import com.mulesoft.flatfile.1.2.3.lib.schema.EdiSchema;
import com.mulesoft.flatfile.1.2.3.lib.schema.EdiSchemaVersion;
import com.mulesoft.flatfile.1.2.3.lib.schema.SchemaJavaValues;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12Acknowledgment;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12InterchangeParser;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12NumberProvider;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12SchemaDefs;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12SchemaWriter;
import com.mulesoft.flatfile.1.2.3.lib.schema.X12WriterConfig;
import com.mulesoft.flatfile.1.2.3.lib.schema.YamlReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.mule.api.MuleEvent;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.transport.OutputHandler;
import org.mule.modules.edi.x12.B2BProviderEnvelopeHandler;
import org.mule.modules.edi.x12.DirectEnvelopeHandler;
import org.mule.modules.edi.x12.ParserUtils;
import org.mule.modules.edi.x12.X12Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.util.Try;

public class X12EdiModule
extends BaseEdiModule {
    private static final Logger logger = LoggerFactory.getLogger(X12EdiModule.class);
    private X12Config x12Config;
    private List<String> schemas;
    private Boolean useB2BProvider = false;
    private String interchangeIdQualifierSelf;
    private String interchangeIdSelf;
    private String groupIdSelf;
    private String interchangeIdQualifierPartner;
    private String interchangeIdPartner;
    private String groupIdPartner;
    private X12CharacterEncoding characterEncoding;
    private X12CharacterRestriction stringCharacterSet;
    private Character stringSubstitutionChar;
    private String versionIdentifierSuffix;
    private boolean valueLengthErrorFail;
    private boolean invalidCharacterInValueFail;
    private boolean wrongValuesRepeatsFail;
    private boolean unknownsSegmentFail;
    private boolean segmentOutOfOrderFail;
    private boolean unusedSegmentPresentFail;
    private boolean wrongSegmentsRepeatsFail;
    private boolean reportSegmentErrors;
    private boolean requireUniqueInterchangeNumbers;
    private boolean requireUniqueGroupNumbers;
    private boolean requireUniqueTransactionNumbers;
    private boolean generate999Acks;
    private boolean includeFASchema;
    private String dataSeparator;
    private String componentSeparator;
    private String repetitionSeparator;
    private String segmentTerminator;
    private SegmentWhitespace lineEnding;
    private boolean sendUniqueGroupNumbers;
    private boolean sendUniqueTransactionNumbers;
    private String implementationConventionReference;
    private int initialInterchangeNumber;
    private int initialGroupNumber;
    private int initialSetNumber;
    private boolean ackRequested;
    private Character defaultUsageIndicator;
    @Inject
    private MuleRegistry registry;

    public void setRegistry(MuleRegistry registry) {
        this.registry = registry;
    }

    @Override
    protected MuleRegistry getRegistry() {
        return this.registry;
    }

    public void onStart() throws Exception {
        EdiSchemaVersion dfltVersion = new EdiSchemaVersion(EdiSchema.convertEdiForm("X12"), "005010");
        if (this.includeFASchema) {
            List<EdiSchema.Structure> list = Collections.singletonList(this.generate999Acks ? X12Acknowledgment.trans999() : X12Acknowledgment.trans997());
            this.loadSchemas(list, dfltVersion);
        } else {
            this.loadSchemas(null, dfltVersion);
        }
        if (!this.useB2BProvider.booleanValue()) {
            this.x12Config = this.createLocalX12Config();
        }
        this.doStart();
    }

    @Inject
    @MetaDataStaticKey(type="InMessage")
    public Map<String, Object> read(InputStream ediContent, MuleEvent event) throws Exception {
        Map<String, Object> parsedX12;
        if (ediContent == null) {
            throw new RuntimeException("Couldn't get the file");
        }
        if (this.useB2BProvider.booleanValue()) {
            this.loadB2BProvider();
            byte[] payload = event.getMessage().getPayloadAsBytes();
            X12InterchangeParser parser = new X12InterchangeParser(new ByteArrayInputStream(payload), this.characterEncoding.characterSet, new B2BProviderEnvelopeHandler(this.b2bProvider, this));
            parsedX12 = this.parse(parser);
            TransmissionSession transmissionSession = this.transmissionSupport.trackInboundTransmission(event, payload, parsedX12, TransmissionType.X12);
            event.setFlowVariable("b2bTransmissionSession", (Object)transmissionSession);
        } else {
            X12InterchangeParser parser = new X12InterchangeParser(ediContent, this.characterEncoding.characterSet, new DirectEnvelopeHandler(this));
            parsedX12 = this.parse(parser);
        }
        return parsedX12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Inject
    public OutputHandler write(final @MetaDataStaticKey(type="OutMessage") Map<String, Object> map, String interIdQualSelf, String interIdSelf, String grpIdSelf, String interIdQualPartner, String interIdPartner, String grpIdPartner, MuleEvent event) throws Exception {
        String delims;
        X12Config writeX12Config;
        String selectedGrpIdPartner;
        HashMap<String, Object> imap;
        HashMap<String, Object> gmap = (HashMap<String, Object>)map.get(SchemaJavaValues.groupKey());
        if (gmap == null) {
            gmap = new HashMap<String, Object>();
            map.put(SchemaJavaValues.groupKey(), gmap);
        }
        if ((imap = (HashMap<String, Object>)map.get(SchemaJavaValues.interchangeKey())) == null) {
            imap = new HashMap<String, Object>();
            map.put(SchemaJavaValues.interchangeKey(), imap);
        }
        String selectedInterIdQualSelf = imap.get(X12SchemaDefs.interSenderQualKey()) == null ? this.nonnull((Serializable)((Object)interIdQualSelf), this.interchangeIdQualifierSelf) : (String)imap.get(X12SchemaDefs.interSenderQualKey());
        final String selectedInterIdSelf = imap.get(X12SchemaDefs.interSenderInfoKey()) == null ? this.nonnull((Serializable)((Object)interIdSelf), this.interchangeIdSelf) : (String)imap.get(X12SchemaDefs.interSenderInfoKey());
        String selectedGrpIdSelf = gmap.get(X12SchemaDefs.groupApplicationSenderKey()) == null ? this.nonnull((Serializable)((Object)grpIdSelf), this.groupIdSelf) : (String)gmap.get(X12SchemaDefs.groupApplicationSenderKey());
        String selectedInterIdQualPartner = imap.get(X12SchemaDefs.interReceiverQualKey()) == null ? this.nonnull((Serializable)((Object)interIdQualPartner), this.interchangeIdQualifierPartner) : (String)imap.get(X12SchemaDefs.interReceiverQualKey());
        final String selectedInterIdPartner = imap.get(X12SchemaDefs.interReceiverInfoKey()) == null ? this.nonnull((Serializable)((Object)interIdPartner), this.interchangeIdPartner) : (String)imap.get(X12SchemaDefs.interReceiverInfoKey());
        String string = selectedGrpIdPartner = gmap.get(X12SchemaDefs.groupApplicationReceiverKey()) == null ? this.nonnull((Serializable)((Object)grpIdPartner), this.groupIdPartner) : (String)gmap.get(X12SchemaDefs.groupApplicationReceiverKey());
        if (this.useB2BProvider.booleanValue()) {
            this.loadB2BProvider();
            QueryObject queryObject = (QueryObject)this.queryObjectFactory.create();
            queryObject.put((Object)"fromPartyIdentifier", (Object)selectedInterIdSelf);
            queryObject.put((Object)"toPartyIdentifier", (Object)selectedInterIdPartner);
            queryObject.put((Object)"version", (Object)this.getCombinedSchema().ediVersion().version().substring(0, 5));
            Config writeB2BProviderConfig = this.b2bProvider.getConfig(ConfigType.X12, Direction.OUTBOUND, queryObject);
            if (writeB2BProviderConfig == null) throw new Exception("Queried registered B2B Provider for X12 write config but none was found. Check your configuration. Lookup key used was: " + queryObject.toString());
            writeX12Config = this.mapB2BProviderWriteConfigToX12Config(writeB2BProviderConfig);
        } else {
            writeX12Config = this.x12Config;
        }
        if ((delims = (String)map.get(SchemaJavaValues.delimiterCharacters())) == null) {
            delims = new String(new char[]{writeX12Config.getDataSeparator().charValue(), writeX12Config.getComponentSeparator().charValue(), writeX12Config.getRepetitionSeparator().charValue(), writeX12Config.getSegmentTerminator().charValue()});
        } else if (delims.length() != 4) {
            throw new IllegalArgumentException(SchemaJavaValues.delimiterCharacters() + " value must be 4 characters: '" + delims + "'");
        }
        HashSet<Character> chars = new HashSet<Character>();
        for (int i = 0; i < 4; ++i) {
            char delim = delims.charAt(i);
            if ((Character.isAlphabetic(delim) || Character.isDigit(delim)) && (i != 2 || delim != 'U')) {
                throw new IllegalArgumentException("Invalid delimiter character: '" + delim + "'");
            }
            if (chars.add(Character.valueOf(delim))) continue;
            throw new IllegalArgumentException("Duplicate delimiter character: '" + delim + "'");
        }
        final String useDelims = delims;
        if (!imap.containsKey(X12SchemaDefs.interAckRequestedKey())) {
            imap.put(X12SchemaDefs.interAckRequestedKey(), writeX12Config.isAckRequested() ? "1" : "0");
        }
        if (!imap.containsKey(X12SchemaDefs.interControlVersionKey())) {
            imap.put(X12SchemaDefs.interControlVersionKey(), this.getCombinedSchema().ediVersion().version().substring(0, 5));
        }
        if (!imap.containsKey(X12SchemaDefs.interUsageIndicatorKey())) {
            imap.put(X12SchemaDefs.interUsageIndicatorKey(), new String(new char[]{writeX12Config.getDefaultUsageIndicator().charValue()}));
        }
        this.setNullDefault(X12SchemaDefs.interSenderQualKey(), selectedInterIdQualSelf, imap);
        this.setNullDefault(X12SchemaDefs.interSenderInfoKey(), selectedInterIdSelf, imap);
        this.setNullDefault(X12SchemaDefs.interReceiverQualKey(), selectedInterIdQualPartner, imap);
        this.setNullDefault(X12SchemaDefs.interReceiverInfoKey(), selectedInterIdPartner, imap);
        this.setNullDefault(X12SchemaDefs.groupApplicationSenderKey(), selectedGrpIdSelf, gmap);
        this.setNullDefault(X12SchemaDefs.groupApplicationReceiverKey(), selectedGrpIdPartner, gmap);
        this.setNullDefault(X12SchemaDefs.groupResponsibleAgencyKey(), "X", gmap);
        String versionId = this.getCombinedSchema().ediVersion().version() + (writeX12Config.getVersionIdentifierSuffix() == null ? "" : writeX12Config.getVersionIdentifierSuffix());
        this.setNullDefault(X12SchemaDefs.groupVersionReleaseIndustryKey(), versionId, gmap);
        if (this.isEmpty(writeX12Config.getImplementationConventionReference())) return new OutputHandler(){

            public void write(MuleEvent onWriteEvent, OutputStream output) throws IOException {
                ByteArrayOutputStream tapStream = new ByteArrayOutputStream();
                int subChar = writeX12Config.getStringSubstitutionChar() == null ? -1 : (int)writeX12Config.getStringSubstitutionChar().charValue();
                X12WriterConfig config = new X12WriterConfig(true, writeX12Config.getStringCharacterSet().characterRestriction, subChar, writeX12Config.getCharacterEncoding().characterSet, useDelims, writeX12Config.getLineEnding().whitespace);
                Map verMap = (Map)BaseEdiModule.getOrDefault(map, X12SchemaDefs.transactionsMap(), Collections.EMPTY_MAP);
                for (String vkey : verMap.keySet()) {
                    Map transMap = (Map)BaseEdiModule.getOrDefault(verMap, vkey, Collections.EMPTY_MAP);
                    for (String tkey : transMap.keySet()) {
                        List sets = (List)BaseEdiModule.getOrDefault(transMap, tkey, Collections.EMPTY_LIST);
                        if (sets.isEmpty()) continue;
                        EdiSchema.Structure structure = null;
                        if (X12EdiModule.this.useB2BProvider.booleanValue()) {
                            QueryObject queryObject = (QueryObject)X12EdiModule.this.queryObjectFactory.create();
                            queryObject.put((Object)"fromPartyIdentifier", (Object)selectedInterIdSelf);
                            queryObject.put((Object)"toPartyIdentifier", (Object)selectedInterIdPartner);
                            queryObject.put((Object)"messageType", (Object)tkey);
                            if (((Map)sets.get(0)).get("Interchange") != null) {
                                queryObject.put((Object)"version", (Object)((String)((Map)((Map)sets.get(0)).get("Interchange")).get(X12SchemaDefs.interControlVersionKey())));
                            }
                            try {
                                Config transactionSetB2BProviderConfig = X12EdiModule.this.b2bProvider.getConfig(ConfigType.X12, Direction.OUTBOUND, queryObject);
                                if (transactionSetB2BProviderConfig.get((Object)"schema") != null) {
                                    YamlReader yamlrdr = new YamlReader();
                                    EdiSchema schema = yamlrdr.loadYaml(new StringReader(((Serializable)transactionSetB2BProviderConfig.get((Object)"schema")).toString()), BaseEdiModule.CURRENT_DIR_LIST);
                                    structure = (EdiSchema.Structure)schema.structures().apply((Object)tkey);
                                }
                            }
                            catch (B2BProviderException e) {
                                throw new IOException(e);
                            }
                        }
                        if (structure == null) {
                            structure = X12EdiModule.this.getStructureSchema(vkey.substring(1), tkey);
                        }
                        for (Map set : sets) {
                            set.put(SchemaJavaValues.structureSchema(), structure);
                        }
                    }
                }
                X12SchemaWriter writer = new X12SchemaWriter(X12EdiModule.this.useB2BProvider != false ? new TapOutputStream(output, tapStream) : output, new X12NumberProvider(){
                    int groupNum;
                    int setNum;

                    @Override
                    public String interchangIdentifier(String senderQual, String senderId, String receiverQual, String receiverId) {
                        return senderQual + senderId + receiverQual + receiverId;
                    }

                    @Override
                    public int nextInterchange(String interchange) {
                        this.groupNum = writeX12Config.getInitialGroupNumber();
                        int interchangeControlNumber = X12EdiModule.this.getNextInteger(interchange, writeX12Config.getInitialInterchangeNumber());
                        return interchangeControlNumber;
                    }

                    @Override
                    public int nextGroup(String interchange, String senderCode, String receiverCode) {
                        this.setNum = writeX12Config.getInitialSetNumber();
                        int functionalGroupControlNo = writeX12Config.isSendUniqueGroupNumbers() ? X12EdiModule.this.getNextInteger(interchange + "*" + senderCode + receiverCode, writeX12Config.getInitialGroupNumber()) : this.groupNum++;
                        return functionalGroupControlNo;
                    }

                    @Override
                    public String nextSet(String interchange, String senderCode, String receiverCode) {
                        if (writeX12Config.isSendUniqueTransactionNumbers()) {
                            return Integer.toString(X12EdiModule.this.getNextInteger(interchange + "+" + senderCode + receiverCode, writeX12Config.getInitialSetNumber()));
                        }
                        return Integer.toString(this.setNum++);
                    }
                }, config);
                writer.write(map).get();
                try {
                    if (X12EdiModule.this.useB2BProvider.booleanValue()) {
                        Transmission transmission = X12EdiModule.this.transmissionSupport.newTransmission();
                        transmission.put((Object)"edi", (Object)map);
                        String filename = (String)onWriteEvent.getMessage().getInboundProperty("originalFilename");
                        if (filename != null) {
                            transmission.put((Object)"filename", (Object)filename);
                        }
                        transmission.put((Object)"content", (Object)tapStream.toByteArray());
                        TransmissionSession transmissionSession = X12EdiModule.this.transmissionSupport.trackTransmission(X12EdiModule.this.b2bProvider, onWriteEvent, Direction.OUTBOUND, transmission, TransmissionType.X12);
                        onWriteEvent.setFlowVariable("b2bTransmissionSession", (Object)transmissionSession);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        HashMap<String, String> smap = (HashMap<String, String>)map.get(X12SchemaDefs.setKey());
        if (smap == null) {
            smap = new HashMap<String, String>();
            map.put(X12SchemaDefs.setKey(), smap);
        }
        smap.put(X12SchemaDefs.setImplementationConventionKey(), writeX12Config.getImplementationConventionReference());
        return new /* invalid duplicate definition of identical inner class */;
    }

    protected String validateStringProperty(String text, int maxl, X12Constants.CharacterRestriction chset, String name) {
        int length = text.length();
        if (length > maxl) {
            throw new IllegalArgumentException("Value '" + text + "' too long for " + name);
        }
        boolean[] allowedChars = chset.flags();
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr <= allowedChars.length && allowedChars[chr]) continue;
            throw new IllegalArgumentException("Character '" + chr + "' not allowed in string value " + name);
        }
        return text;
    }

    protected int validateNumberProperty(int number, String name) {
        if (number > 999999999) {
            throw new IllegalArgumentException("Value '" + number + "' too large for " + name);
        }
        if (number < 0) {
            throw new IllegalArgumentException("Value for " + name + " must be positive");
        }
        return number;
    }

    @Override
    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public String getInterchangeIdQualifierSelf() {
        return this.interchangeIdQualifierSelf;
    }

    public void setInterchangeIdQualifierSelf(String interchangeIdQualifierSelf) {
        this.interchangeIdQualifierSelf = this.validateIdProperty(interchangeIdQualifierSelf, 2, 2, "interchangeIdQualifierSelf");
    }

    public String getInterchangeIdSelf() {
        return this.interchangeIdSelf;
    }

    public void setInterchangeIdSelf(String interchangeIdSelf) {
        this.interchangeIdSelf = this.validateStringProperty(interchangeIdSelf, 15, X12Constants.CharacterRestriction.EXTENDED, "interchangeIdSelf");
    }

    public int getInitialInterchangeNumber() {
        return this.initialInterchangeNumber;
    }

    public void setInitialInterchangeNumber(int initialInterchangeNumber) {
        this.initialInterchangeNumber = this.validateNumberProperty(initialInterchangeNumber, "initialInterchangeNumber");
    }

    public String getGroupIdSelf() {
        return this.groupIdSelf;
    }

    public void setGroupIdSelf(String groupIdSelf) {
        this.groupIdSelf = this.validateStringProperty(groupIdSelf, 15, X12Constants.CharacterRestriction.EXTENDED, "groupIdSelf");
    }

    public String getInterchangeIdQualifierPartner() {
        return this.interchangeIdQualifierPartner;
    }

    public void setInterchangeIdQualifierPartner(String interchangeIdQualifierPartner) {
        this.interchangeIdQualifierPartner = this.validateIdProperty(interchangeIdQualifierPartner, 2, 2, "interchangeIdQualifierPartner");
    }

    public String getInterchangeIdPartner() {
        return this.interchangeIdPartner;
    }

    public void setInterchangeIdPartner(String interchangeIdPartner) {
        this.interchangeIdPartner = this.validateStringProperty(interchangeIdPartner, 15, X12Constants.CharacterRestriction.EXTENDED, "interchangeIdPartner");
    }

    public String getGroupIdPartner() {
        return this.groupIdPartner;
    }

    public void setGroupIdPartner(String groupIdPartner) {
        this.groupIdPartner = this.validateStringProperty(groupIdPartner, 15, X12Constants.CharacterRestriction.EXTENDED, "groupIdPartner");
    }

    public boolean getAckRequested() {
        return this.ackRequested;
    }

    public void setAckRequested(boolean ackRequested) {
        this.ackRequested = ackRequested;
    }

    public String getImplementationConventionReference() {
        return this.implementationConventionReference;
    }

    public void setImplementationConventionReference(String implementationConventionReference) {
        this.implementationConventionReference = this.validateStringProperty(implementationConventionReference, 35, X12Constants.CharacterRestriction.EXTENDED, "implementationConventionReference");
    }

    public boolean getValueLengthErrorFail() {
        return this.valueLengthErrorFail;
    }

    public void setValueLengthErrorFail(boolean valueLengthErrorFail) {
        this.valueLengthErrorFail = valueLengthErrorFail;
    }

    public X12CharacterRestriction getStringCharacterSet() {
        return this.stringCharacterSet;
    }

    public void setStringCharacterSet(X12CharacterRestriction stringCharacterSet) {
        this.stringCharacterSet = stringCharacterSet;
    }

    public Character getStringSubstitutionChar() {
        return this.stringSubstitutionChar;
    }

    public void setStringSubstitutionChar(Character stringSubstitutionChar) {
        this.stringSubstitutionChar = this.validateSeparator(stringSubstitutionChar, "stringSubstitutionChar");
    }

    public boolean getInvalidCharacterInValueFail() {
        return this.invalidCharacterInValueFail;
    }

    public void setInvalidCharacterInValueFail(boolean invalidCharacterInValueFail) {
        this.invalidCharacterInValueFail = invalidCharacterInValueFail;
    }

    public boolean getWrongValuesRepeatsFail() {
        return this.wrongValuesRepeatsFail;
    }

    public void setWrongValuesRepeatsFail(boolean wrongValuesRepeatsFail) {
        this.wrongValuesRepeatsFail = wrongValuesRepeatsFail;
    }

    public boolean getUnknownsSegmentFail() {
        return this.unknownsSegmentFail;
    }

    public void setUnknownsSegmentFail(boolean unknownsSegmentFail) {
        this.unknownsSegmentFail = unknownsSegmentFail;
    }

    public boolean getSegmentOutOfOrderFail() {
        return this.segmentOutOfOrderFail;
    }

    public void setSegmentOutOfOrderFail(boolean segmentOutOfOrderFail) {
        this.segmentOutOfOrderFail = segmentOutOfOrderFail;
    }

    public boolean getUnusedSegmentPresentFail() {
        return this.unusedSegmentPresentFail;
    }

    public void setUnusedSegmentPresentFail(boolean unusedSegmentPresentFail) {
        this.unusedSegmentPresentFail = unusedSegmentPresentFail;
    }

    public boolean getWrongSegmentsRepeatsFail() {
        return this.wrongSegmentsRepeatsFail;
    }

    public void setWrongSegmentsRepeatsFail(boolean wrongSegmentsRepeatsFail) {
        this.wrongSegmentsRepeatsFail = wrongSegmentsRepeatsFail;
    }

    public boolean getReportSegmentErrors() {
        return this.reportSegmentErrors;
    }

    public void setReportSegmentErrors(boolean reportSegmentErrors) {
        this.reportSegmentErrors = reportSegmentErrors;
    }

    public boolean isRequireUniqueInterchangeNumbers() {
        return this.requireUniqueInterchangeNumbers;
    }

    public void setRequireUniqueInterchangeNumbers(boolean requireUniqueInterchangeNumbers) {
        this.requireUniqueInterchangeNumbers = requireUniqueInterchangeNumbers;
    }

    public boolean isRequireUniqueGroupNumbers() {
        return this.requireUniqueGroupNumbers;
    }

    public void setRequireUniqueGroupNumbers(boolean requireUniqueGroupNumbers) {
        this.requireUniqueGroupNumbers = requireUniqueGroupNumbers;
    }

    public boolean isRequireUniqueTransactionNumbers() {
        return this.requireUniqueTransactionNumbers;
    }

    public void setRequireUniqueTransactionNumbers(boolean requireUniqueTransactionNumbers) {
        this.requireUniqueTransactionNumbers = requireUniqueTransactionNumbers;
    }

    public boolean isSendUniqueGroupNumbers() {
        return this.sendUniqueGroupNumbers;
    }

    public void setSendUniqueGroupNumbers(boolean sendUniqueGroupNumbers) {
        this.sendUniqueGroupNumbers = sendUniqueGroupNumbers;
    }

    public boolean isSendUniqueTransactionNumbers() {
        return this.sendUniqueTransactionNumbers;
    }

    public void setSendUniqueTransactionNumbers(boolean sendUniqueTransactionNumbers) {
        this.sendUniqueTransactionNumbers = sendUniqueTransactionNumbers;
    }

    public int getInitialGroupNumber() {
        return this.initialGroupNumber;
    }

    public void setInitialGroupNumber(int initialGroupNumber) {
        this.initialGroupNumber = this.validateNumberProperty(initialGroupNumber, "initialGroupNumber");
    }

    public int getInitialSetNumber() {
        return this.initialSetNumber;
    }

    public void setInitialSetNumber(int initialSetNumber) {
        this.initialSetNumber = this.validateNumberProperty(initialSetNumber, "initialSetNumber");
    }

    public Character getDefaultUsageIndicator() {
        return this.defaultUsageIndicator;
    }

    public void setDefaultUsageIndicator(Character defaultUsageIndicator) {
        if ("IPT".indexOf(defaultUsageIndicator.charValue()) < 0) {
            throw new IllegalArgumentException("Character '" + defaultUsageIndicator + "' is not a valid choice for defaultUsageIndicator");
        }
        this.defaultUsageIndicator = defaultUsageIndicator;
    }

    public boolean isGenerate999Acks() {
        return this.generate999Acks;
    }

    public void setGenerate999Acks(boolean generate999Acks) {
        this.generate999Acks = generate999Acks;
    }

    public boolean isIncludeFASchema() {
        return this.includeFASchema;
    }

    public void setIncludeFASchema(boolean includeFASchema) {
        this.includeFASchema = includeFASchema;
    }

    public X12CharacterEncoding getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(X12CharacterEncoding characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public Character getDataSeparator() {
        return ParserUtils.convertToProperty("dataSeparator property", this.dataSeparator);
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public Character getComponentSeparator() {
        return ParserUtils.convertToProperty("componentSeparator property", this.componentSeparator);
    }

    public void setComponentSeparator(String componentSeparator) {
        this.componentSeparator = componentSeparator;
    }

    public Character getRepetitionSeparator() {
        Character separator = ParserUtils.convertToProperty("repetitionSeparator property", this.repetitionSeparator);
        return separator.charValue() == 'U' ? separator : this.validateSeparator(separator, "repetitionSeparator");
    }

    public void setRepetitionSeparator(String repetitionSeparator) {
        this.repetitionSeparator = repetitionSeparator;
    }

    public Character getSegmentTerminator() {
        return ParserUtils.convertToProperty("segmentTerminator property", this.segmentTerminator);
    }

    public void setSegmentTerminator(String segmentTerminator) {
        this.segmentTerminator = segmentTerminator;
    }

    public SegmentWhitespace getLineEnding() {
        return this.lineEnding;
    }

    public void setLineEnding(SegmentWhitespace lineEnding) {
        this.lineEnding = lineEnding;
    }

    public String getVersionIdentifierSuffix() {
        return this.versionIdentifierSuffix;
    }

    public void setVersionIdentifierSuffix(String versionIdentifierSuffix) {
        this.versionIdentifierSuffix = this.validateStringProperty(versionIdentifierSuffix, 6, X12Constants.CharacterRestriction.EXTENDED, "versionIdentifierSuffix");
    }

    public Boolean getUseB2BProvider() {
        return this.useB2BProvider;
    }

    public void setUseB2BProvider(Boolean useB2BProvider) {
        this.useB2BProvider = useB2BProvider;
    }

    protected EdiSchema.Structure getStructureSchema(String version, String setId) {
        if (setId.equals("997")) {
            return X12Acknowledgment.trans997();
        }
        if (setId.equals("999")) {
            return X12Acknowledgment.trans999();
        }
        return this.getSchema("X12", version, setId);
    }

    private X12Config mapB2BProviderWriteConfigToX12Config(Config ediB2BProviderConfig) throws Exception {
        X12Config x12Config = new X12Config();
        x12Config.setCharacterEncoding(Enum.valueOf(X12CharacterEncoding.class, ((Serializable)ediB2BProviderConfig.get((Object)"characterEncoding")).toString()));
        x12Config.setStringCharacterSet(Enum.valueOf(X12CharacterRestriction.class, ((Serializable)ediB2BProviderConfig.get((Object)"stringCharacterSet")).toString()));
        if (ediB2BProviderConfig.get((Object)"stringSubstitutionChar") != null) {
            x12Config.setStringSubstitutionChar(new Character(((Serializable)ediB2BProviderConfig.get((Object)"stringSubstitutionChar")).toString().charAt(0)));
        }
        x12Config.setVersionIdentifierSuffix(this.validateStringProperty(((Serializable)ediB2BProviderConfig.get((Object)"versionIdentifierSuffix")).toString(), 6, X12Constants.CharacterRestriction.EXTENDED, "versionIdentifierSuffix"));
        x12Config.setSendUniqueGroupNumbers(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get((Object)"sendUniqueGroupNumbers")).toString()));
        x12Config.setSendUniqueTransactionNumbers(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get((Object)"sendUniqueTransactionNumbers")).toString()));
        x12Config.setDataSeparator(new Character(((Serializable)ediB2BProviderConfig.get((Object)"dataSeparator")).toString().charAt(0)));
        x12Config.setComponentSeparator(new Character(((Serializable)ediB2BProviderConfig.get((Object)"componentSeparator")).toString().charAt(0)));
        x12Config.setRepetitionSeparator(new Character(((Serializable)ediB2BProviderConfig.get((Object)"repetitionSeparator")).toString().charAt(0)));
        x12Config.setSegmentTerminator(new Character(((Serializable)ediB2BProviderConfig.get((Object)"segmentTerminator")).toString().charAt(0)));
        x12Config.setLineEnding(Enum.valueOf(SegmentWhitespace.class, ((Serializable)ediB2BProviderConfig.get((Object)"lineEnding")).toString()));
        x12Config.setSendUniqueGroupNumbers(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get((Object)"sendUniqueGroupNumbers")).toString()));
        x12Config.setSendUniqueTransactionNumbers(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get((Object)"sendUniqueTransactionNumbers")).toString()));
        x12Config.setImplementationConventionReference(this.validateStringProperty(((Serializable)ediB2BProviderConfig.get((Object)"implementationConventionReference")).toString(), 35, X12Constants.CharacterRestriction.EXTENDED, "implementationConventionReference"));
        x12Config.setInitialInterchangeNumber(Integer.parseInt(((Serializable)ediB2BProviderConfig.get((Object)"initialInterchangeNumber")).toString()));
        x12Config.setInitialGroupNumber(Integer.parseInt(((Serializable)ediB2BProviderConfig.get((Object)"initialGroupNumber")).toString()));
        x12Config.setInitialSetNumber(Integer.parseInt(((Serializable)ediB2BProviderConfig.get((Object)"initialSetNumber")).toString()));
        x12Config.setAckRequested(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get((Object)"ackRequested")).toString()));
        x12Config.setDefaultUsageIndicator(new Character(((Serializable)ediB2BProviderConfig.get((Object)"defaultUsageIndicator")).toString().charAt(0)));
        return x12Config;
    }

    private X12Config createLocalX12Config() throws Exception {
        X12Config x12Config = new X12Config();
        x12Config.setCharacterEncoding(this.characterEncoding);
        x12Config.setStringCharacterSet(this.stringCharacterSet);
        x12Config.setStringSubstitutionChar(this.stringSubstitutionChar);
        x12Config.setVersionIdentifierSuffix(this.versionIdentifierSuffix);
        x12Config.setValueLengthErrorFail(this.valueLengthErrorFail);
        x12Config.setInvalidCharacterInValueFail(this.invalidCharacterInValueFail);
        x12Config.setWrongValuesRepeatsFail(this.wrongValuesRepeatsFail);
        x12Config.setUnknownsSegmentFail(this.unknownsSegmentFail);
        x12Config.setSegmentOutOfOrderFail(this.segmentOutOfOrderFail);
        x12Config.setUnusedSegmentPresentFail(this.unusedSegmentPresentFail);
        x12Config.setWrongSegmentsRepeatsFail(this.wrongSegmentsRepeatsFail);
        x12Config.setReportSegmentErrors(this.reportSegmentErrors);
        x12Config.setRequireUniqueInterchangeNumbers(this.requireUniqueInterchangeNumbers);
        x12Config.setRequireUniqueGrouplNumbers(this.requireUniqueGroupNumbers);
        x12Config.setRequireUniqueTransactionNumbers(this.requireUniqueTransactionNumbers);
        x12Config.setGenerate999Acks(this.generate999Acks);
        x12Config.setIncludeFASchema(this.includeFASchema);
        x12Config.setDataSeparator(ParserUtils.convertToProperty("dataSeparator property", this.dataSeparator));
        x12Config.setComponentSeparator(ParserUtils.convertToProperty("componentSeparator property", this.componentSeparator));
        x12Config.setRepetitionSeparator(ParserUtils.convertToProperty("repetitionSeparator property", this.repetitionSeparator));
        x12Config.setSegmentTerminator(ParserUtils.convertToProperty("segmentTerminator property", this.segmentTerminator));
        x12Config.setLineEnding(this.lineEnding);
        x12Config.setSendUniqueGroupNumbers(this.sendUniqueGroupNumbers);
        x12Config.setSendUniqueTransactionNumbers(this.sendUniqueTransactionNumbers);
        x12Config.setImplementationConventionReference(this.implementationConventionReference);
        x12Config.setInitialInterchangeNumber(this.initialInterchangeNumber);
        x12Config.setInitialGroupNumber(this.initialGroupNumber);
        x12Config.setInitialSetNumber(this.initialSetNumber);
        x12Config.setAckRequested(this.ackRequested);
        x12Config.setDefaultUsageIndicator(this.defaultUsageIndicator);
        return x12Config;
    }

    private Map<String, Object> parse(X12InterchangeParser parser) {
        Try<Map<String, Object>> parse2 = parser.parse();
        return (Map)parse2.get();
    }

    public static enum SegmentWhitespace {
        NONE(""),
        LF("\n"),
        LFCR("\r\n"),
        CR("\r");

        public final String whitespace;

        private SegmentWhitespace(String ws) {
            this.whitespace = ws;
        }
    }

    public static enum X12CharacterRestriction {
        BASIC(X12Constants.CharacterRestriction.BASIC),
        EXTENDED(X12Constants.CharacterRestriction.EXTENDED),
        UNRESTRICTED(X12Constants.CharacterRestriction.UNRESTRICTED);

        public final X12Constants.CharacterRestriction characterRestriction;

        private X12CharacterRestriction(X12Constants.CharacterRestriction base) {
            this.characterRestriction = base;
        }
    }

    public static enum X12CharacterEncoding {
        ASCII("ASCII"),
        ISO8859_1("ISO-8859-1"),
        IBM1047("IBM1047"),
        UTF8("UTF-8");

        public final Charset characterSet;

        private X12CharacterEncoding(String name) {
            this.characterSet = Charset.forName(name);
        }
    }
}

