/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.client;

import com.modus.common.exception.AS2ServiceException;
import com.modus.common.message.Message;
import com.modus.common.message.MessageMDN;
import com.modus.common.service.AS2Service;
import com.modus.common.service.agreement.Agreement;
import com.modus.common.service.agreement.SecurityInfo;
import com.modus.mule.modules.as2.ConnectorContext;
import com.modus.mule.modules.as2.client.ClientConfig;
import com.modus.mule.modules.as2.client.ContentTransferEncodingEnum;
import com.modus.mule.modules.as2.client.DigestAlgorithmEnum;
import com.modus.mule.modules.as2.client.Receipt;
import com.modus.mule.modules.as2.client.SslV2HelloEnabledSslServerSocketFactory;
import com.modus.mule.modules.as2.client.strategy.B2BProviderClientStrategy;
import com.modus.mule.modules.as2.client.strategy.ClientStrategy;
import com.modus.mule.modules.as2.client.strategy.DefaultClientStrategy;
import com.modus.mule.modules.as2.common.AS2ConnectorException;
import com.modus.mule.modules.as2.common.DigestAlgorithmOptionEnum;
import com.modus.mule.modules.as2.common.LoggingUtils;
import com.modus.mule.modules.as2.common.RequestReceipt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Header;
import org.apache.http.shade.client.methods.HttpPost;
import org.apache.http.shade.entity.ByteArrayEntity;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.security.tls.TlsConfiguration;
import org.mule.api.transport.Connector;
import org.mule.api.transport.PropertyScope;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.transport.http.HttpsConnector;
import org.mule.transport.service.TransportFactory;
import org.mule.transport.tcp.SimpleServerSocketFactory;
import org.mule.util.IOUtils;
import org.mule.util.ObjectNameHelper;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientFacade
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ClientFacade.class);
    private OutboundEndpoint outboundEndpoint;
    private ClientConfig clientConfig;
    private AS2Service as2Service;
    private MuleContext muleContext;
    private Map<String, InboundEndpoint> receiptListenerCache;
    private ClientStrategy clientStrategy;

    public ClientFacade(OutboundEndpoint outboundEndpoint, MuleContext muleContext, ClientConfig clientConfig, ConnectorContext connectorContext, Map<String, InboundEndpoint> receiptListenerCache) {
        this.clientConfig = clientConfig;
        this.outboundEndpoint = outboundEndpoint;
        this.as2Service = connectorContext.getAs2Service();
        this.muleContext = muleContext;
        this.receiptListenerCache = receiptListenerCache;
        this.clientStrategy = connectorContext.getConnectorConfig().getUseB2BProvider() != false ? new B2BProviderClientStrategy(clientConfig, connectorContext, outboundEndpoint) : new DefaultClientStrategy(clientConfig, connectorContext, outboundEndpoint);
    }

    public MuleEvent send(MuleEvent muleEvent) throws AS2ConnectorException {
        String address = this.resolveDestinationAddress(muleEvent, this.outboundEndpoint, this.clientConfig);
        try {
            Agreement agreement = this.createAgreement(this.clientConfig, address);
            SecurityInfo info = new SecurityInfo(this.clientConfig.getKeyStorePath(), this.clientConfig.getKeyStorePassword(), this.clientConfig.getKeyStorePath(), this.clientConfig.getKeyStorePassword(), this.clientConfig.getSuppressCmsAlgorithmProtectionAttribute().booleanValue(), this.clientConfig.getReceiptVerificationCertificateKeyStoreEntryAlias());
            Message as2Request = this.as2Service.prepare(agreement, (InputStream)new ByteArrayInputStream(muleEvent.getMessage().getPayloadAsBytes()), info, this.clientConfig.getCompress().booleanValue(), this.clientConfig.getSign(), this.clientConfig.getEncrypt());
            this.clientStrategy.onSend(as2Request, muleEvent);
            DefaultMuleEvent requestMuleEvent = new DefaultMuleEvent(this.as2MessageToMuleMessage(as2Request), muleEvent);
            MuleEvent receiptMuleEvent = this.isAsyncReceiptRequest(this.clientConfig) ? this.sendAndReceiveAsyncReceipt(address, as2Request, (MuleEvent)requestMuleEvent) : this.sendAndReceiveReceipt(address, as2Request, (MuleEvent)requestMuleEvent);
            if (!this.clientConfig.getRequestReceipt().equals((Object)RequestReceipt.none)) {
                this.handleRequestedReceipt(info, as2Request, (MuleEvent)requestMuleEvent, receiptMuleEvent);
            }
            return receiptMuleEvent;
        }
        catch (Exception e) {
            throw new AS2ConnectorException(e);
        }
    }

    private void handleRequestedReceipt(SecurityInfo info, Message as2Request, MuleEvent requestMuleEvent, MuleEvent receiptMuleEvent) throws Exception, AS2ServiceException {
        Map receiptHttpHeaders = (Map)receiptMuleEvent.getMessage().getInboundProperty("http.headers", new HashMap());
        try {
            this.as2Service.verify(as2Request.getOriginalMIC(), receiptHttpHeaders, receiptMuleEvent.getMessage().getPayloadAsBytes(), info);
            this.clientStrategy.onSuccessfulReceipt(as2Request, receiptMuleEvent, requestMuleEvent);
        }
        catch (AS2ServiceException e) {
            this.clientStrategy.onReceiveReceiptError(as2Request, requestMuleEvent, (Exception)((Object)e), receiptMuleEvent);
            throw new AS2ServiceException((Throwable)e);
        }
    }

    private boolean isAsyncReceiptRequest(ClientConfig clientConfig) {
        return StringUtils.isNotBlank((String)clientConfig.getReceiptDeliveryOption());
    }

    private MuleMessage as2MessageToMuleMessage(Message mdnAs2Message) throws Exception {
        byte[] data = IOUtils.toByteArray((InputStream)mdnAs2Message.getData().getInputStream());
        DefaultMuleMessage mdnMuleMessage = new DefaultMuleMessage((Object)data, this.muleContext);
        Enumeration headers = mdnAs2Message.getHeaders().getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            mdnMuleMessage.setOutboundProperty(header.getName(), (Object)header.getValue());
        }
        mdnMuleMessage.setOutboundProperty("Content-Length", (Object)Integer.toString(data.length));
        return mdnMuleMessage;
    }

    private HttpPost as2MessageToHttpPost(String destination, Message mdnAs2Message) throws Exception {
        HttpPost httpPost = new HttpPost(destination);
        ByteArrayEntity httpEntity = new ByteArrayEntity(IOUtils.toByteArray((InputStream)mdnAs2Message.getData().getInputStream()));
        httpPost.setEntity(httpEntity);
        Enumeration headers = mdnAs2Message.getHeaders().getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            httpPost.setHeader(header.getName(), header.getValue());
        }
        return httpPost;
    }

    public AS2Service getAs2Service() {
        return this.as2Service;
    }

    public void setAs2Service(AS2Service as2Service) {
        this.as2Service = as2Service;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createReceiptListener(FlowConstruct flowConstruct, MuleContext muleContext) throws Exception {
        String endpointUri = this.buildEndpointUri(this.clientConfig.getReceiptDeliveryOption());
        Map<String, InboundEndpoint> map = this.receiptListenerCache;
        synchronized (map) {
            if (this.receiptListenerCache.get(endpointUri) == null) {
                InboundEndpoint inboundEndpoint = (InboundEndpoint)muleContext.getRegistry().lookupObject(ObjectNameHelper.getEndpointNameFor((EndpointURI)new MuleEndpointURI(endpointUri, muleContext)));
                if (inboundEndpoint == null) {
                    inboundEndpoint = this.buildInboundEndpoint(endpointUri, flowConstruct);
                }
                this.receiptListenerCache.put(endpointUri, inboundEndpoint);
            }
        }
    }

    private MuleEvent doSend(MuleEvent requestMuleEvent, OutboundEndpoint outboundEndpoint, String address) throws Exception {
        LoggingUtils.logOutgoingMessage(requestMuleEvent.getMessage(), "Sending AS2 request to " + address, logger);
        MuleEvent replyMuleEvent = outboundEndpoint.process(requestMuleEvent);
        LoggingUtils.logIncomingMessage(replyMuleEvent.getMessage(), "Received reply", logger);
        return replyMuleEvent;
    }

    private Agreement createAgreement(ClientConfig clientConfig, String toUrl) {
        Agreement agreement = new Agreement().from(clientConfig.getAs2From()).to(clientConfig.getAs2To()).subject(clientConfig.getSubject());
        if (clientConfig.getRequestReceipt().equals((Object)RequestReceipt.signed)) {
            agreement.setMDNToUrl(toUrl);
            agreement.setRequestReceipt(true);
            agreement.setRequestUnsignedReceipt(false);
            if (clientConfig.getRequireReceiptForUnsupportedSignatureFormat().booleanValue()) {
                agreement.setSignedReceiptProtocolRequired();
            } else {
                agreement.setSignedReceiptProtocolOptional();
            }
            if (clientConfig.getRequireReceiptForUnsupportedDigestAlgorithm().booleanValue()) {
                agreement.setSignedMicAlgorithmRequired();
            } else {
                agreement.setSignedMicAlgorithmOptional();
            }
            if (clientConfig.getDigestAlgorithm().equals((Object)DigestAlgorithmEnum.sha1)) {
                agreement.setMicAlgorithm("sha1");
            } else if (clientConfig.getDigestAlgorithm().equals((Object)DigestAlgorithmEnum.sha224)) {
                agreement.setMicAlgorithm("sha224");
            } else if (clientConfig.getDigestAlgorithm().equals((Object)DigestAlgorithmEnum.sha256)) {
                agreement.setMicAlgorithm("sha256");
            } else if (clientConfig.getDigestAlgorithm().equals((Object)DigestAlgorithmEnum.sha384)) {
                agreement.setMicAlgorithm("sha384");
            } else if (clientConfig.getDigestAlgorithm().equals((Object)DigestAlgorithmEnum.sha512)) {
                agreement.setMicAlgorithm("sha512");
            } else {
                agreement.setMicAlgorithm("md5");
            }
            if (clientConfig.getFallbackDigestAlgorithm().equals((Object)DigestAlgorithmOptionEnum.sha1)) {
                agreement.setFallbackMicAlgorithm("sha1");
            } else if (clientConfig.getFallbackDigestAlgorithm().equals((Object)DigestAlgorithmOptionEnum.sha224)) {
                agreement.setFallbackMicAlgorithm("sha224");
            } else if (clientConfig.getFallbackDigestAlgorithm().equals((Object)DigestAlgorithmOptionEnum.sha256)) {
                agreement.setFallbackMicAlgorithm("sha256");
            } else if (clientConfig.getFallbackDigestAlgorithm().equals((Object)DigestAlgorithmOptionEnum.sha384)) {
                agreement.setFallbackMicAlgorithm("sha384");
            } else if (clientConfig.getFallbackDigestAlgorithm().equals((Object)DigestAlgorithmOptionEnum.sha512)) {
                agreement.setFallbackMicAlgorithm("sha512");
            } else if (clientConfig.getFallbackDigestAlgorithm().equals((Object)DigestAlgorithmOptionEnum.md5)) {
                agreement.setFallbackMicAlgorithm("md5");
            }
        } else if (clientConfig.getRequestReceipt().equals((Object)RequestReceipt.unsigned)) {
            agreement.setMDNToUrl(toUrl);
            agreement.setRequestReceipt(true);
            agreement.setRequestUnsignedReceipt(true);
        } else {
            agreement.setRequestReceipt(false);
        }
        if (StringUtils.isNotBlank((String)clientConfig.getMessageId())) {
            agreement.setCustomMessageID(clientConfig.getMessageId());
        }
        if (clientConfig.getEncrypt().booleanValue()) {
            agreement.encrypted();
        }
        if (clientConfig.getSign().booleanValue()) {
            agreement.signed();
        }
        if (StringUtils.isNotBlank((String)clientConfig.getReceiptDeliveryOption())) {
            agreement.setAsyncMDNToUrl(clientConfig.getReceiptDeliveryOption());
        }
        if (StringUtils.isNotBlank((String)clientConfig.getFilename())) {
            agreement.setFilename(clientConfig.getFilename());
        }
        if (StringUtils.isNotBlank((String)clientConfig.getContentType())) {
            agreement.setContentType(clientConfig.getContentType());
        }
        if (clientConfig.getContentTransferEncoding().equals((Object)ContentTransferEncodingEnum._7bit)) {
            agreement.setContentTransferEncoding("7bit");
        } else if (clientConfig.getContentTransferEncoding().equals((Object)ContentTransferEncodingEnum._8bit)) {
            agreement.setContentTransferEncoding("8bit");
        } else if (clientConfig.getContentTransferEncoding().equals((Object)ContentTransferEncodingEnum.base64)) {
            agreement.setContentTransferEncoding("base64");
        } else if (clientConfig.getContentTransferEncoding().equals((Object)ContentTransferEncodingEnum.binary)) {
            agreement.setContentTransferEncoding("binary");
        } else if (clientConfig.getContentTransferEncoding().equals((Object)ContentTransferEncodingEnum.quoted_printable)) {
            agreement.setContentTransferEncoding("quoted-printable");
        }
        return agreement;
    }

    private String resolveDestinationAddress(MuleEvent muleEvent, OutboundEndpoint outboundEndpoint, ClientConfig clientConfig) {
        if (muleEvent.getMuleContext().getExpressionManager().isExpression(outboundEndpoint.getAddress())) {
            return muleEvent.getMuleContext().getExpressionManager().parse(outboundEndpoint.getAddress(), muleEvent).toString();
        }
        return outboundEndpoint.getAddress();
    }

    private MuleEvent sendAndReceiveAsyncReceipt(String address, Message as2Request, MuleEvent requestMuleEvent) throws Exception {
        this.createReceiptListener(requestMuleEvent.getFlowConstruct(), this.muleContext);
        this.doSend(requestMuleEvent, this.outboundEndpoint, address);
        Receipt receipt = this.clientStrategy.pollReceipt(as2Request, requestMuleEvent);
        HashMap<String, String> receiptAs2Headers = new HashMap<String, String>();
        if (receipt.getAs2From() != null) {
            receiptAs2Headers.put("AS2-From", receipt.getAs2From());
        }
        if (receipt.getMdnContentType() != null) {
            receiptAs2Headers.put("Content-Type", receipt.getMdnContentType());
        }
        DefaultMuleEvent receiptMuleEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)receipt.getMdnContent(), this.muleContext), requestMuleEvent);
        receiptMuleEvent.getMessage().setProperty("http.headers", receiptAs2Headers, PropertyScope.INBOUND);
        return receiptMuleEvent;
    }

    private MuleEvent sendAndReceiveReceipt(String address, Message as2Request, MuleEvent requestMuleEvent) throws Exception {
        MuleEvent receiptMuleEvent = null;
        try {
            receiptMuleEvent = this.doSend(requestMuleEvent, this.outboundEndpoint, address);
            return receiptMuleEvent;
        }
        catch (Exception e) {
            this.clientStrategy.onReceiveReceiptError(as2Request, requestMuleEvent, e, receiptMuleEvent);
            throw new Exception(e);
        }
    }

    private String buildEndpointUri(String url) throws Exception {
        URL receiptDeliveryOption = new URL(url);
        String port = String.valueOf(receiptDeliveryOption.getPort());
        String protocol = receiptDeliveryOption.getProtocol();
        if (port.equals("-1")) {
            port = "80";
        }
        return protocol + "://0.0.0.0:" + port + receiptDeliveryOption.getFile();
    }

    private InboundEndpoint buildInboundEndpoint(String endpointUri, FlowConstruct flowConstruct) throws Exception {
        EndpointBuilder endpointBuilder = this.muleContext.getEndpointFactory().getEndpointBuilder(endpointUri);
        TransportFactory factory = new TransportFactory(this.muleContext);
        Connector connector = factory.createConnector(endpointUri);
        if (endpointUri.startsWith("https")) {
            HttpsConnector httpsConnector = (HttpsConnector)connector;
            httpsConnector.setKeyStore(this.clientConfig.getKeyStorePath());
            httpsConnector.setKeyStorePassword(this.clientConfig.getKeyStorePassword());
            httpsConnector.setKeyPassword("");
            TlsConfiguration tlsConfiguration = new TlsConfiguration(null);
            tlsConfiguration.setKeyStore(this.clientConfig.getKeyStorePath());
            tlsConfiguration.setKeyStorePassword(this.clientConfig.getKeyStorePassword());
            tlsConfiguration.setKeyPassword("");
            if (StringUtils.isNotBlank((String)this.clientConfig.getReceiptVerificationCertificateKeyStoreEntryAlias())) {
                tlsConfiguration.setKeyAlias(this.clientConfig.getReceiptVerificationCertificateKeyStoreEntryAlias());
            }
            tlsConfiguration.initialise(null == httpsConnector.getKeyStore(), "javax.net");
            httpsConnector.setServerSocketFactory((SimpleServerSocketFactory)new SslV2HelloEnabledSslServerSocketFactory(tlsConfiguration));
        }
        this.muleContext.getRegistry().registerConnector(connector);
        endpointBuilder.setConnector(connector);
        final InboundEndpoint inboundEndpoint = this.muleContext.getEndpointFactory().getInboundEndpoint(endpointBuilder);
        this.muleContext.getRegistry().registerObject(inboundEndpoint.getName(), (Object)inboundEndpoint, ImmutableEndpoint.class);
        inboundEndpoint.setFlowConstruct(flowConstruct);
        inboundEndpoint.setListener(new MessageProcessor(){

            public MuleEvent process(MuleEvent receiptMuleEvent) throws MuleException {
                try {
                    LoggingUtils.logIncomingMessage(receiptMuleEvent.getMessage(), "Received async receipt", logger);
                    MessageMDN messageMDN = ClientFacade.this.as2Service.createMDN((Map)receiptMuleEvent.getMessage().getInboundProperty("http.headers", new HashMap()), receiptMuleEvent.getMessage().getPayloadAsBytes());
                    ClientFacade.this.clientStrategy.onReceiveAsyncReceipt(messageMDN, receiptMuleEvent, receiptMuleEvent);
                }
                catch (Exception e) {
                    throw new MessagingException(receiptMuleEvent, (Throwable)e);
                }
                return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"", ClientFacade.this.muleContext), receiptMuleEvent);
            }
        });
        this.muleContext.registerListener((ServerNotificationListener)new MuleContextNotificationListener(){

            public void onNotification(ServerNotification notification) {
                try {
                    if (notification.getAction() == 105) {
                        inboundEndpoint.stop();
                    }
                }
                catch (MuleException e) {
                    logger.error("An error occurred while stopping the connector", (Throwable)e);
                }
            }
        });
        inboundEndpoint.start();
        return inboundEndpoint;
    }

    @Override
    public void close() throws IOException {
        this.clientStrategy.onClose();
    }
}

