/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.client;

import com.modus.mule.modules.as2.ConnectorContext;
import com.modus.mule.modules.as2.client.ClientConfig;
import com.modus.mule.modules.as2.client.ClientFacade;
import com.modus.mule.modules.as2.client.ContentTransferEncodingEnum;
import com.modus.mule.modules.as2.client.DigestAlgorithmEnum;
import com.modus.mule.modules.as2.common.AS2ConnectorException;
import com.modus.mule.modules.as2.common.DigestAlgorithmOptionEnum;
import com.modus.mule.modules.as2.common.KeyStoreGenerator;
import com.modus.mule.modules.as2.common.Misc;
import com.modus.mule.modules.as2.common.RequestReceipt;
import com.modus.mule.modules.as2.config.PartnerManagerConnectorConfig;
import com.mulesoft.api.b2b.B2BProvider;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.ConfigType;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.factory.Factory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.config.i18n.MessageFactory;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientFacadeFactory {
    private static final Logger logger = LoggerFactory.getLogger(ClientFacadeFactory.class);
    private static final String SETTING_NOT_FOUND_ERROR_MESSAGE = "Could not send because of missing AS2 setting in config returned by registered B2B Provider";
    private final MuleContext muleContext;
    private final Map<String, InboundEndpoint> receiptListenerCache;
    private final String httpEndpointRef;
    private final ConnectorContext connectorContext;
    private final boolean useB2BProvider;
    private OutboundEndpoint outboundEndpoint;
    private Factory<QueryObject> queryObjectFactory;
    private PartnerManagerConnectorConfig partnerManagerConnectorConfig;

    public ClientFacadeFactory(ClientConfig localClientConfig, MuleContext muleContext, ConnectorContext connectorContext, String httpEndpointRef) throws AS2ConnectorException {
        this.httpEndpointRef = httpEndpointRef;
        this.useB2BProvider = connectorContext.getConnectorConfig().getUseB2BProvider();
        this.connectorContext = connectorContext;
        this.muleContext = muleContext;
        this.receiptListenerCache = new HashMap<String, InboundEndpoint>();
        if (this.useB2BProvider) {
            this.partnerManagerConnectorConfig = (PartnerManagerConnectorConfig)connectorContext.getConnectorConfig();
            try {
                this.queryObjectFactory = this.partnerManagerConnectorConfig.getB2BProvider().getFactoryResolver().getFactory(QueryObject.class);
            }
            catch (B2BProviderException e) {
                throw new AS2ConnectorException(e);
            }
        } else {
            this.outboundEndpoint = this.buildOutboundEndpoint(localClientConfig, httpEndpointRef);
        }
    }

    public ClientFacade createClient(ClientConfig localClientConfig) throws AS2ConnectorException {
        OutboundEndpoint currentOutboundEndpoint;
        ClientConfig clientConfig;
        if (this.useB2BProvider) {
            clientConfig = this.buildClientConfigFromB2BProvider(localClientConfig.getAs2From(), localClientConfig.getAs2To(), this.partnerManagerConnectorConfig.getB2BProvider());
            currentOutboundEndpoint = this.buildOutboundEndpoint(clientConfig, this.httpEndpointRef);
        } else {
            clientConfig = localClientConfig;
            currentOutboundEndpoint = this.outboundEndpoint;
        }
        if (StringUtils.isEmpty((String)clientConfig.getAs2From()) || StringUtils.isEmpty((String)clientConfig.getAs2To())) {
            throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)"AS2-From and AS2-To attributes must be set"));
        }
        return new ClientFacade(currentOutboundEndpoint, this.muleContext, clientConfig, this.connectorContext, this.receiptListenerCache);
    }

    private OutboundEndpoint buildOutboundEndpoint(ClientConfig clientConfig, String httpEndpointRef) throws AS2ConnectorException {
        EndpointURIEndpointBuilder endpointBuilder = (EndpointURIEndpointBuilder)this.muleContext.getRegistry().lookupObject(httpEndpointRef);
        if (endpointBuilder == null) {
            throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)("Invalid global HTTP/S endpoint reference: " + httpEndpointRef + ". Make sure the connector config is pointing to the correct global HTTP/S endpoint")));
        }
        try {
            if (clientConfig.getReceiptTimeout() != null && clientConfig.getReceiptDeliveryOption() == null) {
                endpointBuilder.setResponseTimeout(clientConfig.getReceiptTimeout().intValue());
            }
            if (clientConfig.getAddress() != null) {
                endpointBuilder.getEndpointBuilder().setAddress(clientConfig.getAddress());
            }
            return endpointBuilder.buildOutboundEndpoint();
        }
        catch (Exception e) {
            throw new AS2ConnectorException(e);
        }
    }

    private ClientConfig buildClientConfigFromB2BProvider(String as2From, String as2To, B2BProvider b2bProvider) throws AS2ConnectorException {
        ClientConfig clientConfig = new ClientConfig();
        try {
            Config b2bProviderConfig;
            QueryObject as2ConfigQueryObject = (QueryObject)this.queryObjectFactory.create();
            as2ConfigQueryObject.put((Object)"fromPartyIdentifier", (Object)as2From);
            as2ConfigQueryObject.put((Object)"toPartyIdentifier", (Object)as2To);
            if (this.partnerManagerConnectorConfig.getMessageType() != null) {
                as2ConfigQueryObject.put((Object)"messageType", (Object)this.partnerManagerConnectorConfig.getMessageType());
            }
            if (this.partnerManagerConnectorConfig.getStandardVersion() != null) {
                as2ConfigQueryObject.put((Object)"version", (Object)this.partnerManagerConnectorConfig.getStandardVersion());
            }
            if (this.partnerManagerConnectorConfig.getStandard() != null) {
                as2ConfigQueryObject.put((Object)"standard", (Object)this.partnerManagerConnectorConfig.getStandard().toString());
            }
            if ((b2bProviderConfig = b2bProvider.getConfig(ConfigType.AS2, Direction.OUTBOUND, as2ConfigQueryObject)) == null) {
                throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)("Queried registered B2B Provider for AS2 send config but none was found. Check your configuration. Lookup key used was: " + as2ConfigQueryObject.toString())));
            }
            clientConfig.setAs2From(as2From);
            clientConfig.setAs2To(as2To);
            if (Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"isMdnAsync")).toString()).booleanValue()) {
                clientConfig.setReceiptDeliveryOption(Misc.getOrThrow("mdnAsyncUrl", (Map<String, Serializable>)b2bProviderConfig, SETTING_NOT_FOUND_ERROR_MESSAGE).toString());
            }
            clientConfig.setEncrypt(Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"encryptMessage")).toString()));
            clientConfig.setSign(Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"signMessage")).toString()));
            clientConfig.setContentType(((Serializable)b2bProviderConfig.get((Object)"contentType")).toString());
            clientConfig.setSubject(((Serializable)b2bProviderConfig.get((Object)"subject")).toString());
            if (b2bProviderConfig.get((Object)"filename") != null) {
                clientConfig.setFilename(((Serializable)b2bProviderConfig.get((Object)"filename")).toString());
            }
            clientConfig.setCompress(Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"compressMessage")).toString()));
            clientConfig.setContentTransferEncoding(ContentTransferEncodingEnum.valueOf(((Serializable)b2bProviderConfig.get((Object)"contentTransferEncoding")).toString().toLowerCase()));
            if (Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"requireMdn")).toString()).booleanValue()) {
                clientConfig.setRequireReceiptForUnsupportedSignatureFormat((Boolean)Misc.getOrThrow("requireReceiptForUnsupportedSignatureFormat", (Map<String, Serializable>)b2bProviderConfig, SETTING_NOT_FOUND_ERROR_MESSAGE));
                clientConfig.setRequireReceiptForUnsupportedDigestAlgorithm((Boolean)Misc.getOrThrow("requireReceiptForUnsupportedDigestAlgorithm", (Map<String, Serializable>)b2bProviderConfig, SETTING_NOT_FOUND_ERROR_MESSAGE));
            }
            if (Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"requireMdn")).toString()).booleanValue() && !Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"requireSignedMdn")).toString()).booleanValue()) {
                clientConfig.setRequestReceipt(RequestReceipt.unsigned);
            } else if (Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"requireMdn")).toString()).booleanValue() && Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"requireSignedMdn")).toString()).booleanValue()) {
                clientConfig.setRequestReceipt(RequestReceipt.signed);
            } else {
                clientConfig.setRequestReceipt(RequestReceipt.none);
            }
            this.configureDigestAlgorithm(clientConfig, b2bProviderConfig);
            this.configureFallbackDigestAlgorithm(clientConfig, b2bProviderConfig);
            byte[] ppk = (byte[])b2bProviderConfig.get((Object)"homeCertificate");
            byte[] certificate = (byte[])b2bProviderConfig.get((Object)"partnerCertificate");
            String keyStorePath = KeyStoreGenerator.createJks(ppk, as2From, certificate, as2To);
            clientConfig.setKeyStorePath(keyStorePath);
            clientConfig.setAddress(((Serializable)b2bProviderConfig.get((Object)"as2Url")).toString());
            clientConfig.setSuppressCmsAlgorithmProtectionAttribute(false);
        }
        catch (Exception e) {
            throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)"An error occurred while trying to read AS2 settings from registered B2B Provider"), e);
        }
        return clientConfig;
    }

    private void configureFallbackDigestAlgorithm(ClientConfig clientConfig, Config b2bProviderConfig) throws AS2ConnectorException {
        try {
            clientConfig.setFallbackDigestAlgorithm(DigestAlgorithmOptionEnum.valueOf(((Serializable)b2bProviderConfig.get((Object)"fallbackDigestAlgorithm")).toString().toLowerCase()));
        }
        catch (IllegalArgumentException e) {
            throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)("Unsupported Fallback Digest Algorithm: " + ((Serializable)b2bProviderConfig.get((Object)"fallbackDigestAlgorithm")).toString())), e);
        }
    }

    private void configureDigestAlgorithm(ClientConfig clientConfig, Config b2bProviderConfig) throws AS2ConnectorException {
        try {
            clientConfig.setDigestAlgorithm(DigestAlgorithmEnum.valueOf(((Serializable)b2bProviderConfig.get((Object)"digestAlgorithm")).toString().toLowerCase()));
        }
        catch (IllegalArgumentException e) {
            throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)("Unsupported Digest Algorithm: " + ((Serializable)b2bProviderConfig.get((Object)"digestAlgorithm")).toString())), e);
        }
    }
}

