/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.client.strategy;

import com.modus.common.message.Message;
import com.modus.common.message.MessageMDN;
import com.modus.mule.modules.as2.ConnectorContext;
import com.modus.mule.modules.as2.client.ClientConfig;
import com.modus.mule.modules.as2.client.Receipt;
import com.modus.mule.modules.as2.client.strategy.ClientStrategy;
import com.modus.mule.modules.as2.common.Misc;
import com.modus.mule.modules.as2.common.RequestReceipt;
import com.modus.mule.modules.as2.config.PartnerManagerConnectorConfig;
import com.mulesoft.api.b2b.B2BProvider;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.factory.Factory;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.api.b2b.transmission.TransmissionContext;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.transport.http.HttpConnector;

public class B2BProviderClientStrategy
extends ClientStrategy {
    private TransmissionSession currentTransmissionSession;

    public B2BProviderClientStrategy(ClientConfig clientConfig, ConnectorContext connectorContext, OutboundEndpoint outboundEndpoint) {
        super(clientConfig, connectorContext, outboundEndpoint);
    }

    @Override
    protected Receipt getReceipt(String as2MessageId) throws Exception {
        PartnerManagerConnectorConfig connectorConfig = (PartnerManagerConnectorConfig)this.connectorContext.getConnectorConfig();
        QueryObject queryObject = (QueryObject)connectorConfig.getB2BProvider().getFactoryResolver().getFactory(QueryObject.class).create();
        queryObject.put((Object)"as2MessageId", (Object)as2MessageId);
        Transmission resultAs2Transmission = connectorConfig.getB2BProvider().readTransmission(Direction.OUTBOUND, TransmissionType.AS2, queryObject);
        if (resultAs2Transmission != null && resultAs2Transmission.get((Object)"isMdnExpected") != null && resultAs2Transmission.get((Object)"isMdnExpected").toString().toUpperCase().equals("FALSE")) {
            Receipt receipt = new Receipt();
            receipt.setAs2From(resultAs2Transmission.get((Object)"as2From").toString());
            receipt.setMdnContent((byte[])resultAs2Transmission.get((Object)"mdnContent"));
            receipt.setMdnContentType(resultAs2Transmission.get((Object)"mdnContentType").toString());
            receipt.isMdnExpected(Boolean.valueOf(resultAs2Transmission.get((Object)"isMdnExpected").toString()));
            return receipt;
        }
        return null;
    }

    @Override
    public void onReceiveReceiptError(Message as2Message, MuleEvent requestMuleEvent, Exception exception, MuleEvent receiptMuleEvent) throws Exception {
        this.updateAs2TransmissionToFailed(as2Message.getMessageID(), ((PartnerManagerConnectorConfig)this.connectorContext.getConnectorConfig()).getB2BProvider(), requestMuleEvent, exception, receiptMuleEvent);
    }

    @Override
    public void onSend(Message as2Request, MuleEvent requestMuleEvent) throws Exception {
        this.currentTransmissionSession = this.recordAs2Transmission(as2Request, requestMuleEvent, ((PartnerManagerConnectorConfig)this.connectorContext.getConnectorConfig()).getB2BProvider());
    }

    @Override
    public void onReceiveAsyncReceipt(MessageMDN messageMDN, MuleEvent receiptMuleEvent, MuleEvent requestMuleEvent) throws Exception {
        PartnerManagerConnectorConfig connectorConfig = (PartnerManagerConnectorConfig)this.connectorContext.getConnectorConfig();
        Transmission as2Transmission = (Transmission)connectorConfig.getB2BProvider().getFactoryResolver().getFactory(Transmission.class).create();
        as2Transmission.put((Object)"originalMessageId", (Object)messageMDN.getHeader("Original-Message-ID"));
        as2Transmission.put((Object)"as2MessageId", (Object)messageMDN.getHeader("Message-ID"));
        as2Transmission.put((Object)"state", (Object)"RECEIVE");
        as2Transmission.put((Object)"mdnTime", (Object)new Date());
        as2Transmission.put((Object)"mdnContent", (Object)receiptMuleEvent.getMessage().getPayloadAsBytes());
        as2Transmission.put((Object)"isMdnExpected", (Object)false);
        as2Transmission.put((Object)"as2From", (Object)messageMDN.getHeader("AS2-From"));
        as2Transmission.put((Object)"as2To", (Object)messageMDN.getHeader("AS2-To"));
        if (receiptMuleEvent.getMessage().getInboundProperty("Content-Type") != null) {
            as2Transmission.put((Object)"mdnContentType", (Object)receiptMuleEvent.getMessage().getInboundProperty("Content-Type").toString());
        }
        this.updateAs2Transmission(receiptMuleEvent, requestMuleEvent, as2Transmission);
    }

    @Override
    public void onSuccessfulReceipt(Message as2Request, MuleEvent receiptMuleEvent, MuleEvent requestMuleEvent) throws Exception {
        PartnerManagerConnectorConfig connectorConfig = (PartnerManagerConnectorConfig)this.connectorContext.getConnectorConfig();
        Transmission as2Transmission = (Transmission)connectorConfig.getB2BProvider().getFactoryResolver().getFactory(Transmission.class).create();
        as2Transmission.put((Object)"as2MessageId", (Object)as2Request.getMessageID());
        as2Transmission.put((Object)"state", (Object)"PROCESS");
        as2Transmission.put((Object)"mdnTime", (Object)new Date());
        as2Transmission.put((Object)"mdnContent", (Object)receiptMuleEvent.getMessage().getPayloadAsBytes());
        as2Transmission.put((Object)"mdnStatus", (Object)"SUCCESS");
        as2Transmission.put((Object)"isMdnExpected", (Object)false);
        if (((HashMap)receiptMuleEvent.getMessage().getInboundProperty("http.headers", new HashMap())).get("Content-Type") != null) {
            as2Transmission.put((Object)"mdnContentType", (Object)((Serializable)((HashMap)receiptMuleEvent.getMessage().getInboundProperty("http.headers", new HashMap())).get("Content-Type")).toString());
        }
        this.updateAs2Transmission(receiptMuleEvent, requestMuleEvent, as2Transmission);
    }

    @Override
    public void onClose() throws IOException {
        if (this.outboundEndpoint instanceof Disposable) {
            ((Disposable)this.outboundEndpoint).dispose();
            ((HttpConnector)this.outboundEndpoint.getConnector()).getDispatchers().clear();
        }
    }

    private void updateAs2TransmissionToFailed(String as2MessageId, B2BProvider b2bProvider, MuleEvent muleEvent, Exception exception, MuleEvent receiptMuleEvent) throws Exception {
        Transmission as2Transmission = (Transmission)b2bProvider.getFactoryResolver().getFactory(Transmission.class).create();
        as2Transmission.put((Object)"state", (Object)"PROCESS");
        as2Transmission.put((Object)"as2MessageId", (Object)Misc.stripAngleBrackets(as2MessageId));
        as2Transmission.put((Object)"mdnStatus", (Object)"FAILURE");
        as2Transmission.put((Object)"errors", (Object)exception.getMessage());
        as2Transmission.put((Object)"isMdnExpected", (Object)false);
        if (receiptMuleEvent != null) {
            as2Transmission.put((Object)"mdnContent", (Object)receiptMuleEvent.getMessage().getPayloadAsBytes());
            if (receiptMuleEvent.getMessage().getInboundProperty("Content-Type") != null) {
                as2Transmission.put((Object)"mdnContentType", (Object)receiptMuleEvent.getMessage().getInboundProperty("Content-Type").toString());
            }
        }
        Factory transmissionContextFactory = ((PartnerManagerConnectorConfig)this.connectorContext.getConnectorConfig()).getB2BProvider().getFactoryResolver().getFactory(TransmissionContext.class);
        TransmissionContext transmissionContext = (TransmissionContext)transmissionContextFactory.create();
        transmissionContext.setMuleEvent(muleEvent);
        transmissionContext.setTransmissionSession(this.currentTransmissionSession);
        b2bProvider.writeTransmission(Direction.OUTBOUND, as2Transmission, transmissionContext, TransmissionType.AS2);
    }

    private TransmissionSession recordAs2Transmission(Message mdnAs2Message, MuleEvent muleEvent, B2BProvider b2bProvider) throws Exception {
        Transmission as2Transmission = (Transmission)b2bProvider.getFactoryResolver().getFactory(Transmission.class).create();
        as2Transmission.put((Object)"content", (Object)muleEvent.getMessage().getPayloadAsBytes());
        as2Transmission.put((Object)"filename", (Object)this.clientConfig.getFilename());
        Transmission fullAs2Transmission = this.addAs2MessageToAs2Transmission(mdnAs2Message, as2Transmission);
        TransmissionSession transmissionSession = (TransmissionSession)muleEvent.getFlowVariable("b2bTransmissionSession");
        Factory transmissionContextFactory = b2bProvider.getFactoryResolver().getFactory(TransmissionContext.class);
        TransmissionContext transmissionContext = (TransmissionContext)transmissionContextFactory.create();
        transmissionContext.setMuleEvent(muleEvent);
        transmissionContext.setTransmissionSession(transmissionSession);
        return b2bProvider.writeTransmission(Direction.OUTBOUND, fullAs2Transmission, transmissionContext, TransmissionType.AS2);
    }

    private Transmission addAs2MessageToAs2Transmission(Message mdnAs2Message, Transmission as2Transmission) throws Exception {
        as2Transmission.put((Object)"state", (Object)"SEND");
        as2Transmission.put((Object)"isMessageEncrypted", (Object)this.clientConfig.getEncrypt());
        as2Transmission.put((Object)"isMessageSigned", (Object)this.clientConfig.getSign());
        as2Transmission.put((Object)"contentType", (Object)mdnAs2Message.getHeader("Content-Type"));
        as2Transmission.put((Object)"as2From", (Object)mdnAs2Message.getHeader("AS2-From"));
        as2Transmission.put((Object)"as2To", (Object)mdnAs2Message.getHeader("AS2-To"));
        if (this.clientConfig.getRequestReceipt().equals((Object)RequestReceipt.none)) {
            as2Transmission.put((Object)"isMdnExpected", (Object)false);
            as2Transmission.put((Object)"mdnStatus", (Object)"NONE");
        } else {
            as2Transmission.put((Object)"isMdnExpected", (Object)true);
            as2Transmission.put((Object)"mdnStatus", (Object)"PENDING");
        }
        as2Transmission.put((Object)"messageMicValue", (Object)mdnAs2Message.getOriginalMIC());
        if (mdnAs2Message.isRequestingAsyncMDN()) {
            as2Transmission.put((Object)"isMdnAsync", (Object)true);
        } else {
            as2Transmission.put((Object)"isMdnAsync", (Object)false);
        }
        as2Transmission.put((Object)"as2MessageId", (Object)Misc.stripAngleBrackets(mdnAs2Message.getMessageID()));
        return as2Transmission;
    }

    private void updateAs2Transmission(MuleEvent receiptMuleEvent, MuleEvent requestMuleEvent, Transmission as2Transmission) throws Exception {
        PartnerManagerConnectorConfig connectorConfig = (PartnerManagerConnectorConfig)this.connectorContext.getConnectorConfig();
        if (as2Transmission.get((Object)"as2MessageId") != null) {
            as2Transmission.put((Object)"as2MessageId", (Object)Misc.stripAngleBrackets(as2Transmission.get((Object)"as2MessageId").toString()));
        }
        if (as2Transmission.get((Object)"originalMessageId") != null) {
            as2Transmission.put((Object)"originalMessageId", (Object)Misc.stripAngleBrackets(as2Transmission.get((Object)"originalMessageId").toString()));
        }
        Factory transmissionContextFactory = ((PartnerManagerConnectorConfig)this.connectorContext.getConnectorConfig()).getB2BProvider().getFactoryResolver().getFactory(TransmissionContext.class);
        TransmissionContext transmissionContext = (TransmissionContext)transmissionContextFactory.create();
        transmissionContext.setMuleEvent(requestMuleEvent);
        transmissionContext.setTransmissionSession(this.currentTransmissionSession);
        this.currentTransmissionSession = connectorConfig.getB2BProvider().writeTransmission(Direction.OUTBOUND, as2Transmission, transmissionContext, TransmissionType.AS2);
        receiptMuleEvent.setFlowVariable("b2bTransmissionSession", (Object)this.currentTransmissionSession);
    }
}

