/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.client.strategy;

import com.modus.common.message.Message;
import com.modus.common.message.MessageMDN;
import com.modus.mule.modules.as2.ConnectorContext;
import com.modus.mule.modules.as2.client.ClientConfig;
import com.modus.mule.modules.as2.client.Receipt;
import com.modus.mule.modules.as2.common.Misc;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.config.i18n.MessageFactory;

public abstract class ClientStrategy {
    private static final int TRACKER_POLL_INTERVAL_MILLISECONDS = 1000;
    protected ClientConfig clientConfig;
    protected ConnectorContext connectorContext;
    protected OutboundEndpoint outboundEndpoint;

    public ClientStrategy(ClientConfig clientConfig, ConnectorContext connectorContext, OutboundEndpoint outboundEndpoint) {
        this.clientConfig = clientConfig;
        this.connectorContext = connectorContext;
        this.outboundEndpoint = outboundEndpoint;
    }

    public Receipt pollReceipt(Message as2Message, MuleEvent requestMuleEvent) throws Exception {
        String as2MessageId;
        Receipt receipt;
        int elapsedTimeMilliseconds = 0;
        while ((receipt = this.getReceipt(as2MessageId = Misc.stripAngleBrackets(as2Message.getMessageID()))) == null) {
            Thread.sleep(1000L);
            if ((elapsedTimeMilliseconds += 1000) <= this.clientConfig.getReceiptTimeout()) continue;
            this.onReceiveReceiptError(as2Message, requestMuleEvent, new TimeoutException(), null);
            throw new MessagingException(MessageFactory.createStaticMessage((String)"Timed out waiting for async receipt"), requestMuleEvent);
        }
        return receipt;
    }

    public abstract void onReceiveReceiptError(Message var1, MuleEvent var2, Exception var3, MuleEvent var4) throws Exception;

    public abstract void onSuccessfulReceipt(Message var1, MuleEvent var2, MuleEvent var3) throws Exception;

    public abstract void onSend(Message var1, MuleEvent var2) throws Exception;

    public abstract void onReceiveAsyncReceipt(MessageMDN var1, MuleEvent var2, MuleEvent var3) throws Exception;

    public abstract void onClose() throws IOException;

    protected abstract Receipt getReceipt(String var1) throws Exception;
}

