/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyStoreGenerator {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreGenerator.class);

    private KeyStoreGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createJks(byte[] ppk, String ppkAlias, byte[] certificate, String certificateAlias) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, "".toCharArray());
        if (certificate != null && certificate.length > 0) {
            X509Certificate cert = KeyStoreGenerator.readX509Cert(certificate);
            keyStore.setCertificateEntry(certificateAlias, cert);
        } else {
            logger.warn("No partner certificate loaded from registered B2B Provider");
        }
        if (ppk != null && ppk.length > 0) {
            KeyStoreGenerator.loadPPK(ppk, keyStore, ppkAlias);
        } else {
            logger.warn("No home certificate loaded from registered B2B Provider");
        }
        File keyStoreFile = File.createTempFile("as2-keystore-", ".jks");
        keyStoreFile.deleteOnExit();
        FileOutputStream keyStoreOutputStream = new FileOutputStream(keyStoreFile);
        try {
            keyStore.store(keyStoreOutputStream, "".toCharArray());
        }
        finally {
            keyStoreOutputStream.close();
        }
        return keyStoreFile.getAbsolutePath();
    }

    public static void loadPPK(byte[] ppk, KeyStore jksKeyStore, String ppkAlias) throws Exception {
        String alias;
        KeyStore pkcs12KeyStore = KeyStore.getInstance("PKCS12");
        pkcs12KeyStore.load(new ByteArrayInputStream(ppk), "".toCharArray());
        Enumeration<String> aliases = pkcs12KeyStore.aliases();
        if (aliases.hasMoreElements() && pkcs12KeyStore.isKeyEntry(alias = aliases.nextElement())) {
            Key key = pkcs12KeyStore.getKey(alias, "".toCharArray());
            Certificate[] chain = pkcs12KeyStore.getCertificateChain(alias);
            jksKeyStore.setKeyEntry(ppkAlias, key, "".toCharArray(), chain);
        }
    }

    private static X509Certificate readX509Cert(byte[] certificate) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(certificate);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = null;
        while (inputStream.available() > 0) {
            cert = (X509Certificate)cf.generateCertificate(inputStream);
        }
        return cert;
    }
}

