/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.common;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.shade.Header;
import org.apache.http.shade.HttpResponse;
import org.apache.http.shade.client.methods.HttpPost;
import org.mule.api.MuleMessage;
import org.mule.util.IOUtils;
import org.slf4j.Logger;

public final class LoggingUtils {
    private LoggingUtils() {
    }

    private static void log(String label, Logger logger, Map<String, Object> httpHeaders, String httpBody) {
        StringBuilder log = new StringBuilder();
        log.append("\n\n############## ").append(label).append(" ##############\n\n");
        for (Map.Entry<String, Object> httpHeader : httpHeaders.entrySet()) {
            log.append(httpHeader.getKey()).append(" -> ").append(httpHeader.getValue()).append("\n");
        }
        log.append("\n").append(httpBody).append("\n############################################\n\n");
        logger.debug(log.toString());
    }

    public static void logOutgoingMessage(MuleMessage requestMuleMessage, String headerText, Logger logger) throws Exception {
        if (logger.isDebugEnabled()) {
            HashMap<String, Object> logHttpHeaders = new HashMap<String, Object>();
            Set httpHeaderNames = requestMuleMessage.getOutboundPropertyNames();
            for (String httpHeaderName : httpHeaderNames) {
                logHttpHeaders.put(httpHeaderName, requestMuleMessage.getOutboundProperty(httpHeaderName).toString());
            }
            LoggingUtils.logMessage(logHttpHeaders, headerText, requestMuleMessage.getPayloadAsBytes(), logger);
        }
    }

    public static void logIncomingMessage(MuleMessage replyMuleMessage, String headerText, Logger logger) throws Exception {
        if (logger.isDebugEnabled()) {
            LoggingUtils.logMessage((Map)replyMuleMessage.getInboundProperty("http.headers", new HashMap()), headerText, replyMuleMessage.getPayloadAsBytes(), logger);
        }
    }

    public static void logOutgoingMessage(HttpPost httpPost, String headerText, Logger logger) throws Exception {
        if (logger.isDebugEnabled()) {
            Header[] httpHeaders;
            HashMap<String, Object> logHttpHeaders = new HashMap<String, Object>();
            for (Header httpHeader : httpHeaders = httpPost.getAllHeaders()) {
                logHttpHeaders.put(httpHeader.getName(), httpHeader.getValue());
            }
            byte[] content = httpPost.getEntity() != null ? IOUtils.toByteArray((InputStream)httpPost.getEntity().getContent()) : new byte[]{};
            LoggingUtils.logMessage(logHttpHeaders, headerText, content, logger);
        }
    }

    public static void logMessage(Map<String, Object> httpHeaders, String headerText, byte[] httpBody, Logger logger) throws Exception {
        LoggingUtils.log(headerText, logger, httpHeaders, new String(httpBody, StandardCharsets.UTF_8));
    }

    public static void logIncomingMessage(HttpResponse httpResponse, String headerText, Logger logger) throws Exception {
        if (logger.isDebugEnabled()) {
            Header[] httpHeaders;
            HashMap<String, Object> logHttpHeaders = new HashMap<String, Object>();
            for (Header httpHeader : httpHeaders = httpResponse.getAllHeaders()) {
                logHttpHeaders.put(httpHeader.getName(), httpHeader.getValue());
            }
            byte[] content = httpResponse.getEntity() != null ? IOUtils.toByteArray((InputStream)httpResponse.getEntity().getContent()) : new byte[]{};
            LoggingUtils.logMessage(logHttpHeaders, headerText, content, logger);
        }
    }
}

