/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.server;

import com.modus.common.message.Message;
import com.modus.common.message.MessageMDN;
import com.modus.common.service.agreement.Agreement;
import com.modus.common.service.agreement.SecurityInfo;
import com.modus.common.service.result.AS2Result;
import com.modus.mule.modules.as2.ConnectorContext;
import com.modus.mule.modules.as2.GlobalContext;
import com.modus.mule.modules.as2.common.AS2ConnectorException;
import com.modus.mule.modules.as2.common.DigestAlgorithmOptionEnum;
import com.modus.mule.modules.as2.common.KeyStoreGenerator;
import com.modus.mule.modules.as2.common.LoggingUtils;
import com.modus.mule.modules.as2.common.Misc;
import com.modus.mule.modules.as2.config.PartnerManagerConnectorConfig;
import com.modus.mule.modules.as2.server.ServerConfig;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.ConfigType;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.factory.Factory;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.api.b2b.transmission.TransmissionContext;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Header;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.resource.spi.work.Work;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.http.shade.HttpResponse;
import org.apache.http.shade.client.methods.HttpPost;
import org.apache.http.shade.concurrent.FutureCallback;
import org.apache.http.shade.entity.AbstractHttpEntity;
import org.apache.http.shade.entity.ByteArrayEntity;
import org.apache.http.shade.entity.StringEntity;
import org.apache.http.shade.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.shade.impl.nio.client.HttpAsyncClients;
import org.apache.http.shade.nio.conn.ssl.SSLIOSessionStrategy;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.callback.SourceCallback;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.security.tls.TlsConfiguration;
import org.mule.api.transport.PropertyScope;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.Flow;
import org.mule.context.notification.NotificationException;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.security.oauth.processor.AbstractListeningMessageProcessor;
import org.mule.util.ArrayUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerFacade {
    private static final Logger logger = LoggerFactory.getLogger(ServerFacade.class);
    private static final Pattern filenamePattern = Pattern.compile("=(.*?)$");
    private final Boolean useB2BProvider;
    private MuleContext muleContext;
    private InboundEndpoint inboundEndpoint;
    private SourceCallback callback;
    private final ServerConfig serverConfig;
    private Agreement agreement;
    private ConnectorContext connectorContext;
    private CloseableHttpAsyncClient httpAsyncClient;
    private CloseableHttpAsyncClient httpsAsyncClient;
    private FutureCallback asyncReceiptReplyFutureCallback;
    private FlowConstruct flowConstruct;

    public ServerFacade(SourceCallback callback, MuleContext muleContext, ServerConfig serverConfig, ConnectorContext connectorContext) throws AS2ConnectorException {
        this.muleContext = muleContext;
        this.callback = callback;
        this.serverConfig = serverConfig;
        this.connectorContext = connectorContext;
        this.httpAsyncClient = GlobalContext.getInstance().getHttpAsyncClient();
        this.httpsAsyncClient = this.createHttpsClient(serverConfig);
        this.asyncReceiptReplyFutureCallback = this.createAsyncReceiptReplyHandler();
        this.useB2BProvider = connectorContext.getConnectorConfig().getUseB2BProvider();
    }

    public void start() throws AS2ConnectorException {
        block5: {
            if (this.connectorContext.getAs2Service() == null) {
                throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)"AS2Service is not set"));
            }
            this.flowConstruct = ((AbstractListeningMessageProcessor)this.callback).getFlowConstruct();
            Object object = this.muleContext.getRegistry().lookupObject(this.serverConfig.getHttpEndpointRef());
            try {
                if (object instanceof EndpointURIEndpointBuilder) {
                    EndpointURIEndpointBuilder endpointBuilder = (EndpointURIEndpointBuilder)object;
                    this.inboundEndpoint = this.muleContext.getEndpointFactory().getInboundEndpoint((EndpointBuilder)endpointBuilder);
                    this.inboundEndpoint.setFlowConstruct(this.flowConstruct);
                    this.inboundEndpoint.setListener((MessageProcessor)new Listener(this.callback));
                    this.setShutdownListener();
                    this.muleContext.getRegistry().registerObject(this.inboundEndpoint.getName(), (Object)this.inboundEndpoint, ImmutableEndpoint.class);
                    this.inboundEndpoint.start();
                    break block5;
                }
                if (object instanceof InboundEndpoint) {
                    this.inboundEndpoint = (InboundEndpoint)object;
                    this.inboundEndpoint.setFlowConstruct(this.flowConstruct);
                    this.inboundEndpoint.setListener((MessageProcessor)new Listener(this.callback));
                    this.inboundEndpoint.start();
                    this.setShutdownListener();
                    break block5;
                }
                throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)("Invalid global HTTP/S endpoint reference: " + this.serverConfig.getHttpEndpointRef() + ". Make sure the connector config is pointing to the correct global HTTP/S endpoint")));
            }
            catch (Exception e) {
                throw new AS2ConnectorException(e);
            }
        }
    }

    public void stop() throws AS2ConnectorException {
        if (this.inboundEndpoint != null) {
            try {
                this.inboundEndpoint.stop();
            }
            catch (Exception e) {
                throw new AS2ConnectorException(e);
            }
        }
    }

    private HttpPost messageMdnToHttpPost(String destination, MessageMDN mdnAs2Message) throws Exception {
        HttpPost httpPost = new HttpPost(destination);
        AbstractHttpEntity httpEntity = mdnAs2Message.getData() != null ? new ByteArrayEntity(IOUtils.toByteArray((InputStream)mdnAs2Message.getData().getInputStream())) : new StringEntity("");
        httpPost.setEntity(httpEntity);
        Enumeration headers = mdnAs2Message.getHeaders().getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            httpPost.setHeader(header.getName(), header.getValue());
        }
        return httpPost;
    }

    private CloseableHttpAsyncClient createHttpsClient(ServerConfig serverConfig) throws AS2ConnectorException {
        try {
            if (StringUtils.isNotBlank((String)serverConfig.getKeyStorePath())) {
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                InputStream keyStoreInputStream = IOUtils.getResourceAsStream((String)serverConfig.getKeyStorePath(), this.getClass(), (boolean)true, (boolean)false);
                if (keyStoreInputStream == null) {
                    throw new AS2ConnectorException(new FileNotFoundException("Key store not found"));
                }
                this.loadTrustStore(serverConfig, trustStore, keyStoreInputStream);
                TlsConfiguration tlsConfiguration = new TlsConfiguration(null);
                int muleMajorMinorVersion = Integer.parseInt(MuleManifest.getProductVersion().substring(0, 1) + MuleManifest.getProductVersion().substring(2, 3));
                if (muleMajorMinorVersion >= 37) {
                    tlsConfiguration.setTrustStore(serverConfig.getKeyStorePath());
                    tlsConfiguration.setTrustStorePassword(serverConfig.getKeyStorePassword());
                } else {
                    tlsConfiguration.setKeyStore(serverConfig.getKeyStorePath());
                    tlsConfiguration.setKeyStorePassword(serverConfig.getKeyStorePassword());
                }
                tlsConfiguration.setKeyPassword("");
                tlsConfiguration.initialise(true, "javax.net");
                KeyManager[] keyManagers = null == tlsConfiguration.getKeyManagerFactory() ? null : tlsConfiguration.getKeyManagerFactory().getKeyManagers();
                TrustManager[] trustManagers = null == tlsConfiguration.getTrustManagerFactory() ? null : tlsConfiguration.getTrustManagerFactory().getTrustManagers();
                SSLContext sslContext = SSLContext.getInstance(tlsConfiguration.getSslType());
                sslContext.init(keyManagers, trustManagers, null);
                String[] enabledProtocols = tlsConfiguration.getEnabledProtocols() != null ? ArrayUtils.intersection((String[])tlsConfiguration.getEnabledProtocols(), (String[])sslContext.getSupportedSSLParameters().getProtocols()) : sslContext.getDefaultSSLParameters().getProtocols();
                String[] enabledCiphers = tlsConfiguration.getEnabledCipherSuites() != null ? ArrayUtils.intersection((String[])tlsConfiguration.getEnabledCipherSuites(), (String[])sslContext.getSupportedSSLParameters().getCipherSuites()) : sslContext.getDefaultSSLParameters().getCipherSuites();
                SSLIOSessionStrategy sslSessionStrategy = new SSLIOSessionStrategy(sslContext, enabledProtocols, enabledCiphers, SSLIOSessionStrategy.ALLOW_ALL_HOSTNAME_VERIFIER);
                return HttpAsyncClients.custom().setSSLContext(sslContext).setSSLStrategy(sslSessionStrategy).build();
            }
            return null;
        }
        catch (IOException e) {
            throw new AS2ConnectorException(e);
        }
        catch (GeneralSecurityException e) {
            throw new AS2ConnectorException(e);
        }
        catch (MuleException e) {
            throw new AS2ConnectorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTrustStore(ServerConfig serverConfig, KeyStore trustStore, InputStream keyStoreInputStream) throws NoSuchAlgorithmException, CertificateException, IOException {
        try {
            trustStore.load(keyStoreInputStream, serverConfig.getKeyStorePassword().toCharArray());
        }
        finally {
            keyStoreInputStream.close();
        }
    }

    private FutureCallback<HttpResponse> createAsyncReceiptReplyHandler() {
        return new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(HttpResponse httpResponse) {
                try {
                    LoggingUtils.logIncomingMessage(httpResponse, "Received reply", logger);
                }
                catch (Exception ex) {
                    logger.error("An error occurred while logging the reply", (Throwable)ex);
                }
                finally {
                    try {
                        httpResponse.getEntity().getContent().close();
                    }
                    catch (IOException e) {
                        logger.error("An error occurred while closing HTTP stream", (Throwable)e);
                    }
                }
            }

            @Override
            public void failed(Exception ex) {
                logger.error("An error occurred while sending the async receipt", (Throwable)ex);
            }

            @Override
            public void cancelled() {
            }
        };
    }

    private void sendReceiptOverHttps(String asyncToUrl, AS2Result as2Result) throws Exception {
        if (this.httpsAsyncClient != null) {
            if (!this.httpsAsyncClient.isRunning()) {
                this.httpsAsyncClient.start();
            }
        } else {
            throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)"The receipt cannot be sent over HTTPS because no key store is set"));
        }
        this.httpsAsyncClient.execute(this.messageMdnToHttpPost(asyncToUrl, as2Result.getMDN()), this.asyncReceiptReplyFutureCallback);
    }

    private void setShutdownListener() throws AS2ConnectorException {
        try {
            this.muleContext.registerListener((ServerNotificationListener)new ShutdownListener());
        }
        catch (NotificationException e) {
            throw new AS2ConnectorException(e);
        }
    }

    private void loadAs2SettingsFromLocalConfig(Agreement agreement, ServerConfig serverConfig) {
        agreement.from(serverConfig.getRequireSenderAs2From()).to(serverConfig.getRequireSenderAs2To()).setMDNSubject(serverConfig.getReceiptSubject());
        if (serverConfig.getPreferredDigestAlgorithm().equals((Object)DigestAlgorithmOptionEnum.sha1)) {
            agreement.setMicAlgorithm("sha1");
        } else if (serverConfig.getPreferredDigestAlgorithm().equals((Object)DigestAlgorithmOptionEnum.sha224)) {
            agreement.setMicAlgorithm("sha224");
        } else if (serverConfig.getPreferredDigestAlgorithm().equals((Object)DigestAlgorithmOptionEnum.sha256)) {
            agreement.setMicAlgorithm("sha256");
        } else if (serverConfig.getPreferredDigestAlgorithm().equals((Object)DigestAlgorithmOptionEnum.sha384)) {
            agreement.setMicAlgorithm("sha384");
        } else if (serverConfig.getPreferredDigestAlgorithm().equals((Object)DigestAlgorithmOptionEnum.sha512)) {
            agreement.setMicAlgorithm("sha512");
        } else if (serverConfig.getPreferredDigestAlgorithm().equals((Object)DigestAlgorithmOptionEnum.md5)) {
            agreement.setMicAlgorithm("md5");
        }
        if (serverConfig.getRequireSenderEncrypts().booleanValue()) {
            agreement.encrypted();
        }
        if (serverConfig.getRequireSenderSigns().booleanValue()) {
            agreement.signed();
        }
        if (serverConfig.getRequireSenderCompress().booleanValue()) {
            agreement.compressed();
        }
    }

    private void loadAs2SettingsFromB2BProvider(Agreement agreement, ServerConfig serverConfig, String as2From, String as2To) throws AS2ConnectorException {
        try {
            Config as2Config;
            PartnerManagerConnectorConfig connectorConfig = (PartnerManagerConnectorConfig)this.connectorContext.getConnectorConfig();
            Factory queryObjectFactory = connectorConfig.getB2BProvider().getFactoryResolver().getFactory(QueryObject.class);
            QueryObject as2ConfigQueryObject = (QueryObject)queryObjectFactory.create();
            as2ConfigQueryObject.put((Object)"fromPartyIdentifier", (Object)as2From);
            as2ConfigQueryObject.put((Object)"toPartyIdentifier", (Object)as2To);
            if (connectorConfig.getMessageType() != null) {
                as2ConfigQueryObject.put((Object)"messageType", (Object)connectorConfig.getMessageType());
            }
            if (connectorConfig.getStandardVersion() != null) {
                as2ConfigQueryObject.put((Object)"version", (Object)connectorConfig.getStandardVersion());
            }
            if (connectorConfig.getStandard() != null) {
                as2ConfigQueryObject.put((Object)"standard", (Object)connectorConfig.getStandard().toString());
            }
            if ((as2Config = connectorConfig.getB2BProvider().getConfig(ConfigType.AS2, Direction.INBOUND, as2ConfigQueryObject)) == null) {
                throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)("Queried registered B2B Provider for AS2 receive config but none was found. Check your configuration. Lookup key used was:  " + as2ConfigQueryObject.toString())));
            }
            if (StringUtils.equalsIgnoreCase((String)((Serializable)as2Config.get((Object)"preferredDigestAlgorithm")).toString(), (String)DigestAlgorithmOptionEnum.sha1.toString())) {
                agreement.setMicAlgorithm("sha1");
            } else if (StringUtils.equalsIgnoreCase((String)((Serializable)as2Config.get((Object)"preferredDigestAlgorithm")).toString(), (String)DigestAlgorithmOptionEnum.sha224.toString())) {
                agreement.setMicAlgorithm("sha224");
            } else if (StringUtils.equalsIgnoreCase((String)((Serializable)as2Config.get((Object)"preferredDigestAlgorithm")).toString(), (String)DigestAlgorithmOptionEnum.sha256.toString())) {
                agreement.setMicAlgorithm("sha256");
            } else if (StringUtils.equalsIgnoreCase((String)((Serializable)as2Config.get((Object)"preferredDigestAlgorithm")).toString(), (String)DigestAlgorithmOptionEnum.sha384.toString())) {
                agreement.setMicAlgorithm("sha384");
            } else if (StringUtils.equalsIgnoreCase((String)((Serializable)as2Config.get((Object)"preferredDigestAlgorithm")).toString(), (String)DigestAlgorithmOptionEnum.sha512.toString())) {
                agreement.setMicAlgorithm("sha512");
            } else if (StringUtils.equalsIgnoreCase((String)((Serializable)as2Config.get((Object)"preferredDigestAlgorithm")).toString(), (String)DigestAlgorithmOptionEnum.md5.toString())) {
                agreement.setMicAlgorithm("md5");
            } else if (!StringUtils.equalsIgnoreCase((String)((Serializable)as2Config.get((Object)"preferredDigestAlgorithm")).toString(), (String)DigestAlgorithmOptionEnum.none.toString())) {
                throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)("Unsupported Digest Algorithm: " + ((Serializable)as2Config.get((Object)"preferredDigestAlgorithm")).toString())));
            }
            if (Boolean.valueOf(((Serializable)as2Config.get((Object)"requireCompressed")).toString()).booleanValue()) {
                agreement.compressed();
            } else {
                agreement.notCompressed();
            }
            if (Boolean.valueOf(((Serializable)as2Config.get((Object)"requireMessageEncrypted")).toString()).booleanValue()) {
                agreement.encrypted();
            } else {
                agreement.notEncrypted();
            }
            if (Boolean.valueOf(((Serializable)as2Config.get((Object)"requireMessageSigned")).toString()).booleanValue()) {
                agreement.signed();
            } else {
                agreement.notSigned();
            }
            agreement.setMDNSubject(((Serializable)as2Config.get((Object)"mdnSubject")).toString());
            byte[] ppk = (byte[])as2Config.get((Object)"homeCertificate");
            byte[] certificate = (byte[])as2Config.get((Object)"partnerCertificate");
            String keyStorePath = KeyStoreGenerator.createJks(ppk, as2To, certificate, as2From);
            serverConfig.setKeyStorePassword("");
            serverConfig.setKeyStorePath(keyStorePath);
            serverConfig.setSuppressCmsAlgorithmProtectionAttribute(false);
        }
        catch (Exception e) {
            throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)"An error occurred while trying to read AS2 settings from registered B2B Provider"), e);
        }
    }

    private MuleMessage createInboundMuleMessage(Message as2Message, MuleMessage requestMuleMessage) throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)as2Message.getData().getInputStream(), requestMuleMessage, this.muleContext);
        if (as2Message.getContentDisposition() != null) {
            muleMessage.setProperty("Content-Disposition", (Object)as2Message.getContentDisposition(), PropertyScope.INBOUND);
            muleMessage.setProperty("filename", (Object)this.extractFilename(as2Message.getContentDisposition()), PropertyScope.INBOUND);
        }
        return muleMessage;
    }

    private String extractFilename(String contentDisposition) {
        Matcher matcher = filenamePattern.matcher(contentDisposition);
        if (matcher.find()) {
            return matcher.group(1).replaceAll("\"", "");
        }
        return "";
    }

    private final class ShutdownListener
    implements MuleContextNotificationListener {
        private ShutdownListener() {
        }

        public void onNotification(ServerNotification notification) {
            try {
                if (notification.getAction() == 105 || notification.getAction() == 107) {
                    ServerFacade.this.stop();
                }
            }
            catch (AS2ConnectorException e) {
                logger.error("An error occurred while stopping the connector", (Throwable)((Object)e));
            }
        }
    }

    private class Listener
    implements MessageProcessor {
        private SourceCallback callback;

        public Listener(SourceCallback callback) throws AS2ConnectorException {
            this.callback = callback;
            ServerFacade.this.agreement = new Agreement();
            ServerFacade.this.loadAs2SettingsFromLocalConfig(ServerFacade.this.agreement, ServerFacade.this.serverConfig);
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            MuleMessage requestMuleMessage = event.getMessage();
            try {
                MuleMessage replyMuleMessage;
                ServerConfig currentServerConfig;
                Agreement currentAgreement;
                if (ServerFacade.this.useB2BProvider.booleanValue()) {
                    currentAgreement = new Agreement();
                    currentServerConfig = new ServerConfig();
                    String as2From = (String)requestMuleMessage.getInboundProperty("AS2-From");
                    String as2To = (String)requestMuleMessage.getInboundProperty("AS2-To");
                    ServerFacade.this.loadAs2SettingsFromB2BProvider(currentAgreement, currentServerConfig, as2From, as2To);
                    if (StringUtils.isNotBlank((String)ServerFacade.this.serverConfig.getRequireSenderAs2From())) {
                        currentAgreement.from(ServerFacade.this.serverConfig.getRequireSenderAs2From());
                    }
                    if (StringUtils.isNotBlank((String)ServerFacade.this.serverConfig.getRequireSenderAs2To())) {
                        currentAgreement.to(ServerFacade.this.serverConfig.getRequireSenderAs2To());
                    }
                } else {
                    currentAgreement = ServerFacade.this.agreement;
                    currentServerConfig = ServerFacade.this.serverConfig;
                }
                LoggingUtils.logIncomingMessage(requestMuleMessage, "Received request", logger);
                if (this.isAsyncReceipt(requestMuleMessage)) {
                    byte[] payload = requestMuleMessage.getPayloadAsBytes();
                    ServerFacade.this.muleContext.getWorkManager().scheduleWork((Work)new SendAsyncReceiptWork(event, requestMuleMessage, payload, currentAgreement, currentServerConfig));
                    replyMuleMessage = new DefaultMuleMessage((Object)"", ServerFacade.this.muleContext);
                } else {
                    AS2Result as2Result = this.processRequest(event, requestMuleMessage.getPayload(InputStream.class), currentAgreement, currentServerConfig);
                    replyMuleMessage = this.messageMDNToMuleMessage(as2Result.getMDN());
                }
                LoggingUtils.logOutgoingMessage(replyMuleMessage, "Sending AS2 reply", logger);
                return new DefaultMuleEvent(replyMuleMessage, event);
            }
            catch (Throwable e) {
                throw new MessagingException(event, e);
            }
        }

        private TransmissionSession recordAs2Transmission(AS2Result as2Result, MuleEvent muleEvent) throws Exception {
            return this.recordAs2Transmission(as2Result, null, muleEvent);
        }

        private TransmissionSession recordAs2Transmission(AS2Result as2Result, MuleMessage muleMessage, MuleEvent muleEvent) throws Exception {
            PartnerManagerConnectorConfig connectorConfig = (PartnerManagerConnectorConfig)ServerFacade.this.connectorContext.getConnectorConfig();
            Transmission as2Transmission = muleMessage != null ? this.muleMessageToAs2Transmission(muleMessage) : (Transmission)connectorConfig.getB2BProvider().getFactoryResolver().getFactory(Transmission.class).create();
            as2Transmission.put((Object)"isMessageEncrypted", (Object)as2Result.isEncrypted());
            as2Transmission.put((Object)"isMessageSigned", (Object)as2Result.isSigned());
            as2Transmission.put((Object)"isMdnExpected", (Object)as2Result.isMdnExpected());
            if (as2Result.getMDN().getHeaders().getHeader("Received-Content-MIC") != null) {
                as2Transmission.put((Object)"messageMicValue", (Object)as2Result.getMDN().getHeaders().getHeader("Received-Content-MIC")[0]);
            }
            if (as2Result.getMDN().getData() != null) {
                as2Transmission.put((Object)"mdnContent", (Object)IOUtils.toByteArray((InputStream)as2Result.getMDN().getData().getInputStream()));
                as2Transmission.put((Object)"mdnContentType", (Object)as2Result.getMDN().getHeader("Content-Type"));
                as2Transmission.put((Object)"mdnTime", (Object)new Date());
                as2Result.getMDN().getMessage().getOriginalMIC();
            }
            if (as2Result.isError()) {
                as2Transmission.put((Object)"error", (Object)as2Result.getError().getMessage());
            }
            Factory transmissionContextFactory = connectorConfig.getB2BProvider().getFactoryResolver().getFactory(TransmissionContext.class);
            TransmissionContext transmissionContext = (TransmissionContext)transmissionContextFactory.create();
            transmissionContext.setMuleEvent(muleEvent);
            return connectorConfig.getB2BProvider().writeTransmission(Direction.INBOUND, as2Transmission, transmissionContext, TransmissionType.AS2);
        }

        private Transmission muleMessageToAs2Transmission(MuleMessage muleMessage) throws Exception {
            Transmission as2Transmission = (Transmission)((PartnerManagerConnectorConfig)ServerFacade.this.connectorContext.getConnectorConfig()).getB2BProvider().getFactoryResolver().getFactory(Transmission.class).create();
            as2Transmission.put((Object)"messageMicValue", muleMessage.getOutboundProperty("Received-Content-MIC"));
            as2Transmission.put((Object)"content", (Object)muleMessage.getPayloadAsBytes());
            as2Transmission.put((Object)"mdnStatus", (Object)"SUCCESS");
            if (muleMessage.getInboundProperty("Content-Disposition") != null) {
                as2Transmission.put((Object)"filename", (Object)ServerFacade.this.extractFilename(muleMessage.getInboundProperty("Content-Disposition").toString()));
            }
            if (muleMessage.getInboundProperty("Content-Type") != null) {
                as2Transmission.put((Object)"contentType", (Object)muleMessage.getInboundProperty("Content-Type").toString());
            }
            if (muleMessage.getInboundProperty("AS2-From") != null) {
                as2Transmission.put((Object)"as2From", (Object)muleMessage.getInboundProperty("AS2-From").toString());
            }
            if (muleMessage.getInboundProperty("AS2-To") != null) {
                as2Transmission.put((Object)"as2To", (Object)muleMessage.getInboundProperty("AS2-To").toString());
            }
            if (this.isAsyncReceipt(muleMessage)) {
                as2Transmission.put((Object)"isMdnAsync", (Object)true);
            } else {
                as2Transmission.put((Object)"isMdnAsync", (Object)false);
            }
            if (muleMessage.getInboundProperty("Message-ID") != null) {
                as2Transmission.put((Object)"as2MessageId", (Object)Misc.stripAngleBrackets(muleMessage.getInboundProperty("Message-ID").toString()));
            }
            return as2Transmission;
        }

        private boolean isAsyncReceipt(MuleMessage message) {
            return message.getInboundProperty("Receipt-Delivery-Option") != null;
        }

        private AS2Result processRequest(MuleEvent requestMuleEvent, Object payload, Agreement agreement, ServerConfig serverConfig) throws Exception {
            MuleMessage requestMuleMessage = requestMuleEvent.getMessage();
            CaseInsensitiveMap headers = new CaseInsensitiveMap();
            headers.putAll((Map)requestMuleMessage.getInboundProperty("http.headers", new HashMap()));
            AS2Result as2Result = this.doAs2Process((Map<String, Serializable>)headers, payload, agreement, serverConfig);
            if (as2Result.isSuccess()) {
                Message as2Message = as2Result.getMDN().getMessage();
                this.doMuleProcess(as2Result, as2Message, requestMuleEvent, requestMuleMessage);
            } else if (ServerFacade.this.useB2BProvider.booleanValue()) {
                this.recordAs2Transmission(as2Result, requestMuleEvent);
            }
            return as2Result;
        }

        private void doMuleProcess(AS2Result as2Result, Message as2Message, MuleEvent requestMuleEvent, MuleMessage requestMuleMessage) throws Exception {
            MuleMessage inboundMuleMessage = ServerFacade.this.createInboundMuleMessage(as2Message, requestMuleMessage);
            if (ServerFacade.this.useB2BProvider.booleanValue()) {
                TransmissionSession transmissionSession = this.recordAs2Transmission(as2Result, inboundMuleMessage, requestMuleEvent);
                inboundMuleMessage.setInvocationProperty("b2bTransmissionSession", (Object)transmissionSession);
            }
            if (StringUtils.isNotEmpty((String)ServerFacade.this.serverConfig.getInvokeFlowBeforeSendReceipt())) {
                Flow flow = (Flow)ServerFacade.this.muleContext.getRegistry().lookupFlowConstruct(ServerFacade.this.serverConfig.getInvokeFlowBeforeSendReceipt());
                flow.process((MuleEvent)new DefaultMuleEvent(ServerFacade.this.createInboundMuleMessage(as2Message, requestMuleMessage), requestMuleEvent, true));
            }
            this.callback.processEvent((MuleEvent)new DefaultMuleEvent(inboundMuleMessage, requestMuleEvent, false));
        }

        private AS2Result doAs2Process(Map<String, Serializable> httpHeaders, Object payload, Agreement agreement, ServerConfig serverConfig) throws Exception {
            SecurityInfo securityInfo = new SecurityInfo(serverConfig.getKeyStorePath(), serverConfig.getKeyStorePassword(), serverConfig.getKeyStorePath(), serverConfig.getKeyStorePassword(), serverConfig.getSuppressCmsAlgorithmProtectionAttribute().booleanValue());
            AS2Result result = ServerFacade.this.connectorContext.getAs2Service().process(httpHeaders, payload, securityInfo, agreement);
            return result;
        }

        private MuleMessage messageMDNToMuleMessage(MessageMDN mdnAs2Message) throws Exception {
            DefaultMuleMessage mdnMuleMessage = new DefaultMuleMessage((Object)mdnAs2Message.getText(), ServerFacade.this.muleContext);
            Enumeration headers = mdnAs2Message.getHeaders().getAllHeaders();
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                mdnMuleMessage.setOutboundProperty(header.getName(), (Object)header.getValue());
            }
            if (mdnAs2Message.getData() != null) {
                byte[] data = IOUtils.toByteArray((InputStream)mdnAs2Message.getData().getInputStream());
                mdnMuleMessage.setOutboundProperty("Content-Length", (Object)Integer.toString(data.length));
                mdnMuleMessage.setPayload((Object)data);
            } else {
                mdnMuleMessage.setPayload((Object)"");
            }
            return mdnMuleMessage;
        }

        private final class SendAsyncReceiptWork
        implements Work {
            private final MuleEvent event;
            private final MuleMessage requestMuleMessage;
            private final byte[] payload;
            private final Agreement agreement;
            private final ServerConfig serverConfig;

            private SendAsyncReceiptWork(MuleEvent event, MuleMessage requestMuleMessage, byte[] payload, Agreement agreement, ServerConfig serverConfig) {
                this.event = event;
                this.requestMuleMessage = requestMuleMessage;
                this.payload = payload;
                this.agreement = agreement;
                this.serverConfig = serverConfig;
            }

            public void release() {
            }

            public void run() {
                try {
                    String asyncToUrl = (String)this.requestMuleMessage.getInboundProperty("Receipt-Delivery-Option");
                    AS2Result as2Result = Listener.this.processRequest(this.event, this.payload, this.agreement, this.serverConfig);
                    HttpPost httpPost = ServerFacade.this.messageMdnToHttpPost(asyncToUrl, as2Result.getMDN());
                    LoggingUtils.logOutgoingMessage(httpPost, "Sending AS2 async receipt to " + asyncToUrl, logger);
                    if (asyncToUrl.startsWith("https")) {
                        ServerFacade.this.sendReceiptOverHttps(asyncToUrl, as2Result);
                    } else {
                        ServerFacade.this.httpAsyncClient.execute(ServerFacade.this.messageMdnToHttpPost(asyncToUrl, as2Result.getMDN()), ServerFacade.this.asyncReceiptReplyFutureCallback);
                    }
                }
                catch (Throwable e) {
                    logger.error("An error occurred trying to process an AS2 request", e);
                }
            }
        }
    }
}

