/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.shade.client.methods;

import org.apache.http.shade.Header;
import org.apache.http.shade.HttpEntity;
import org.apache.http.shade.HttpEntityEnclosingRequest;
import org.apache.http.shade.annotation.NotThreadSafe;
import org.apache.http.shade.client.methods.HttpRequestBase;
import org.apache.http.shade.client.utils.CloneUtils;

@NotThreadSafe
public abstract class HttpEntityEnclosingRequestBase
extends HttpRequestBase
implements HttpEntityEnclosingRequest {
    private HttpEntity entity;

    @Override
    public HttpEntity getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    @Override
    public boolean expectContinue() {
        Header expect = this.getFirstHeader("Expect");
        return expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        HttpEntityEnclosingRequestBase clone = (HttpEntityEnclosingRequestBase)super.clone();
        if (this.entity != null) {
            clone.entity = CloneUtils.cloneObject(this.entity);
        }
        return clone;
    }
}

